/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.operation;

import java.io.Serializable;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.kyuubi.KyuubiSQLException;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.engine.spark.KyuubiSparkUtil$;
import org.apache.kyuubi.engine.spark.events.SparkOperationEvent$;
import org.apache.kyuubi.engine.spark.operation.SparkOperation;
import org.apache.kyuubi.events.EventLogging$;
import org.apache.kyuubi.operation.ArrayFetchIterator;
import org.apache.kyuubi.operation.FetchIterator;
import org.apache.kyuubi.operation.IterableFetchIterator;
import org.apache.kyuubi.operation.OperationState$;
import org.apache.kyuubi.operation.OperationType$;
import org.apache.kyuubi.operation.log.OperationLog;
import org.apache.kyuubi.operation.log.OperationLog$;
import org.apache.kyuubi.session.Session;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.util.ThreadUtils$;
import org.apache.spark.kyuubi.SQLOperationListener;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\r\u001b\u0001\u001dB\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!\r\u0005\tm\u0001\u0011)\u0019!C!o!AQ\t\u0001B\u0001B\u0003%\u0001\b\u0003\u0005G\u0001\t\u0015\r\u0011\"\u0011H\u0011!a\u0005A!A!\u0002\u0013A\u0005\u0002C'\u0001\u0005\u0003\u0005\u000b\u0011\u0002(\t\u0011E\u0003!\u0011!Q\u0001\n!CQA\u0015\u0001\u0005\u0002MCqA\u0017\u0001A\u0002\u0013%1\fC\u0004j\u0001\u0001\u0007I\u0011\u00026\t\rA\u0004\u0001\u0015)\u0003]\u0011\u001d\t\bA1A\u0005\nIDaA\u001f\u0001!\u0002\u0013\u0019\b\"B>\u0001\t\u0003b\bb\u0002@\u0001\u0005\u0004%Ia \u0005\t\u0003\u001b\u0001\u0001\u0015!\u0003\u0002\u0002!9\u0011q\u0002\u0001\u0005R\u0005E\u0001bBA\u0012\u0001\u0011E\u0013Q\u0005\u0005\b\u0003O\u0001A\u0011KA\u0013\u0011\u001d\tI\u0003\u0001C\u0005\u0003KAq!a\u000b\u0001\t#\n)\u0003C\u0004\u0002.\u0001!I!!\n\t\u000f\u0005=\u0002\u0001\"\u0011\u00022!9\u0011Q\u000b\u0001\u0005B\u0005]#\u0001E#yK\u000e,H/Z*uCR,W.\u001a8u\u0015\tYB$A\u0005pa\u0016\u0014\u0018\r^5p]*\u0011QDH\u0001\u0006gB\f'o\u001b\u0006\u0003?\u0001\na!\u001a8hS:,'BA\u0011#\u0003\u0019Y\u00170^;cS*\u00111\u0005J\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\n1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0015-!\tI#&D\u0001\u001b\u0013\tY#D\u0001\bTa\u0006\u00148n\u00149fe\u0006$\u0018n\u001c8\u0011\u00055rS\"\u0001\u0011\n\u0005=\u0002#a\u0002'pO\u001eLgnZ\u0001\bg\u0016\u001c8/[8o!\t\u0011D'D\u00014\u0015\t\u0001\u0004%\u0003\u00026g\t91+Z:tS>t\u0017!C:uCR,W.\u001a8u+\u0005A\u0004CA\u001dC\u001d\tQ\u0004\t\u0005\u0002<}5\tAH\u0003\u0002>M\u00051AH]8pizR\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003z\na\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011IP\u0001\u000bgR\fG/Z7f]R\u0004\u0013AD:i_VdGMU;o\u0003NLhnY\u000b\u0002\u0011B\u0011\u0011JS\u0007\u0002}%\u00111J\u0010\u0002\b\u0005>|G.Z1o\u0003=\u0019\bn\\;mIJ+h.Q:z]\u000e\u0004\u0013\u0001D9vKJLH+[7f_V$\bCA%P\u0013\t\u0001fH\u0001\u0003M_:<\u0017AE5oGJ,W.\u001a8uC2\u001cu\u000e\u001c7fGR\fa\u0001P5oSRtDC\u0002+V-^C\u0016\f\u0005\u0002*\u0001!)\u0001\u0007\u0003a\u0001c!)a\u0007\u0003a\u0001q!)a\t\u0003a\u0001\u0011\")Q\n\u0003a\u0001\u001d\")\u0011\u000b\u0003a\u0001\u0011\u000692\u000f^1uK6,g\u000e\u001e+j[\u0016|W\u000f^\"mK\u0006tWM]\u000b\u00029B\u0019\u0011*X0\n\u0005ys$AB(qi&|g\u000e\u0005\u0002aO6\t\u0011M\u0003\u0002cG\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\u0011,\u0017\u0001B;uS2T\u0011AZ\u0001\u0005U\u00064\u0018-\u0003\u0002iC\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u00027M$\u0018\r^3nK:$H+[7f_V$8\t\\3b]\u0016\u0014x\fJ3r)\tYg\u000e\u0005\u0002JY&\u0011QN\u0010\u0002\u0005+:LG\u000fC\u0004p\u0015\u0005\u0005\t\u0019\u0001/\u0002\u0007a$\u0013'\u0001\rti\u0006$X-\\3oiRKW.Z8vi\u000ecW-\u00198fe\u0002\nAb\u001c9fe\u0006$\u0018n\u001c8M_\u001e,\u0012a\u001d\t\u0003ibl\u0011!\u001e\u0006\u0003m^\f1\u0001\\8h\u0015\tY\u0002%\u0003\u0002zk\naq\n]3sCRLwN\u001c'pO\u0006iq\u000e]3sCRLwN\u001c'pO\u0002\nqbZ3u\u001fB,'/\u0019;j_:dunZ\u000b\u0002{B\u0019\u0011*X:\u0002#=\u0004XM]1uS>tG*[:uK:,'/\u0006\u0002\u0002\u0002A!\u00111AA\u0005\u001b\t\t)AC\u0002\"\u0003\u000fQ!!\b\u0012\n\t\u0005-\u0011Q\u0001\u0002\u0015'Fcu\n]3sCRLwN\u001c'jgR,g.\u001a:\u0002%=\u0004XM]1uS>tG*[:uK:,'\u000fI\u0001\re\u0016\u001cX\u000f\u001c;TG\",W.Y\u000b\u0003\u0003'\u0001B!!\u0006\u0002 5\u0011\u0011q\u0003\u0006\u0005\u00033\tY\"A\u0003usB,7O\u0003\u0003\u0002\u001e\u0005\u001d\u0011aA:rY&!\u0011\u0011EA\f\u0005)\u0019FO];diRK\b/Z\u0001\nE\u00164wN]3Sk:$\u0012a[\u0001\tC\u001a$XM\u001d*v]\u0006\u0001R\r_3dkR,7\u000b^1uK6,g\u000e^\u0001\feVt\u0017J\u001c;fe:\fG.A\tbI\u0012$\u0016.\\3pkRluN\\5u_J\fqa\u00197fC:,\b\u000fF\u0002l\u0003gAq!!\u000e\u0018\u0001\u0004\t9$A\u0006uCJ<W\r^*uCR,\u0007\u0003BA\u001d\u0003\u001frA!a\u000f\u0002L9!\u0011QHA%\u001d\u0011\ty$a\u0012\u000f\t\u0005\u0005\u0013Q\t\b\u0004w\u0005\r\u0013\"A\u0013\n\u0005\r\"\u0013BA\u0011#\u0013\tY\u0002%C\u0002\u0002N]\fab\u00149fe\u0006$\u0018n\u001c8Ti\u0006$X-\u0003\u0003\u0002R\u0005M#AD(qKJ\fG/[8o'R\fG/\u001a\u0006\u0004\u0003\u001b:\u0018\u0001C:fiN#\u0018\r^3\u0015\u0007-\fI\u0006C\u0004\u0002\\a\u0001\r!a\u000e\u0002\u00119,wo\u0015;bi\u0016\u0004")
public class ExecuteStatement
extends SparkOperation {
    private final Session session;
    private final String statement;
    private final boolean shouldRunAsync;
    private final long queryTimeout;
    private final boolean incrementalCollect;
    private Option<ScheduledExecutorService> statementTimeoutCleaner;
    private final OperationLog org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog;
    private final SQLOperationListener operationListener;

    @Override
    public String statement() {
        return this.statement;
    }

    @Override
    public boolean shouldRunAsync() {
        return this.shouldRunAsync;
    }

    private Option<ScheduledExecutorService> statementTimeoutCleaner() {
        return this.statementTimeoutCleaner;
    }

    private void statementTimeoutCleaner_$eq(Option<ScheduledExecutorService> x$1) {
        this.statementTimeoutCleaner = x$1;
    }

    public OperationLog org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog() {
        return this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog;
    }

    @Override
    public Option<OperationLog> getOperationLog() {
        return Option$.MODULE$.apply((Object)this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog());
    }

    private SQLOperationListener operationListener() {
        return this.operationListener;
    }

    @Override
    public StructType resultSchema() {
        return this.result() == null || this.result().schema().isEmpty() ? new StructType().add("Result", "string") : this.result().schema();
    }

    @Override
    public void beforeRun() {
        OperationLog$.MODULE$.setCurrentOperationLog(this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog());
        this.setState(OperationState$.MODULE$.PENDING());
        this.setHasResultSet(true);
    }

    @Override
    public void afterRun() {
        OperationLog$.MODULE$.removeCurrentOperationLog();
    }

    public void org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$executeStatement() {
        this.withLocalProperties((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block8: {
                try {
                    try {
                        FetchIterator fetchIterator;
                        this.setState(OperationState$.MODULE$.RUNNING());
                        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> KyuubiSparkUtil$.MODULE$.diagnostics());
                        Thread.currentThread().setContextClassLoader((ClassLoader)this.spark().sharedState().jarClassLoader());
                        this.spark().sparkContext().addSparkListener((SparkListenerInterface)this.operationListener());
                        this.result_$eq((Dataset<Row>)this.spark().sql(this.statement()));
                        this.setState(OperationState$.MODULE$.COMPILED());
                        this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> this.result().queryExecution());
                        if ($this.incrementalCollect) {
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Execute in incremental collect mode");
                            fetchIterator = new IterableFetchIterator(((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(this.result().toLocalIterator()).asScala()).toIterable());
                        } else {
                            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Execute in full collect mode");
                            fetchIterator = new ArrayFetchIterator(this.result().collect());
                        }
                        this.iter_$eq(fetchIterator);
                        this.setState(OperationState$.MODULE$.FINISHED());
                    }
                    catch (Throwable x$1) {
                        PartialFunction<Throwable, BoxedUnit> catchExpr$1 = this.onError(true);
                        if (catchExpr$1.isDefinedAt((Object)x$1)) {
                            catchExpr$1.apply((Object)x$1);
                            break block8;
                        }
                        throw x$1;
                    }
                }
                finally {
                    this.statementTimeoutCleaner().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                        x$2.shutdown();
                        return BoxedUnit.UNIT;
                    });
                }
            }
        });
    }

    @Override
    public void runInternal() {
        this.addTimeoutMonitor();
        if (this.shouldRunAsync()) {
            Runnable asyncOperation = new Runnable(this){
                private final /* synthetic */ ExecuteStatement $outer;

                public void run() {
                    OperationLog$.MODULE$.setCurrentOperationLog(this.$outer.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog());
                    this.$outer.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$executeStatement();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            try {
                SessionManager sparkSQLSessionManager = this.session.sessionManager();
                Future<?> backgroundHandle = sparkSQLSessionManager.submitBackgroundOperation(asyncOperation);
                this.setBackgroundHandle(backgroundHandle);
            }
            catch (RejectedExecutionException rejected) {
                this.setState(OperationState$.MODULE$.ERROR());
                KyuubiSQLException ke = KyuubiSQLException$.MODULE$.apply("Error submitting query in background, query rejected", rejected, KyuubiSQLException$.MODULE$.apply$default$3(), KyuubiSQLException$.MODULE$.apply$default$4());
                this.setOperationException(ke);
                throw ke;
            }
        } else {
            this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$executeStatement();
        }
    }

    private void addTimeoutMonitor() {
        block0: {
            if (this.queryTimeout <= 0L) break block0;
            ScheduledExecutorService timeoutExecutor = ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("query-timeout-thread");
            timeoutExecutor.schedule(new Runnable(this){
                private final /* synthetic */ ExecuteStatement $outer;

                public void run() {
                    this.$outer.cleanup(OperationState$.MODULE$.TIMEOUT());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, this.queryTimeout, TimeUnit.SECONDS);
            this.statementTimeoutCleaner_$eq((Option<ScheduledExecutorService>)new Some((Object)timeoutExecutor));
        }
    }

    @Override
    public void cleanup(Enumeration.Value targetState) {
        this.spark().sparkContext().removeSparkListener((SparkListenerInterface)this.operationListener());
        super.cleanup(targetState);
    }

    @Override
    public void setState(Enumeration.Value newState) {
        super.setState(newState);
        EventLogging$.MODULE$.onEvent(SparkOperationEvent$.MODULE$.apply(this, this.operationListener().getExecutionId()));
    }

    public ExecuteStatement(Session session, String statement, boolean shouldRunAsync, long queryTimeout, boolean incrementalCollect) {
        this.session = session;
        this.statement = statement;
        this.shouldRunAsync = shouldRunAsync;
        this.queryTimeout = queryTimeout;
        this.incrementalCollect = incrementalCollect;
        super(OperationType$.MODULE$.EXECUTE_STATEMENT(), session);
        this.statementTimeoutCleaner = None$.MODULE$;
        this.org$apache$kyuubi$engine$spark$operation$ExecuteStatement$$operationLog = OperationLog$.MODULE$.createOperationLog(session, this.getHandle());
        this.operationListener = new SQLOperationListener(this, this.spark());
        EventLogging$.MODULE$.onEvent(SparkOperationEvent$.MODULE$.apply(this, SparkOperationEvent$.MODULE$.apply$default$2()));
    }
}

