/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.engine.spark.session;

import java.io.Serializable;
import java.nio.file.Path;
import org.apache.hive.service.rpc.thrift.TProtocolVersion;
import org.apache.kyuubi.KyuubiSQLException$;
import org.apache.kyuubi.Utils$;
import org.apache.kyuubi.config.KyuubiConf;
import org.apache.kyuubi.config.KyuubiConf$;
import org.apache.kyuubi.engine.ShareLevel$;
import org.apache.kyuubi.engine.spark.SparkSQLEngine$;
import org.apache.kyuubi.engine.spark.operation.SparkSQLOperationManager;
import org.apache.kyuubi.engine.spark.session.SparkSessionImpl;
import org.apache.kyuubi.session.SessionHandle;
import org.apache.kyuubi.session.SessionManager;
import org.apache.kyuubi.session.package$;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y4A!\u0004\b\u00017!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005\u0012\u0001\t\u0005\t\u0015!\u00030\u0011\u00151\u0004\u0001\"\u00038\u0011\u00151\u0004\u0001\"\u0001=\u0011\u0015q\u0004\u0001\"\u0011@\u0011\u001da\u0005A1A\u0005\u00025Ca\u0001\u0016\u0001!\u0002\u0013q\u0005\u0002C+\u0001\u0011\u000b\u0007I\u0011\u0002,\t\u000bi\u0003A\u0011I.\t\u000b]\u0004A\u0011\t=\t\u000bm\u0004A\u0011\u0002?\t\u000bu\u0004A\u0011\u000b,\u0003-M\u0003\u0018M]6T#2\u001bVm]:j_:l\u0015M\\1hKJT!a\u0004\t\u0002\u000fM,7o]5p]*\u0011\u0011CE\u0001\u0006gB\f'o\u001b\u0006\u0003'Q\ta!\u001a8hS:,'BA\u000b\u0017\u0003\u0019Y\u00170^;cS*\u0011q\u0003G\u0001\u0007CB\f7\r[3\u000b\u0003e\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u000f\u0011\u0005uyR\"\u0001\u0010\u000b\u0005=!\u0012B\u0001\u0011\u001f\u00059\u0019Vm]:j_:l\u0015M\\1hKJ\fAA\\1nKB\u00111\u0005\f\b\u0003I)\u0002\"!\n\u0015\u000e\u0003\u0019R!a\n\u000e\u0002\rq\u0012xn\u001c;?\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016)\u0003\u0019\u0001&/\u001a3fM&\u0011QF\f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005-B\u0003C\u0001\u00195\u001b\u0005\t$B\u0001\u001a4\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003#YI!!N\u0019\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\rqJg.\u001b;?)\rA$h\u000f\t\u0003s\u0001i\u0011A\u0004\u0005\u0006C\r\u0001\rA\t\u0005\u0006#\r\u0001\ra\f\u000b\u0003quBQ!\u0005\u0003A\u0002=\n!\"\u001b8ji&\fG.\u001b>f)\t\u0001E\t\u0005\u0002B\u00056\t\u0001&\u0003\u0002DQ\t!QK\\5u\u0011\u0015)U\u00011\u0001G\u0003\u0011\u0019wN\u001c4\u0011\u0005\u001dSU\"\u0001%\u000b\u0005%#\u0012AB2p]\u001aLw-\u0003\u0002L\u0011\nQ1*_;vE&\u001cuN\u001c4\u0002!=\u0004XM]1uS>tW*\u00198bO\u0016\u0014X#\u0001(\u0011\u0005=\u0013V\"\u0001)\u000b\u0005E\u0003\u0012!C8qKJ\fG/[8o\u0013\t\u0019\u0006K\u0001\rTa\u0006\u00148nU)M\u001fB,'/\u0019;j_:l\u0015M\\1hKJ\f\u0011c\u001c9fe\u0006$\u0018n\u001c8NC:\fw-\u001a:!\u0003I\u0019\u0018N\\4mKN\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0016\u0003]\u0003\"!\u0011-\n\u0005eC#a\u0002\"p_2,\u0017M\\\u0001\f_B,gnU3tg&|g\u000e\u0006\u0004]?6|\u0017o\u001d\t\u0003;uK!A\u0018\u0010\u0003\u001bM+7o]5p]\"\u000bg\u000e\u001a7f\u0011\u0015\u0001\u0017\u00021\u0001b\u0003!\u0001(o\u001c;pG>d\u0007C\u00012l\u001b\u0005\u0019'B\u00013f\u0003\u0019!\bN]5gi*\u0011amZ\u0001\u0004eB\u001c'B\u00015j\u0003\u001d\u0019XM\u001d<jG\u0016T!A\u001b\f\u0002\t!Lg/Z\u0005\u0003Y\u000e\u0014\u0001\u0003\u0016)s_R|7m\u001c7WKJ\u001c\u0018n\u001c8\t\u000b9L\u0001\u0019\u0001\u0012\u0002\tU\u001cXM\u001d\u0005\u0006a&\u0001\rAI\u0001\ta\u0006\u001c8o^8sI\")!/\u0003a\u0001E\u0005I\u0011\u000e]!eIJ,7o\u001d\u0005\u0006\u000b&\u0001\r\u0001\u001e\t\u0005GU\u0014#%\u0003\u0002w]\t\u0019Q*\u00199\u0002\u0019\rdwn]3TKN\u001c\u0018n\u001c8\u0015\u0005\u0001K\b\"\u0002>\u000b\u0001\u0004a\u0016!D:fgNLwN\u001c%b]\u0012dW-A\u0006ti>\u00048+Z:tS>tG#\u0001!\u0002\u0011%\u001c8+\u001a:wKJ\u0004")
public class SparkSQLSessionManager
extends SessionManager {
    private boolean singleSparkSession;
    private final SparkSession spark;
    private final SparkSQLOperationManager operationManager;
    private volatile boolean bitmap$0;

    @Override
    public void initialize(KyuubiConf conf) {
        Path absPath = Utils$.MODULE$.getAbsolutePathFromWork(conf.get(KyuubiConf$.MODULE$.ENGINE_OPERATION_LOG_DIR_ROOT()), Utils$.MODULE$.getAbsolutePathFromWork$default$2());
        this._operationLogRoot_$eq((Option<String>)new Some((Object)((Object)absPath.toAbsolutePath()).toString()));
        super.initialize(conf);
    }

    @Override
    public SparkSQLOperationManager operationManager() {
        return this.operationManager;
    }

    private boolean singleSparkSession$lzycompute() {
        SparkSQLSessionManager sparkSQLSessionManager = this;
        synchronized (sparkSQLSessionManager) {
            if (!this.bitmap$0) {
                this.singleSparkSession = BoxesRunTime.unboxToBoolean((Object)this.conf().get(KyuubiConf$.MODULE$.ENGINE_SINGLE_SPARK_SESSION()));
                this.bitmap$0 = true;
            }
        }
        return this.singleSparkSession;
    }

    private boolean singleSparkSession() {
        return !this.bitmap$0 ? this.singleSparkSession$lzycompute() : this.singleSparkSession;
    }

    @Override
    public SessionHandle openSession(TProtocolVersion protocol, String user, String password, String ipAddress, Map<String, String> conf) {
        SessionHandle sessionHandle;
        SparkSession sparkSession;
        String clientIp = (String)conf.getOrElse((Object)package$.MODULE$.CLIENT_IP_KEY(), (Function0 & Serializable & scala.Serializable)() -> ipAddress);
        this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Opening session for ").append(user).append("@").append(clientIp).toString());
        try {
            if (this.singleSparkSession()) {
                sparkSession = this.spark;
            } else {
                SparkSession ss = this.spark.newSession();
                ((IterableLike)this.conf().get(KyuubiConf$.MODULE$.ENGINE_SESSION_INITIALIZE_SQL())).foreach((Function1 & Serializable & scala.Serializable)sqlStr -> {
                    SparkSQLSessionManager.$anonfun$openSession$3(this, ss, sqlStr);
                    return BoxedUnit.UNIT;
                });
                sparkSession = ss;
            }
        }
        catch (Exception e) {
            throw KyuubiSQLException$.MODULE$.apply(e);
        }
        SparkSession sparkSession2 = sparkSession;
        SparkSessionImpl session = new SparkSessionImpl(protocol, user, password, ipAddress, clientIp, conf, this, sparkSession2);
        try {
            SessionHandle handle = session.handle();
            session.open();
            this.setSession(handle, session);
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append(user).append("'s session with ").append(handle).append(" is opened, current opening sessions").append(" ").append(this.getOpenSessionCount()).toString());
            sessionHandle = handle;
        }
        catch (Exception e) {
            session.close();
            throw KyuubiSQLException$.MODULE$.apply(e);
        }
        return sessionHandle;
    }

    @Override
    public void closeSession(SessionHandle sessionHandle) {
        block0: {
            super.closeSession(sessionHandle);
            String string = this.conf().get(KyuubiConf$.MODULE$.ENGINE_SHARE_LEVEL());
            String string2 = ShareLevel$.MODULE$.CONNECTION().toString();
            if (string != null ? !string.equals(string2) : string2 != null) break block0;
            this.info((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> "Session stopped due to shared level is Connection.");
            this.stopSession();
        }
    }

    private void stopSession() {
        SparkSQLEngine$.MODULE$.currentEngine().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.stop();
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public boolean isServer() {
        return false;
    }

    public static final /* synthetic */ void $anonfun$openSession$3(SparkSQLSessionManager $this, SparkSession ss$1, String sqlStr) {
        ss$1.sparkContext().setJobGroup("engine_initializing_queries", sqlStr, true);
        $this.debug((Function0<Object>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Execute session initializing sql: ").append(sqlStr).toString());
        ss$1.sql(sqlStr).isEmpty();
        ss$1.sparkContext().clearJobGroup();
    }

    private SparkSQLSessionManager(String name, SparkSession spark) {
        this.spark = spark;
        super(name);
        this.operationManager = new SparkSQLOperationManager();
    }

    public SparkSQLSessionManager(SparkSession spark) {
        this(SparkSQLSessionManager.class.getSimpleName(), spark);
    }
}

