/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.shade.io.vertx.core;

import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.kyuubi.shade.io.netty.channel.EventLoopGroup;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.CacheReturn;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.Fluent;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.GenIgnore;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.Nullable;
import org.apache.kyuubi.shade.io.vertx.codegen.annotations.VertxGen;
import org.apache.kyuubi.shade.io.vertx.core.AsyncResult;
import org.apache.kyuubi.shade.io.vertx.core.Context;
import org.apache.kyuubi.shade.io.vertx.core.DeploymentOptions;
import org.apache.kyuubi.shade.io.vertx.core.Future;
import org.apache.kyuubi.shade.io.vertx.core.Handler;
import org.apache.kyuubi.shade.io.vertx.core.Promise;
import org.apache.kyuubi.shade.io.vertx.core.TimeoutStream;
import org.apache.kyuubi.shade.io.vertx.core.Verticle;
import org.apache.kyuubi.shade.io.vertx.core.VertxOptions;
import org.apache.kyuubi.shade.io.vertx.core.WorkerExecutor;
import org.apache.kyuubi.shade.io.vertx.core.datagram.DatagramSocket;
import org.apache.kyuubi.shade.io.vertx.core.datagram.DatagramSocketOptions;
import org.apache.kyuubi.shade.io.vertx.core.dns.DnsClient;
import org.apache.kyuubi.shade.io.vertx.core.dns.DnsClientOptions;
import org.apache.kyuubi.shade.io.vertx.core.eventbus.EventBus;
import org.apache.kyuubi.shade.io.vertx.core.file.FileSystem;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClient;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpClientOptions;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpServer;
import org.apache.kyuubi.shade.io.vertx.core.http.HttpServerOptions;
import org.apache.kyuubi.shade.io.vertx.core.impl.ContextInternal;
import org.apache.kyuubi.shade.io.vertx.core.impl.VertxBuilder;
import org.apache.kyuubi.shade.io.vertx.core.metrics.Measured;
import org.apache.kyuubi.shade.io.vertx.core.net.NetClient;
import org.apache.kyuubi.shade.io.vertx.core.net.NetClientOptions;
import org.apache.kyuubi.shade.io.vertx.core.net.NetServer;
import org.apache.kyuubi.shade.io.vertx.core.net.NetServerOptions;
import org.apache.kyuubi.shade.io.vertx.core.shareddata.SharedData;
import org.apache.kyuubi.shade.io.vertx.core.spi.VerticleFactory;

@VertxGen
public interface Vertx
extends Measured {
    public static Vertx vertx() {
        return Vertx.vertx(new VertxOptions());
    }

    public static Vertx vertx(VertxOptions options) {
        return new VertxBuilder(options).init().vertx();
    }

    public static void clusteredVertx(VertxOptions options, Handler<AsyncResult<Vertx>> resultHandler) {
        new VertxBuilder(options).init().clusteredVertx(resultHandler);
    }

    public static Future<Vertx> clusteredVertx(VertxOptions options) {
        Promise<Vertx> promise = Promise.promise();
        Vertx.clusteredVertx(options, promise);
        return promise.future();
    }

    public static @Nullable Context currentContext() {
        return ContextInternal.current();
    }

    public Context getOrCreateContext();

    public NetServer createNetServer(NetServerOptions var1);

    default public NetServer createNetServer() {
        return this.createNetServer(new NetServerOptions());
    }

    public NetClient createNetClient(NetClientOptions var1);

    default public NetClient createNetClient() {
        return this.createNetClient(new NetClientOptions());
    }

    public HttpServer createHttpServer(HttpServerOptions var1);

    default public HttpServer createHttpServer() {
        return this.createHttpServer(new HttpServerOptions());
    }

    public HttpClient createHttpClient(HttpClientOptions var1);

    default public HttpClient createHttpClient() {
        return this.createHttpClient(new HttpClientOptions());
    }

    public DatagramSocket createDatagramSocket(DatagramSocketOptions var1);

    default public DatagramSocket createDatagramSocket() {
        return this.createDatagramSocket(new DatagramSocketOptions());
    }

    @CacheReturn
    public FileSystem fileSystem();

    @CacheReturn
    public EventBus eventBus();

    public DnsClient createDnsClient(int var1, String var2);

    public DnsClient createDnsClient();

    public DnsClient createDnsClient(DnsClientOptions var1);

    @CacheReturn
    public SharedData sharedData();

    public long setTimer(long var1, Handler<Long> var3);

    public TimeoutStream timerStream(long var1);

    public long setPeriodic(long var1, Handler<Long> var3);

    public TimeoutStream periodicStream(long var1);

    public boolean cancelTimer(long var1);

    public void runOnContext(Handler<Void> var1);

    public Future<Void> close();

    public void close(Handler<AsyncResult<Void>> var1);

    @GenIgnore(value={"permitted-type"})
    default public Future<String> deployVerticle(Verticle verticle) {
        return this.deployVerticle(verticle, new DeploymentOptions());
    }

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, Handler<AsyncResult<String>> var2);

    @GenIgnore(value={"permitted-type"})
    public Future<String> deployVerticle(Verticle var1, DeploymentOptions var2);

    @GenIgnore
    public Future<String> deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public Future<String> deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Verticle var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore
    public void deployVerticle(Class<? extends Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    @GenIgnore(value={"permitted-type"})
    public void deployVerticle(Supplier<Verticle> var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    default public Future<String> deployVerticle(String name) {
        return this.deployVerticle(name, new DeploymentOptions());
    }

    default public void deployVerticle(String name, Handler<AsyncResult<String>> completionHandler) {
        this.deployVerticle(name, new DeploymentOptions(), completionHandler);
    }

    public Future<String> deployVerticle(String var1, DeploymentOptions var2);

    public void deployVerticle(String var1, DeploymentOptions var2, Handler<AsyncResult<String>> var3);

    public Future<Void> undeploy(String var1);

    public void undeploy(String var1, Handler<AsyncResult<Void>> var2);

    public Set<String> deploymentIDs();

    @GenIgnore(value={"permitted-type"})
    public void registerVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public void unregisterVerticleFactory(VerticleFactory var1);

    @GenIgnore(value={"permitted-type"})
    public Set<VerticleFactory> verticleFactories();

    public boolean isClustered();

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered, Handler<AsyncResult<@Nullable T>> resultHandler) {
        Context context = this.getOrCreateContext();
        context.executeBlocking(blockingCodeHandler, ordered, resultHandler);
    }

    default public <T> void executeBlocking(Handler<Promise<T>> blockingCodeHandler, Handler<AsyncResult<@Nullable T>> resultHandler) {
        this.executeBlocking(blockingCodeHandler, true, resultHandler);
    }

    default public <T> Future<@Nullable T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, boolean ordered) {
        Context context = this.getOrCreateContext();
        return context.executeBlocking(blockingCodeHandler, ordered);
    }

    default public <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler) {
        return this.executeBlocking(blockingCodeHandler, true);
    }

    @GenIgnore(value={"permitted-type"})
    public EventLoopGroup nettyEventLoopGroup();

    public WorkerExecutor createSharedWorkerExecutor(String var1);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3);

    public WorkerExecutor createSharedWorkerExecutor(String var1, int var2, long var3, TimeUnit var5);

    @CacheReturn
    public boolean isNativeTransportEnabled();

    @Fluent
    public Vertx exceptionHandler(@Nullable Handler<Throwable> var1);

    @GenIgnore
    public @Nullable Handler<Throwable> exceptionHandler();
}

