/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.StringValue;
import org.apache.solr.analytics.value.StringValueStream;

class StringValueStringStreamInStringStreamOutFunction
extends StringValueStream.AbstractStringValueStream {
    private final StringValue param1;
    private final StringValueStream param2;
    private final LambdaFunction.TwoStringInStringOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public StringValueStringStreamInStringStreamOutFunction(String name, LambdaFunction.TwoStringInStringOutLambda lambda, StringValue param1, StringValueStream param2) {
        this.name = name;
        this.lambda = lambda;
        this.param1 = param1;
        this.param2 = param2;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
    }

    @Override
    public void streamStrings(Consumer<String> cons) {
        String value1 = this.param1.getString();
        if (this.param1.exists()) {
            this.param2.streamStrings(value2 -> cons.accept(this.lambda.apply(value1, (String)value2)));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

