/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.DoubleConsumer;
import org.apache.solr.analytics.function.mapping.LambdaFunction;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;

class DoubleValueDoubleStreamInDoubleStreamOutFunction
extends DoubleValueStream.AbstractDoubleValueStream {
    private final DoubleValue param1;
    private final DoubleValueStream param2;
    private final LambdaFunction.TwoDoubleInDoubleOutLambda lambda;
    private final String name;
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public DoubleValueDoubleStreamInDoubleStreamOutFunction(String name, LambdaFunction.TwoDoubleInDoubleOutLambda lambda, DoubleValue param1, DoubleValueStream param2) {
        this.name = name;
        this.lambda = lambda;
        this.param1 = param1;
        this.param2 = param2;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, param1, param2);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, param1, param2);
    }

    @Override
    public void streamDoubles(DoubleConsumer cons) {
        double value1 = this.param1.getDouble();
        if (this.param1.exists()) {
            this.param2.streamDoubles(value2 -> cons.accept(this.lambda.apply(value1, value2)));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

