/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.scriptengine;

import org.apache.manifoldcf.core.util.URLEncoder;
import org.apache.manifoldcf.scriptengine.ScriptException;
import org.apache.manifoldcf.scriptengine.Variable;
import org.apache.manifoldcf.scriptengine.VariableBase;
import org.apache.manifoldcf.scriptengine.VariableBoolean;
import org.apache.manifoldcf.scriptengine.VariableReference;

public class VariableConnectionName
extends VariableBase {
    protected String encodedConnectionName;
    protected String connectionName;

    public VariableConnectionName(String connectionName) {
        this.connectionName = connectionName;
        this.encodedConnectionName = VariableConnectionName.encode(connectionName);
    }

    public int hashCode() {
        return this.connectionName.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof VariableConnectionName)) {
            return false;
        }
        return ((VariableConnectionName)o).connectionName.equals(this.connectionName);
    }

    @Override
    public boolean hasScriptValue() throws ScriptException {
        return true;
    }

    @Override
    public String getScriptValue() throws ScriptException {
        StringBuilder sb = new StringBuilder();
        sb.append("(new connectionname \"");
        int i = 0;
        while (i < this.connectionName.length()) {
            char x;
            if ((x = this.connectionName.charAt(i++)) == '\\' || x == '\"') {
                sb.append('\\');
            }
            sb.append(x);
        }
        sb.append("\")");
        return sb.toString();
    }

    @Override
    public boolean hasURLPathValue() throws ScriptException {
        return true;
    }

    @Override
    public String getURLPathValue() throws ScriptException {
        return URLEncoder.encode((String)this.encodedConnectionName).replace("+", "%20");
    }

    @Override
    public boolean hasStringValue() throws ScriptException {
        return true;
    }

    @Override
    public String getStringValue() throws ScriptException {
        return this.encodedConnectionName;
    }

    @Override
    public VariableReference doubleEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '==' operand cannot be null"));
        }
        return new VariableBoolean(this.encodedConnectionName.equals(v.getStringValue()));
    }

    @Override
    public VariableReference exclamationEquals(Variable v) throws ScriptException {
        if (v == null) {
            throw new ScriptException(this.composeMessage("Binary '!=' operand cannot be null"));
        }
        return new VariableBoolean(!this.encodedConnectionName.equals(v.getStringValue()));
    }

    protected static String encode(String connectionName) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < connectionName.length()) {
            char x;
            if ((x = connectionName.charAt(i++)) == '/') {
                sb.append('.').append('+');
                continue;
            }
            if (x == '.') {
                sb.append('.').append('.');
                continue;
            }
            sb.append(x);
        }
        return sb.toString();
    }
}

