/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.jobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.manifoldcf.core.database.BaseTable;
import org.apache.manifoldcf.core.interfaces.ClauseDescription;
import org.apache.manifoldcf.core.interfaces.ColumnDescription;
import org.apache.manifoldcf.core.interfaces.IDBInterface;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IResultRow;
import org.apache.manifoldcf.core.interfaces.IResultSet;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.IndexDescription;
import org.apache.manifoldcf.core.interfaces.JoinClause;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.MultiClause;
import org.apache.manifoldcf.core.interfaces.UnitaryClause;
import org.apache.manifoldcf.crawler.jobs.DeleteDependency;
import org.apache.manifoldcf.crawler.jobs.HopDeleteDeps;
import org.apache.manifoldcf.crawler.jobs.IntrinsicLink;
import org.apache.manifoldcf.crawler.system.Logging;

public class HopCount
extends BaseTable {
    public static final String _rcsid = "@(#)$Id: HopCount.java 988245 2010-08-23 18:39:35Z kwright $";
    public static final int ANSWER_UNKNOWN = -1;
    public static final int ANSWER_INFINITY = -2;
    public static final String idField = "id";
    public static final String jobIDField = "jobid";
    public static final String linkTypeField = "linktype";
    public static final String parentIDHashField = "parentidhash";
    public static final String distanceField = "distance";
    public static final String markForDeathField = "deathmark";
    public static final int MARK_NORMAL = 0;
    public static final int MARK_QUEUED = 1;
    public static final int MARK_DELETING = 2;
    protected static Map markMap = new HashMap();
    protected IntrinsicLink intrinsicLinkManager;
    protected HopDeleteDeps deleteDepsManager;
    protected IThreadContext threadContext;

    public HopCount(IThreadContext tc, IDBInterface database) throws ManifoldCFException {
        super(database, "hopcount");
        this.threadContext = tc;
        this.intrinsicLinkManager = new IntrinsicLink(database);
        this.deleteDepsManager = new HopDeleteDeps(database);
    }

    public void install(String jobsTable, String jobsColumn) throws ManifoldCFException {
        block5: {
            Map existing = this.getTableSchema(null, null);
            if (existing == null) {
                HashMap<String, ColumnDescription> map = new HashMap<String, ColumnDescription>();
                map.put(idField, new ColumnDescription("BIGINT", true, false, null, null, false));
                map.put(jobIDField, new ColumnDescription("BIGINT", false, false, jobsTable, jobsColumn, false));
                map.put(linkTypeField, new ColumnDescription("VARCHAR(255)", false, true, null, null, false));
                map.put(parentIDHashField, new ColumnDescription("VARCHAR(40)", false, false, null, null, false));
                map.put(distanceField, new ColumnDescription("BIGINT", false, true, null, null, false));
                map.put(markForDeathField, new ColumnDescription("CHAR(1)", false, false, null, null, false));
                this.performCreate(map, null);
            }
            this.intrinsicLinkManager.install(jobsTable, jobsColumn);
            this.deleteDepsManager.install(jobsTable, jobsColumn, this.getTableName(), idField);
            IndexDescription jobLinktypeParentIndex = new IndexDescription(true, new String[]{jobIDField, parentIDHashField, linkTypeField});
            IndexDescription jobDeathIndex = new IndexDescription(false, new String[]{jobIDField, markForDeathField, parentIDHashField, linkTypeField});
            Map indexes = this.getTableIndexes(null, null);
            for (String indexName : indexes.keySet()) {
                IndexDescription id = (IndexDescription)indexes.get(indexName);
                if (jobLinktypeParentIndex != null && id.equals((Object)jobLinktypeParentIndex)) {
                    jobLinktypeParentIndex = null;
                    continue;
                }
                if (jobDeathIndex != null && id.equals((Object)jobDeathIndex)) {
                    jobDeathIndex = null;
                    continue;
                }
                if (indexName.indexOf("_pkey") != -1) continue;
                this.performRemoveIndex(indexName);
            }
            if (jobLinktypeParentIndex != null) {
                this.performAddIndex(null, jobLinktypeParentIndex);
            }
            if (jobDeathIndex == null) break block5;
            this.performAddIndex(null, jobDeathIndex);
        }
    }

    public void deinstall() throws ManifoldCFException {
        this.beginTransaction();
        try {
            this.deleteDepsManager.deinstall();
            this.intrinsicLinkManager.deinstall();
            this.performDrop(null);
        }
        catch (ManifoldCFException e) {
            this.signalRollback();
            throw e;
        }
        catch (Error e) {
            this.signalRollback();
            throw e;
        }
        finally {
            this.endTransaction();
        }
    }

    public static int stringToMark(String value) throws ManifoldCFException {
        Integer x = (Integer)markMap.get(value);
        if (x == null) {
            throw new ManifoldCFException("Bad mark value: '" + value + "'");
        }
        return x;
    }

    public static String markToString(int mark) throws ManifoldCFException {
        switch (mark) {
            case 0: {
                return "N";
            }
            case 1: {
                return "Q";
            }
            case 2: {
                return "D";
            }
        }
        throw new ManifoldCFException("Bad mark value");
    }

    public void deleteOwner(Long jobID) throws ManifoldCFException {
        this.intrinsicLinkManager.deleteOwner(jobID);
        this.deleteDepsManager.deleteJob(jobID);
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID)});
        this.performDelete("WHERE " + query, list, null);
        this.noteModifications(0, 0, 1);
    }

    public void restart(String processID) throws ManifoldCFException {
        this.intrinsicLinkManager.restart(processID);
    }

    public void restart() throws ManifoldCFException {
        this.intrinsicLinkManager.restart();
    }

    public void restartCluster() throws ManifoldCFException {
        this.intrinsicLinkManager.restartCluster();
    }

    public void recordSeedReferences(Long jobID, String[] legalLinkTypes, String[] targetDocumentIDHashes, int hopcountMethod, String processID) throws ManifoldCFException {
        this.doRecord(jobID, legalLinkTypes, "", targetDocumentIDHashes, "", hopcountMethod, processID);
    }

    public void finishSeedReferences(Long jobID, String[] legalLinkTypes, int hopcountMethod) throws ManifoldCFException {
        this.doFinish(jobID, legalLinkTypes, new String[]{""}, hopcountMethod);
    }

    public boolean recordReference(Long jobID, String[] legalLinkTypes, String sourceDocumentIDHash, String targetDocumentIDHash, String linkType, int hopcountMethod, String processID) throws ManifoldCFException {
        return this.doRecord(jobID, legalLinkTypes, sourceDocumentIDHash, new String[]{targetDocumentIDHash}, linkType, hopcountMethod, processID)[0];
    }

    public boolean[] recordReferences(Long jobID, String[] legalLinkTypes, String sourceDocumentIDHash, String[] targetDocumentIDHashes, String linkType, int hopcountMethod, String processID) throws ManifoldCFException {
        return this.doRecord(jobID, legalLinkTypes, sourceDocumentIDHash, targetDocumentIDHashes, linkType, hopcountMethod, processID);
    }

    public void finishParents(Long jobID, String[] legalLinkTypes, String[] sourceDocumentHashes, int hopcountMethod) throws ManifoldCFException {
        this.doFinish(jobID, legalLinkTypes, sourceDocumentHashes, hopcountMethod);
    }

    public void revertParents(Long jobID, String[] sourceDocumentHashes) throws ManifoldCFException {
        this.intrinsicLinkManager.revertLinks(jobID, sourceDocumentHashes);
    }

    protected boolean[] doRecord(Long jobID, String[] legalLinkTypes, String sourceDocumentIDHash, String[] targetDocumentIDHashes, String linkType, int hopcountMethod, String processID) throws ManifoldCFException {
        boolean[] rval = new boolean[targetDocumentIDHashes.length];
        for (int i = 0; i < rval.length; ++i) {
            rval[i] = false;
        }
        String[] newReferences = this.intrinsicLinkManager.recordReferences(jobID, sourceDocumentIDHash, targetDocumentIDHashes, linkType, processID);
        if (newReferences.length > 0) {
            int i;
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Queueing " + Integer.toString(targetDocumentIDHashes.length) + " documents"));
            }
            Answer[] estimates = new Answer[legalLinkTypes.length];
            if (sourceDocumentIDHash == null || sourceDocumentIDHash.length() == 0) {
                for (int i2 = 0; i2 < estimates.length; ++i2) {
                    estimates[i2] = new Answer(0);
                }
            } else {
                int i3;
                StringBuilder sb = new StringBuilder("SELECT ");
                ArrayList list = new ArrayList();
                sb.append(idField).append(",").append(distanceField).append(",").append(linkTypeField).append(" FROM ").append(this.getTableName()).append(" WHERE ");
                sb.append(this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(parentIDHashField, (Object)sourceDocumentIDHash), new MultiClause(linkTypeField, (Object[])legalLinkTypes)}));
                IResultSet set = this.performQuery(sb.toString(), list, null, null);
                HashMap<String, Answer> answerMap = new HashMap<String, Answer>();
                for (i3 = 0; i3 < estimates.length; ++i3) {
                    estimates[i3] = new Answer(-2);
                    answerMap.put(legalLinkTypes[i3], estimates[i3]);
                }
                for (i3 = 0; i3 < set.getRowCount(); ++i3) {
                    IResultRow row = set.getRow(i3);
                    Long id = (Long)row.getValue(idField);
                    DeleteDependency[] dds = hopcountMethod != 2 ? this.deleteDepsManager.getDeleteDependencies(id) : new DeleteDependency[]{};
                    Long distance = (Long)row.getValue(distanceField);
                    String recordedLinkType = (String)row.getValue(linkTypeField);
                    Answer a = (Answer)answerMap.get(recordedLinkType);
                    int recordedDistance = (int)distance.longValue();
                    if (recordedDistance == -1) continue;
                    a.setAnswer(recordedDistance, dds);
                }
            }
            boolean[] hasChanged = this.addToProcessingQueue(jobID, legalLinkTypes, newReferences, estimates, sourceDocumentIDHash, linkType, hopcountMethod);
            HashMap<String, Boolean> changeMap = new HashMap<String, Boolean>();
            for (i = 0; i < newReferences.length; ++i) {
                changeMap.put(newReferences[i], new Boolean(hasChanged[i]));
            }
            for (i = 0; i < rval.length; ++i) {
                Boolean x = (Boolean)changeMap.get(targetDocumentIDHashes[i]);
                if (x == null || !x.booleanValue()) continue;
                rval[i] = true;
            }
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Done queueing " + Integer.toString(targetDocumentIDHashes.length) + " documents"));
            }
        }
        return rval;
    }

    public void deleteMatchingDocuments(Long jobID, String[] legalLinkTypes, String joinTableName, String joinTableIDColumn, String joinTableJobColumn, String joinTableCriteria, ArrayList joinTableParams, int hopcountMethod) throws ManifoldCFException {
        if (hopcountMethod == 0) {
            this.doDeleteDocuments(jobID, joinTableName, joinTableIDColumn, joinTableJobColumn, joinTableCriteria, joinTableParams);
        }
    }

    public void deleteDocumentIdentifiers(Long jobID, String[] legalLinkTypes, String[] documentHashes, int hopcountMethod) throws ManifoldCFException {
        if (hopcountMethod == 0) {
            this.doDeleteDocuments(jobID, documentHashes);
        }
    }

    public int[] findHopCounts(Long jobID, String[] parentIdentifierHashes, String linkType) throws ManifoldCFException {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        int[] rval = new int[parentIdentifierHashes.length];
        HashMap<String, Integer> rvalMap = new HashMap<String, Integer>();
        for (i = 0; i < rval.length; ++i) {
            rval[i] = -1;
            rvalMap.put(parentIdentifierHashes[i], new Integer(i));
        }
        int maxClause = this.maxClauseProcessFind(jobID, linkType);
        int k = 0;
        for (i = 0; i < parentIdentifierHashes.length; ++i) {
            if (k == maxClause) {
                this.processFind(rval, rvalMap, jobID, linkType, list);
                k = 0;
                list.clear();
            }
            list.add(parentIdentifierHashes[i]);
            ++k;
        }
        if (k > 0) {
            this.processFind(rval, rvalMap, jobID, linkType, list);
        }
        return rval;
    }

    protected int maxClauseProcessFind(Long jobID, String linkType) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(linkTypeField, (Object)linkType)});
    }

    protected void processFind(int[] rval, Map rvalMap, Long jobID, String linkType, ArrayList list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, (List)list), new UnitaryClause(linkTypeField, (Object)linkType)});
        IResultSet set = this.performQuery("SELECT distance,parentidhash FROM " + this.getTableName() + " WHERE " + query, newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String parentIDHash = (String)row.getValue(parentIDHashField);
            Long distance = (Long)row.getValue(distanceField);
            rval[((Integer)rvalMap.get((Object)parentIDHash)).intValue()] = (int)distance.longValue();
        }
    }

    public boolean processQueue(Long jobID, String[] legalLinkTypes, int hopcountMethod) throws ManifoldCFException {
        ArrayList list = new ArrayList();
        String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(markForDeathField, (Object)HopCount.markToString(1))});
        IResultSet set = this.performQuery("SELECT linktype,parentidhash FROM " + this.getTableName() + " WHERE " + query + " " + this.constructOffsetLimitClause(0, 200) + " FOR UPDATE", list, null, null, 200);
        if (set.getRowCount() == 0) {
            return true;
        }
        DocumentHash dh = new DocumentHash(jobID, legalLinkTypes, hopcountMethod);
        Question[] questions = new Question[set.getRowCount()];
        for (int i = 0; i < set.getRowCount(); ++i) {
            IResultRow row = set.getRow(i);
            String parentIdentifierHash = (String)row.getValue(parentIDHashField);
            String linkType = (String)row.getValue(linkTypeField);
            questions[i] = new Question(parentIdentifierHash, linkType);
        }
        dh.askQuestions(questions);
        return false;
    }

    protected int maxClausePerformFindMissingRecords(Long jobID, String[] affectedLinkTypes) {
        return this.findConjunctionClauseMax(new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(linkTypeField, (Object[])affectedLinkTypes)});
    }

    protected void performFindMissingRecords(Long jobID, String[] affectedLinkTypes, ArrayList list, Map<Question, Long> matchMap) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        String query = this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(parentIDHashField, (List)list), new MultiClause(linkTypeField, (Object[])affectedLinkTypes)});
        IResultSet set = this.performQuery("SELECT parentidhash,linktype,distance FROM " + this.getTableName() + " WHERE " + query, newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String docIDHash = (String)row.getValue(parentIDHashField);
            String linkType = (String)row.getValue(linkTypeField);
            Long distance = (Long)row.getValue(distanceField);
            Question q = new Question(docIDHash, linkType);
            matchMap.put(q, distance);
        }
    }

    protected boolean[] addToProcessingQueue(Long jobID, String[] affectedLinkTypes, String[] documentIDHashes, Answer[] startingAnswers, String sourceDocumentIDHash, String linkType, int hopcountMethod) throws ManifoldCFException {
        if (Logging.hopcount.isDebugEnabled()) {
            int z;
            Logging.hopcount.debug((Object)("Adding " + Integer.toString(documentIDHashes.length) + " documents to processing queue"));
            for (z = 0; z < documentIDHashes.length; ++z) {
                Logging.hopcount.debug((Object)("  Adding '" + documentIDHashes[z] + "' to processing queue"));
            }
            Logging.hopcount.debug((Object)("The source id is '" + sourceDocumentIDHash + "' and linktype is '" + linkType + "', and there are " + Integer.toString(affectedLinkTypes.length) + " affected link types, as below:"));
            for (z = 0; z < affectedLinkTypes.length; ++z) {
                Logging.hopcount.debug((Object)("  Linktype '" + affectedLinkTypes[z] + "', current distance " + Integer.toString(startingAnswers[z].getAnswer()) + " with " + Integer.toString(startingAnswers[z].countDeleteDependencies()) + " delete dependencies."));
            }
        }
        HashMap<Question, Long> matchMap = new HashMap<Question, Long>();
        HashMap<String, Answer> answerMap = new HashMap<String, Answer>();
        for (int u = 0; u < affectedLinkTypes.length; ++u) {
            answerMap.put(affectedLinkTypes[u], startingAnswers[u]);
        }
        boolean[] rval = new boolean[documentIDHashes.length];
        for (int i = 0; i < rval.length; ++i) {
            rval[i] = false;
        }
        int maxClause = this.maxClausePerformFindMissingRecords(jobID, affectedLinkTypes);
        ArrayList<String> list = new ArrayList<String>();
        int k = 0;
        for (int i = 0; i < documentIDHashes.length; ++i) {
            String documentIDHash = documentIDHashes[i];
            if (k == maxClause) {
                this.performFindMissingRecords(jobID, affectedLinkTypes, list, matchMap);
                k = 0;
                list.clear();
            }
            list.add(documentIDHash);
            ++k;
        }
        if (k > 0) {
            this.performFindMissingRecords(jobID, affectedLinkTypes, list, matchMap);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (int i = 0; i < documentIDHashes.length; ++i) {
            String documentIDHash = documentIDHashes[i];
            for (int j = 0; j < affectedLinkTypes.length; ++j) {
                Long currentDistance;
                String affectedLinkType = affectedLinkTypes[j];
                Question q = new Question(documentIDHash, affectedLinkType);
                Answer startingAnswer = (Answer)answerMap.get(affectedLinkType);
                int newAnswerValue = startingAnswer.getAnswer();
                if (newAnswerValue >= 0 && affectedLinkType.equals(linkType)) {
                    ++newAnswerValue;
                }
                if ((currentDistance = (Long)matchMap.get(q)) == null) {
                    DeleteDependency dd = new DeleteDependency(linkType, documentIDHash, sourceDocumentIDHash);
                    map.clear();
                    Long hopCountID = new Long(IDFactory.make((IThreadContext)this.threadContext));
                    map.put(idField, hopCountID);
                    map.put(parentIDHashField, q.getDocumentIdentifierHash());
                    map.put(linkTypeField, q.getLinkType());
                    if (newAnswerValue == -2) {
                        map.put(distanceField, new Long(-1L));
                    } else {
                        map.put(distanceField, new Long(newAnswerValue));
                    }
                    map.put(jobIDField, jobID);
                    map.put(markForDeathField, HopCount.markToString(0));
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Inserting new record for '" + documentIDHash + "' linktype '" + affectedLinkType + "' distance " + Integer.toString(newAnswerValue) + " for job " + jobID));
                    }
                    this.performInsert(map, null);
                    this.noteModifications(1, 0, 0);
                    if (hopcountMethod == 2) continue;
                    this.deleteDepsManager.writeDependency(hopCountID, jobID, dd);
                    Iterator iter2 = startingAnswer.getDeleteDependencies();
                    while (iter2.hasNext()) {
                        dd = (DeleteDependency)iter2.next();
                        this.deleteDepsManager.writeDependency(hopCountID, jobID, dd);
                    }
                    continue;
                }
                int oldAnswerValue = (int)currentDistance.longValue();
                if (newAnswerValue < 0 || oldAnswerValue >= 0 && newAnswerValue >= oldAnswerValue) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Existing record for '" + documentIDHash + "' linktype '" + affectedLinkType + "' has better distance " + Integer.toString(oldAnswerValue) + " than new distance " + Integer.toString(newAnswerValue) + ", so not queuing for job " + jobID));
                    }
                    matchMap.remove(q);
                    continue;
                }
                rval[i] = true;
            }
        }
        maxClause = this.getMaxOrClause();
        StringBuilder sb = new StringBuilder();
        list = new ArrayList();
        k = 0;
        for (int i = 0; i < documentIDHashes.length; ++i) {
            String documentIDHash = documentIDHashes[i];
            for (int j = 0; j < affectedLinkTypes.length; ++j) {
                String affectedLinkType = affectedLinkTypes[j];
                Question q = new Question(documentIDHash, affectedLinkType);
                if (matchMap.get(q) == null) continue;
                if (k == maxClause) {
                    this.performMarkAddDeps(sb.toString(), list);
                    k = 0;
                    sb.setLength(0);
                    list.clear();
                }
                if (k > 0) {
                    sb.append(" OR ");
                }
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Queuing '" + documentIDHash + "' linktype '" + affectedLinkType + "' for job " + jobID));
                }
                sb.append(this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new MultiClause(markForDeathField, new Object[]{HopCount.markToString(0), HopCount.markToString(2)}), new UnitaryClause(parentIDHashField, (Object)documentIDHash), new UnitaryClause(linkTypeField, (Object)affectedLinkType)}));
                ++k;
            }
        }
        if (k > 0) {
            this.performMarkAddDeps(sb.toString(), list);
        }
        this.noteModifications(0, documentIDHashes.length, 0);
        return rval;
    }

    protected void performMarkAddDeps(String query, ArrayList list) throws ManifoldCFException {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(markForDeathField, HopCount.markToString(1));
        this.performUpdate(map, "WHERE " + query, list, null);
    }

    protected void doFinish(Long jobID, String[] legalLinkTypes, String[] sourceDocumentHashes, int hopcountMethod) throws ManifoldCFException {
        if (hopcountMethod == 0) {
            this.doDeleteInvalidation(jobID, sourceDocumentHashes);
        }
        this.intrinsicLinkManager.restoreLinks(jobID, sourceDocumentHashes);
    }

    protected void doDeleteDocuments(Long jobID, String joinTableName, String joinTableIDColumn, String joinTableJobColumn, String joinTableCriteria, ArrayList joinTableParams) throws ManifoldCFException {
        if (Logging.hopcount.isDebugEnabled()) {
            Logging.hopcount.debug((Object)("Marking for delete for job " + jobID + " all hopcount document references" + " from table " + joinTableName + " matching " + joinTableCriteria));
        }
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList list = new ArrayList();
        sb.append(idField).append(" IN(SELECT t0.").append("ownerid").append(" FROM ").append(this.deleteDepsManager.getTableName()).append(" t0,").append(joinTableName).append(",").append(this.intrinsicLinkManager.getTableName()).append(" t1 WHERE ");
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new UnitaryClause("t0." + jobIDField, (Object)jobID);
        sb.append(this.buildConjunctionClause(list, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[4];
        clauseDescriptionArray2[0] = new UnitaryClause("t1." + jobIDField, (Object)jobID);
        clauseDescriptionArray2[1] = new JoinClause("t1." + parentIDHashField, "t0." + parentIDHashField);
        clauseDescriptionArray2[2] = new JoinClause("t1." + linkTypeField, "t0." + linkTypeField);
        clauseDescriptionArray2[3] = new JoinClause("t1." + "childidhash", "t0." + "childidhash");
        sb.append(this.buildConjunctionClause(list, clauseDescriptionArray2)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray3 = new ClauseDescription[2];
        clauseDescriptionArray3[0] = new UnitaryClause(joinTableJobColumn, (Object)jobID);
        clauseDescriptionArray3[1] = new JoinClause(joinTableIDColumn, "t0." + "childidhash");
        sb.append(this.buildConjunctionClause(list, clauseDescriptionArray3)).append(" AND ");
        sb.append(joinTableCriteria);
        list.addAll(joinTableParams);
        sb.append(")");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(distanceField, new Long(-1L));
        map.put(markForDeathField, HopCount.markToString(2));
        this.performUpdate(map, sb.toString(), list, null);
        this.noteModifications(0, 1, 0);
        if (Logging.hopcount.isDebugEnabled()) {
            Logging.hopcount.debug((Object)("Done setting hopcount rows for job " + jobID + " to initial distances"));
        }
        this.intrinsicLinkManager.removeDocumentLinks(jobID, joinTableName, joinTableIDColumn, joinTableJobColumn, joinTableCriteria, joinTableParams);
        ArrayList queryList = new ArrayList();
        String query = this.buildConjunctionClause(queryList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(markForDeathField, (Object)HopCount.markToString(2))});
        this.deleteDepsManager.removeMarkedRows(this.getTableName(), idField, query, queryList);
        HashMap<String, String> newMap = new HashMap<String, String>();
        newMap.put(markForDeathField, HopCount.markToString(1));
        this.performUpdate(newMap, "WHERE " + query, queryList, null);
        if (Logging.hopcount.isDebugEnabled()) {
            Logging.hopcount.debug((Object)("Done queueing for deletion for " + jobID));
        }
    }

    protected void doDeleteDocuments(Long jobID, String[] documentHashes) throws ManifoldCFException {
        if (documentHashes.length > 0) {
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Marking for delete for job " + jobID + " all hopcount document references" + " from:"));
                for (int k = 0; k < documentHashes.length; ++k) {
                    Logging.hopcount.debug((Object)("  " + documentHashes[k]));
                }
            }
            int maxClause = this.maxClauseMarkForDocumentDelete(jobID);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            int k = 0;
            while (i < documentHashes.length) {
                if (k == maxClause) {
                    this.markForDocumentDelete(jobID, list);
                    list.clear();
                    k = 0;
                }
                list.add(documentHashes[i]);
                ++i;
                ++k;
            }
            if (k > 0) {
                this.markForDocumentDelete(jobID, list);
            }
            this.noteModifications(0, documentHashes.length, 0);
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Done setting hopcount rows for job " + jobID + " to initial distances"));
            }
            this.intrinsicLinkManager.removeDocumentLinks(jobID, documentHashes);
            ArrayList queryList = new ArrayList();
            String query = this.buildConjunctionClause(queryList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(markForDeathField, (Object)HopCount.markToString(2))});
            this.deleteDepsManager.removeMarkedRows(this.getTableName(), idField, query, queryList);
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.put(markForDeathField, HopCount.markToString(1));
            this.performUpdate(newMap, "WHERE " + query, queryList, null);
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Done queueing for deletion for " + jobID));
            }
        }
    }

    protected int maxClauseMarkForDocumentDelete(Long jobID) {
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new UnitaryClause("t0." + jobIDField, (Object)jobID);
        return this.findConjunctionClauseMax(clauseDescriptionArray);
    }

    protected void markForDocumentDelete(Long jobID, ArrayList list) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList thisList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
        clauseDescriptionArray[0] = new UnitaryClause("t0." + jobIDField, (Object)jobID);
        clauseDescriptionArray[1] = new MultiClause("t0." + "childidhash", (List)list);
        sb.append(idField).append(" IN(SELECT ").append("ownerid").append(" FROM ").append(this.deleteDepsManager.getTableName()).append(" t0 WHERE ").append(this.buildConjunctionClause(thisList, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[4];
        clauseDescriptionArray2[0] = new JoinClause("t1." + jobIDField, "t0." + jobIDField);
        clauseDescriptionArray2[1] = new JoinClause("t1." + linkTypeField, "t0." + linkTypeField);
        clauseDescriptionArray2[2] = new JoinClause("t1." + parentIDHashField, "t0." + parentIDHashField);
        clauseDescriptionArray2[3] = new JoinClause("t1." + "childidhash", "t0." + "childidhash");
        sb.append("EXISTS(SELECT 'x' FROM ").append(this.intrinsicLinkManager.getTableName()).append(" t1 WHERE ").append(this.buildConjunctionClause(thisList, clauseDescriptionArray2));
        sb.append("))");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(distanceField, new Long(-1L));
        map.put(markForDeathField, HopCount.markToString(2));
        this.performUpdate(map, sb.toString(), thisList, null);
    }

    protected void doDeleteInvalidation(Long jobID, String[] sourceDocumentHashes) throws ManifoldCFException {
        ArrayList<String> commonNewList = new ArrayList<String>();
        commonNewList.add(IntrinsicLink.statusToString(0));
        String commonNewExpression = "isnew" + "=?";
        if (sourceDocumentHashes.length > 0) {
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Marking for delete for job " + jobID + " all target document references matching '" + commonNewExpression + "'" + " from:"));
                for (int k = 0; k < sourceDocumentHashes.length; ++k) {
                    Logging.hopcount.debug((Object)("  " + sourceDocumentHashes[k]));
                }
            }
            int maxClause = this.maxClauseMarkForDelete(jobID);
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            int k = 0;
            while (i < sourceDocumentHashes.length) {
                if (k == maxClause) {
                    this.markForDelete(jobID, list, commonNewExpression, commonNewList);
                    list.clear();
                    k = 0;
                }
                list.add(sourceDocumentHashes[i]);
                ++i;
                ++k;
            }
            if (k > 0) {
                this.markForDelete(jobID, list, commonNewExpression, commonNewList);
            }
            this.noteModifications(0, sourceDocumentHashes.length, 0);
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Done setting hopcount rows for job " + jobID + " to initial distances"));
            }
            this.intrinsicLinkManager.removeLinks(jobID, commonNewExpression, commonNewList, sourceDocumentHashes);
            ArrayList queryList = new ArrayList();
            String query = this.buildConjunctionClause(queryList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(markForDeathField, (Object)HopCount.markToString(2))});
            this.deleteDepsManager.removeMarkedRows(this.getTableName(), idField, query, queryList);
            HashMap<String, String> newMap = new HashMap<String, String>();
            newMap.put(markForDeathField, HopCount.markToString(1));
            this.performUpdate(newMap, "WHERE " + query, queryList, null);
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Done queueing for deletion for " + jobID));
            }
        }
    }

    protected int maxClauseMarkForDelete(Long jobID) {
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new UnitaryClause("t0." + jobIDField, (Object)jobID);
        return this.findConjunctionClauseMax(clauseDescriptionArray);
    }

    protected void markForDelete(Long jobID, ArrayList list, String commonNewExpression, ArrayList commonNewList) throws ManifoldCFException {
        StringBuilder sb = new StringBuilder("WHERE ");
        ArrayList thisList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
        clauseDescriptionArray[0] = new UnitaryClause("t0." + jobIDField, (Object)jobID);
        clauseDescriptionArray[1] = new MultiClause("t0." + "childidhash", (List)list);
        sb.append(idField).append(" IN(SELECT ").append("ownerid").append(" FROM ").append(this.deleteDepsManager.getTableName()).append(" t0 WHERE ").append(this.buildConjunctionClause(thisList, clauseDescriptionArray)).append(" AND ");
        ClauseDescription[] clauseDescriptionArray2 = new ClauseDescription[4];
        clauseDescriptionArray2[0] = new JoinClause("t1." + jobIDField, "t0." + jobIDField);
        clauseDescriptionArray2[1] = new JoinClause("t1." + linkTypeField, "t0." + linkTypeField);
        clauseDescriptionArray2[2] = new JoinClause("t1." + parentIDHashField, "t0." + parentIDHashField);
        clauseDescriptionArray2[3] = new JoinClause("t1." + "childidhash", "t0." + "childidhash");
        sb.append("EXISTS(SELECT 'x' FROM ").append(this.intrinsicLinkManager.getTableName()).append(" t1 WHERE ").append(this.buildConjunctionClause(thisList, clauseDescriptionArray2));
        if (commonNewExpression != null) {
            sb.append(" AND t1.").append(commonNewExpression);
            thisList.addAll(commonNewList);
        }
        sb.append("))");
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(distanceField, new Long(-1L));
        map.put(markForDeathField, HopCount.markToString(2));
        this.performUpdate(map, sb.toString(), thisList, null);
    }

    protected IResultSet getDocumentChildren(Long jobID, String documentIDHash) throws ManifoldCFException {
        return this.intrinsicLinkManager.getDocumentChildren(jobID, documentIDHash);
    }

    protected DocumentNode[] readCachedNodes(Long jobID, Question[] unansweredQuestions) throws ManifoldCFException {
        int i;
        DocumentNode[] rval = new DocumentNode[unansweredQuestions.length];
        Answer a = new Answer(-2);
        HashMap<Question, Integer> indexMap = new HashMap<Question, Integer>();
        for (i = 0; i < unansweredQuestions.length; ++i) {
            DocumentNode dn;
            indexMap.put(unansweredQuestions[i], new Integer(i));
            rval[i] = dn = new DocumentNode(unansweredQuestions[i]);
            dn.setStartingAnswer(a);
            dn.setTrialAnswer(a);
            dn.makeCompleteNoWrite();
        }
        HashMap depsMap = new HashMap();
        int maxClause = this.maxClausePerformGetCachedDistances(jobID);
        ArrayList<Object> list = new ArrayList<Object>();
        ArrayList<String> ltList = new ArrayList<String>();
        i = 0;
        int k = 0;
        while (i < unansweredQuestions.length) {
            if (k == maxClause) {
                this.performGetCachedDistances(rval, indexMap, depsMap, jobID, ltList, list);
                k = 0;
                list.clear();
                ltList.clear();
            }
            Question q = unansweredQuestions[i++];
            ltList.add(q.getLinkType());
            list.add(q.getDocumentIdentifierHash());
            ++k;
        }
        if (k > 0) {
            this.performGetCachedDistances(rval, indexMap, depsMap, jobID, ltList, list);
        }
        maxClause = this.maxClausePerformGetCachedDistanceDeps();
        list.clear();
        k = 0;
        for (Long id : depsMap.keySet()) {
            if (k == maxClause) {
                this.performGetCachedDistanceDeps(depsMap, list);
                k = 0;
                list.clear();
            }
            list.add(id);
            ++k;
        }
        if (k > 0) {
            this.performGetCachedDistanceDeps(depsMap, list);
        }
        return rval;
    }

    protected int maxClausePerformGetCachedDistanceDeps() {
        return this.findConjunctionClauseMax(new ClauseDescription[0]);
    }

    protected void performGetCachedDistanceDeps(Map depsMap, ArrayList list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
        clauseDescriptionArray[0] = new MultiClause("ownerid", (List)list);
        String query = this.buildConjunctionClause(newList, clauseDescriptionArray);
        IResultSet set = this.performQuery("SELECT " + "ownerid" + "," + linkTypeField + "," + parentIDHashField + "," + "childidhash" + " FROM " + this.deleteDepsManager.getTableName() + " WHERE " + query, newList, null, null);
        HashMap<Long, ArrayList<DeleteDependency>> ownerHash = new HashMap<Long, ArrayList<DeleteDependency>>();
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            Long ownerID = (Long)row.getValue("ownerid");
            String linkType = (String)row.getValue(linkTypeField);
            if (linkType == null) {
                linkType = "";
            }
            String parentIDHash = (String)row.getValue(parentIDHashField);
            String childIDHash = (String)row.getValue("childidhash");
            if (childIDHash == null) {
                childIDHash = "";
            }
            DeleteDependency dd = new DeleteDependency(linkType, parentIDHash, childIDHash);
            ArrayList<DeleteDependency> ddlist = (ArrayList<DeleteDependency>)ownerHash.get(ownerID);
            if (ddlist == null) {
                ddlist = new ArrayList<DeleteDependency>();
                ownerHash.put(ownerID, ddlist);
            }
            ddlist.add(dd);
        }
        for (Long owner : ownerHash.keySet()) {
            ArrayList ddlist = (ArrayList)ownerHash.get(owner);
            if (ddlist == null) continue;
            DocumentNode dn = (DocumentNode)depsMap.get(owner);
            DeleteDependency[] array = new DeleteDependency[ddlist.size()];
            for (int j = 0; j < array.length; ++j) {
                array[j] = (DeleteDependency)ddlist.get(j);
            }
            Answer a = dn.getStartingAnswer();
            dn.setStartingAnswer(new Answer(a.getAnswer(), array));
            a = dn.getTrialAnswer();
            dn.setTrialAnswer(new Answer(a.getAnswer(), array));
        }
    }

    protected int maxClausePerformGetCachedDistances(Long jobID) {
        return this.getMaxOrClause();
    }

    protected void performGetCachedDistances(DocumentNode[] rval, Map indexMap, Map depsMap, Long jobID, ArrayList ltList, ArrayList list) throws ManifoldCFException {
        ArrayList newList = new ArrayList();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                sb.append(" OR ");
            }
            sb.append(this.buildConjunctionClause(newList, new ClauseDescription[]{new UnitaryClause(jobIDField, (Object)jobID), new UnitaryClause(parentIDHashField, list.get(i)), new UnitaryClause(linkTypeField, ltList.get(i))}));
        }
        String query = sb.toString();
        IResultSet set = this.performQuery("SELECT id,parentidhash,linktype,distance,deathmark FROM " + this.getTableName() + " WHERE " + query, newList, null, null);
        int i = 0;
        while (i < set.getRowCount()) {
            IResultRow row = set.getRow(i++);
            String parentIDHash = (String)row.getValue(parentIDHashField);
            String linkType = (String)row.getValue(linkTypeField);
            Question q = new Question(parentIDHash, linkType);
            Long id = (Long)row.getValue(idField);
            Long distance = (Long)row.getValue(distanceField);
            int answerDistance = distance == -1L ? -2 : (int)distance.longValue();
            DocumentNode dn = rval[(Integer)indexMap.get(q)];
            int foundMark = HopCount.stringToMark((String)row.getValue(markForDeathField));
            if (foundMark != 0) {
                if (foundMark == 1) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("For '" + parentIDHash + "' linktype '" + linkType + "', the record is marked: returned 'unknown'"));
                    }
                    dn.reset();
                    dn.setSource(id, answerDistance);
                    continue;
                }
                Logging.hopcount.error((Object)("Document '" + parentIDHash + "' linktype '" + linkType + "' is labeled with 'DELETING'!"));
                throw new ManifoldCFException("Algorithm transaction error!");
            }
            if (answerDistance != -2) {
                depsMap.put(id, dn);
            }
            dn.setStartingAnswer(new Answer(answerDistance));
            dn.setTrialAnswer(new Answer(answerDistance));
            dn.makeCompleteNoWrite();
            if (!Logging.hopcount.isDebugEnabled()) continue;
            Logging.hopcount.debug((Object)("For '" + parentIDHash + "' linktype '" + linkType + "', the value returned is " + Integer.toString(dn.getFinalAnswer())));
        }
    }

    protected void writeCachedDistance(Long jobID, String[] legalLinkTypes, DocumentNode dn, int hopcountMethod) throws ManifoldCFException {
        int answerValue;
        Question q = dn.getQuestion();
        String linkType = q.getLinkType();
        String parentIDHash = q.getDocumentIdentifierHash();
        Answer answer = dn.getTrialAnswer();
        if (Logging.hopcount.isDebugEnabled()) {
            Logging.hopcount.debug((Object)("Deciding whether to cache answer for document '" + parentIDHash + "' linktype '" + linkType + "' answer=" + Integer.toString(answer.getAnswer())));
        }
        if ((answerValue = answer.getAnswer()) < 0 && answerValue != -2) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        int existingDistance = dn.getDatabaseValue();
        Long existingID = dn.getDatabaseRow();
        if (existingID != null) {
            if (answerValue == -2) {
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Caching infinity for document '" + parentIDHash + "' linktype '" + linkType + "' answer=" + Integer.toString(answer.getAnswer())));
                }
                this.deleteDepsManager.deleteOwnerRows(new Long[]{existingID});
                ArrayList list = new ArrayList();
                String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)existingID)});
                this.performDelete("WHERE " + query, list, null);
                this.noteModifications(0, 0, 1);
                return;
            }
            if (existingDistance != -2 && existingDistance < answerValue) {
                Logging.hopcount.error((Object)("Existing distance " + Integer.toString(existingDistance) + " better than new distance " + Integer.toString(answerValue) + " for '" + parentIDHash + "' linktype '" + linkType + "'"));
                throw new ManifoldCFException("Existing distance is better than new distance! Failure.");
            }
            if (existingDistance == -2 || existingDistance > answerValue) {
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Updating answer for document '" + parentIDHash + "' linktype '" + linkType + "' answer=" + Integer.toString(answer.getAnswer())));
                }
                HashMap<DeleteDependency, DeleteDependency> existingDepsMap = new HashMap<DeleteDependency, DeleteDependency>();
                if (hopcountMethod != 2) {
                    DeleteDependency[] existingDeps = this.deleteDepsManager.getDeleteDependencies(existingID);
                    int k = 0;
                    while (k < existingDeps.length) {
                        DeleteDependency dep = existingDeps[k++];
                        existingDepsMap.put(dep, dep);
                    }
                }
                map.put(distanceField, new Long(answerValue));
                map.put(markForDeathField, HopCount.markToString(0));
                ArrayList list = new ArrayList();
                String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)existingID)});
                this.performUpdate(map, "WHERE " + query, list, null);
                this.noteModifications(0, 1, 0);
                if (hopcountMethod != 2) {
                    DeleteDependency dep2;
                    int incrementalOpCount = 0;
                    for (DeleteDependency dep2 : existingDepsMap.keySet()) {
                        if (answer.hasDependency(dep2)) continue;
                        ++incrementalOpCount;
                    }
                    Iterator iter = answer.getDeleteDependencies();
                    while (iter.hasNext()) {
                        dep2 = (DeleteDependency)iter.next();
                        if (existingDepsMap.get(dep2) != null) continue;
                        ++incrementalOpCount;
                    }
                    if (incrementalOpCount > 1 + answer.countDeleteDependencies()) {
                        this.deleteDepsManager.deleteOwnerRows(new Long[]{existingID});
                        existingDepsMap.clear();
                    }
                    for (DeleteDependency dep2 : existingDepsMap.keySet()) {
                        if (answer.hasDependency(dep2)) continue;
                        this.deleteDepsManager.deleteDependency(existingID, dep2);
                    }
                    iter = answer.getDeleteDependencies();
                    while (iter.hasNext()) {
                        dep2 = (DeleteDependency)iter.next();
                        if (existingDepsMap.get(dep2) != null) continue;
                        this.deleteDepsManager.writeDependency(existingID, jobID, dep2);
                    }
                }
                String[] targetDocumentIDHashes = this.intrinsicLinkManager.getDocumentUniqueParents(jobID, parentIDHash);
                this.addToProcessingQueue(jobID, new String[]{linkType}, targetDocumentIDHashes, new Answer[]{answer}, parentIDHash, linkType, hopcountMethod);
            } else {
                map.put(markForDeathField, HopCount.markToString(0));
                ArrayList list = new ArrayList();
                String query = this.buildConjunctionClause(list, new ClauseDescription[]{new UnitaryClause(idField, (Object)existingID)});
                this.performUpdate(map, "WHERE " + query, list, null);
                this.noteModifications(0, 1, 0);
            }
            return;
        }
        if (answerValue == -2) {
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Caching infinity for document '" + parentIDHash + "' linktype '" + linkType + "' answer=" + Integer.toString(answer.getAnswer())));
            }
            return;
        }
        if (Logging.hopcount.isDebugEnabled()) {
            Logging.hopcount.debug((Object)("Caching answer for document '" + parentIDHash + "' linktype '" + linkType + "' answer=" + Integer.toString(answer.getAnswer())));
        }
        Long id = new Long(IDFactory.make((IThreadContext)this.threadContext));
        map.put(idField, id);
        map.put(jobIDField, jobID);
        if (linkType.length() > 0) {
            map.put(linkTypeField, linkType);
        }
        map.put(parentIDHashField, parentIDHash);
        map.put(distanceField, new Long(answer.getAnswer()));
        this.performInsert(map, null);
        this.noteModifications(1, 0, 0);
        if (hopcountMethod != 2) {
            Iterator iter = answer.getDeleteDependencies();
            while (iter.hasNext()) {
                DeleteDependency dep = (DeleteDependency)iter.next();
                this.deleteDepsManager.writeDependency(id, jobID, dep);
            }
        }
    }

    static {
        markMap.put("N", new Integer(0));
        markMap.put("Q", new Integer(1));
        markMap.put("D", new Integer(2));
    }

    protected class DocumentHash {
        protected Long jobID;
        protected Map questionLookupMap = new HashMap();
        protected NodeQueue childFetchQueue = new NodeQueue();
        protected NodeQueue evaluationQueue = new NodeQueue();
        protected String[] legalLinkTypes;
        protected int hopcountMethod;

        public DocumentHash(Long jobID, String[] legalLinkTypes, int hopcountMethod) {
            this.jobID = jobID;
            this.legalLinkTypes = legalLinkTypes;
            this.hopcountMethod = hopcountMethod;
        }

        public int[] askQuestions(Question[] questions) throws ManifoldCFException {
            int i;
            int[] answers;
            block12: {
                block11: {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)"Questions asked as follows:");
                        for (int i2 = 0; i2 < questions.length; ++i2) {
                            Logging.hopcount.debug((Object)("  Linktype='" + questions[i2].getLinkType() + "' DocumentID='" + questions[i2].getDocumentIdentifierHash() + "'"));
                        }
                        Logging.hopcount.debug((Object)"");
                    }
                    answers = new int[questions.length];
                    DocumentNode[] nodes = this.queueQuestions(questions);
                    i = 0;
                    while (i < nodes.length) {
                        nodes[i++].addParent(null);
                    }
                    while (true) {
                        DocumentNode dn;
                        int answer;
                        if (Thread.currentThread().isInterrupted()) {
                            throw new ManifoldCFException("Interrupted", 2);
                        }
                        i = 0;
                        while (i < questions.length && (answer = (dn = nodes[i]).getFinalAnswer()) != -1) {
                            answers[i++] = answer;
                        }
                        if (i == questions.length) break block11;
                        DocumentNode evaluationNode = this.evaluationQueue.nextNode();
                        if (evaluationNode != null) {
                            this.evaluateNode(evaluationNode);
                            continue;
                        }
                        Logging.hopcount.debug((Object)"Found no nodes to evaluate at the moment");
                        DocumentNode[] fetchNodes = this.childFetchQueue.nextNodes();
                        if (fetchNodes.length <= 0) break;
                        this.getNodeChildren(fetchNodes);
                    }
                    Logging.hopcount.debug((Object)"Found no children to fetch at the moment");
                    for (DocumentNode dn : this.questionLookupMap.values()) {
                        if (dn.isComplete()) continue;
                        this.makeNodeComplete(dn);
                    }
                    Logging.hopcount.debug((Object)"Made remaining nodes complete");
                    i = 0;
                    while (i < questions.length) {
                        DocumentNode dn;
                        dn = nodes[i];
                        answers[i++] = dn.getFinalAnswer();
                    }
                    Logging.hopcount.debug((Object)"Done (copied out the answers)");
                    break block12;
                }
                Logging.hopcount.debug((Object)"Done (because answers already available)");
            }
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)"Answers returned as follows:");
                for (i = 0; i < questions.length; ++i) {
                    Logging.hopcount.debug((Object)("  Linktype='" + questions[i].getLinkType() + "' DocumentID='" + questions[i].getDocumentIdentifierHash() + "'" + " Answer=" + Integer.toString(answers[i])));
                }
                Logging.hopcount.debug((Object)"");
            }
            return answers;
        }

        protected void evaluateNode(DocumentNode node) throws ManifoldCFException {
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Evaluating node; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "'" + " BaseAnswer=" + Integer.toString(node.getStartingAnswer().getAnswer()) + " TrialAnswer=" + Integer.toString(node.getTrialAnswer().getAnswer())));
            }
            boolean signalParentsNeeded = false;
            Answer baseAnswer = new Answer(node.getStartingAnswer());
            ArrayList<NodeReference> childRemovalList = new ArrayList<NodeReference>();
            Iterator iter = node.getCurrentChildren();
            while (iter.hasNext()) {
                NodeReference childRef = (NodeReference)iter.next();
                DocumentNode child = childRef.getNode();
                String linkType = childRef.getLinkType();
                if (!child.isComplete()) continue;
                childRemovalList.add(childRef);
                baseAnswer.merge(child.getTrialAnswer(), linkType.equals(node.getQuestion().getLinkType()), linkType, node.getQuestion().getDocumentIdentifierHash(), child.getQuestion().getDocumentIdentifierHash());
            }
            int i = 0;
            while (i < childRemovalList.size()) {
                NodeReference childRef = (NodeReference)childRemovalList.get(i++);
                childRef.getNode().removeParent(node);
                node.removeChild(childRef);
            }
            node.setStartingAnswer(baseAnswer);
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Setting baseAnswer; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "' baseAnswer=" + Integer.toString(baseAnswer.getAnswer())));
            }
            Answer trialAnswer = new Answer(baseAnswer);
            iter = node.getCurrentChildren();
            while (iter.hasNext()) {
                NodeReference childRef = (NodeReference)iter.next();
                DocumentNode child = childRef.getNode();
                String linkType = childRef.getLinkType();
                trialAnswer.merge(child.getTrialAnswer(), linkType.equals(node.getQuestion().getLinkType()), linkType, node.getQuestion().getDocumentIdentifierHash(), child.getQuestion().getDocumentIdentifierHash());
            }
            Answer currentTrialAnswer = node.getTrialAnswer();
            if (trialAnswer.getAnswer() != currentTrialAnswer.getAnswer()) {
                signalParentsNeeded = true;
            }
            if (trialAnswer.getAnswer() == node.getBestPossibleAnswer().getAnswer()) {
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Setting complete [bestpossible]; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "' trialAnswer=" + Integer.toString(trialAnswer.getAnswer())));
                }
                node.setTrialAnswer(trialAnswer);
                this.makeNodeComplete(node);
                signalParentsNeeded = true;
            } else if (!node.hasChildren()) {
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Setting complete [nochildren]; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "' trialAnswer=" + Integer.toString(trialAnswer.getAnswer())));
                }
                node.setTrialAnswer(trialAnswer);
                this.makeNodeComplete(node);
                signalParentsNeeded = true;
            } else {
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Setting trialAnswer; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "' trialAnswer=" + Integer.toString(trialAnswer.getAnswer())));
                }
                node.setTrialAnswer(trialAnswer);
                if (!node.isAnswerNeeded()) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Discarding [unneeded]; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "'"));
                    }
                    this.questionLookupMap.remove(node.getQuestion());
                    this.removeChildLinks(node);
                    Logging.hopcount.debug((Object)"Done node evaluation");
                    return;
                }
            }
            if (signalParentsNeeded) {
                Logging.hopcount.debug((Object)"Requeueing parent nodes");
                this.queueParents(node);
            }
            Logging.hopcount.debug((Object)"Done node evaluation");
        }

        protected void getNodeChildren(DocumentNode[] nodes) throws ManifoldCFException {
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)"Finding children for the following nodes:");
                int z = 0;
                while (z < nodes.length) {
                    DocumentNode node = nodes[z++];
                    Logging.hopcount.debug((Object)("  DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "'"));
                }
            }
            HashMap<Question, DocumentNode> nodesNeedingChildren = new HashMap<Question, DocumentNode>();
            HashMap<String, String> parentMap = new HashMap<String, String>();
            int k = 0;
            while (k < nodes.length) {
                DocumentNode node;
                if (!(node = nodes[k++]).isAnswerNeeded()) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Discard before getting node children[unneeded]; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "'"));
                    }
                    this.questionLookupMap.remove(node.getQuestion());
                } else if (node.getQuestion().getDocumentIdentifierHash().length() == 0) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Found root; DocID='" + node.getQuestion().getDocumentIdentifierHash() + "' Linktype='" + node.getQuestion().getLinkType() + "'"));
                    }
                    node.setStartingAnswer(new Answer(0));
                    node.setTrialAnswer(new Answer(0));
                    node.makeCompleteNoWrite();
                    this.queueParents(node);
                }
                nodesNeedingChildren.put(node.getQuestion(), node);
                parentMap.put(node.getQuestion().getDocumentIdentifierHash(), node.getQuestion().getDocumentIdentifierHash());
            }
            if (nodesNeedingChildren.size() == 0) {
                return;
            }
            HashMap referenceMap = new HashMap();
            int maxClause = this.maxClauseFindChildren(this.jobID);
            ArrayList<String> list = new ArrayList<String>();
            k = 0;
            for (String parentIDHash : parentMap.keySet()) {
                referenceMap.put(parentIDHash, new ArrayList());
                if (k == maxClause) {
                    this.findChildren(referenceMap, this.jobID, list);
                    k = 0;
                    list.clear();
                }
                list.add(parentIDHash);
                ++k;
            }
            if (k > 0) {
                this.findChildren(referenceMap, this.jobID, list);
            }
            HashMap<Question, Object> childQuestionMap = new HashMap<Question, Object>();
            for (Question q : nodesNeedingChildren.keySet()) {
                ArrayList childlist = (ArrayList)referenceMap.get(q.getDocumentIdentifierHash());
                k = 0;
                while (k < childlist.size()) {
                    DocumentReference dr = (DocumentReference)childlist.get(k++);
                    Question childQuestion = new Question(dr.getChildIdentifierHash(), q.getLinkType());
                    childQuestionMap.put(childQuestion, childQuestion);
                }
            }
            Question[] questionsToAsk = new Question[childQuestionMap.size()];
            k = 0;
            Iterator iter = childQuestionMap.keySet().iterator();
            while (iter.hasNext()) {
                questionsToAsk[k++] = (Question)iter.next();
            }
            DocumentNode[] resultNodes = this.queueQuestions(questionsToAsk);
            for (k = 0; k < resultNodes.length; ++k) {
                childQuestionMap.put(questionsToAsk[k], resultNodes[k]);
            }
            for (Question q : nodesNeedingChildren.keySet()) {
                DocumentNode node = (DocumentNode)nodesNeedingChildren.get(q);
                String documentIdentifierHash = q.getDocumentIdentifierHash();
                Answer startingAnswer = new Answer(-2);
                Answer trialAnswer = new Answer(-2);
                int bestPossibleAnswerValue = -2;
                ArrayList childReferences = (ArrayList)referenceMap.get(q.getDocumentIdentifierHash());
                k = 0;
                while (k < childReferences.size()) {
                    DocumentReference dr = (DocumentReference)childReferences.get(k++);
                    String childIdentifierHash = dr.getChildIdentifierHash();
                    Question lookupQuestion = new Question(childIdentifierHash, q.getLinkType());
                    DocumentNode childNode = (DocumentNode)childQuestionMap.get(lookupQuestion);
                    String linkType = dr.getLinkType();
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("  Child found for DocID='" + documentIdentifierHash + "' Linktype='" + q.getLinkType() + "'; ID='" + childIdentifierHash + "' linktype='" + linkType + "'"));
                    }
                    boolean isIncrementing = linkType.equals(node.getQuestion().getLinkType());
                    int bestPossibleCheckValue = 0;
                    if (isIncrementing) {
                        bestPossibleCheckValue = 1;
                    }
                    if (bestPossibleAnswerValue == -2 || bestPossibleAnswerValue > bestPossibleCheckValue) {
                        bestPossibleAnswerValue = bestPossibleCheckValue;
                    }
                    Answer childAnswer = childNode.getTrialAnswer();
                    if (childNode.isComplete()) {
                        startingAnswer.merge(childAnswer, isIncrementing, linkType, documentIdentifierHash, childIdentifierHash);
                        trialAnswer.merge(childAnswer, isIncrementing, linkType, documentIdentifierHash, childIdentifierHash);
                        continue;
                    }
                    childNode.addParent(node);
                    node.addChild(new NodeReference(childNode, linkType));
                    trialAnswer.merge(childAnswer, isIncrementing, linkType, documentIdentifierHash, childIdentifierHash);
                }
                node.setStartingAnswer(startingAnswer);
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Setting baseAnswer; DocID='" + documentIdentifierHash + "' Linktype='" + q.getLinkType() + "' baseAnswer=" + Integer.toString(startingAnswer.getAnswer())));
                }
                Answer bestPossible = new Answer(bestPossibleAnswerValue);
                node.setBestPossibleAnswer(bestPossible);
                if (trialAnswer.getAnswer() == bestPossible.getAnswer()) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Setting complete [bestpossible]; DocID='" + documentIdentifierHash + "' Linktype='" + q.getLinkType() + "' trialAnswer=" + Integer.toString(trialAnswer.getAnswer())));
                    }
                    node.setTrialAnswer(trialAnswer);
                    this.makeNodeComplete(node);
                } else if (!node.hasChildren()) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Setting complete [nochildren]; DocID='" + documentIdentifierHash + "' Linktype='" + q.getLinkType() + "' trialAnswer=" + Integer.toString(trialAnswer.getAnswer())));
                    }
                    node.setTrialAnswer(trialAnswer);
                    this.makeNodeComplete(node);
                } else {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Setting trialAnswer; DocID='" + documentIdentifierHash + "' Linktype='" + q.getLinkType() + "' trialAnswer=" + Integer.toString(trialAnswer.getAnswer())));
                    }
                    node.setTrialAnswer(trialAnswer);
                }
                this.queueParents(node);
            }
        }

        protected int maxClauseFindChildren(Long jobID) {
            ClauseDescription[] clauseDescriptionArray = new ClauseDescription[1];
            IntrinsicLink cfr_ignored_0 = HopCount.this.intrinsicLinkManager;
            clauseDescriptionArray[0] = new UnitaryClause(HopCount.jobIDField, (Object)jobID);
            return HopCount.this.findConjunctionClauseMax(clauseDescriptionArray);
        }

        protected void findChildren(Map referenceMap, Long jobID, ArrayList list) throws ManifoldCFException {
            ArrayList newList = new ArrayList();
            ClauseDescription[] clauseDescriptionArray = new ClauseDescription[2];
            IntrinsicLink cfr_ignored_0 = HopCount.this.intrinsicLinkManager;
            clauseDescriptionArray[0] = new UnitaryClause(HopCount.jobIDField, (Object)jobID);
            IntrinsicLink cfr_ignored_1 = HopCount.this.intrinsicLinkManager;
            clauseDescriptionArray[1] = new MultiClause(HopCount.parentIDHashField, (List)list);
            String query = HopCount.this.buildConjunctionClause(newList, clauseDescriptionArray);
            IntrinsicLink cfr_ignored_2 = HopCount.this.intrinsicLinkManager;
            IntrinsicLink cfr_ignored_3 = HopCount.this.intrinsicLinkManager;
            IntrinsicLink cfr_ignored_4 = HopCount.this.intrinsicLinkManager;
            IResultSet set = HopCount.this.performQuery("SELECT " + "childidhash" + "," + HopCount.linkTypeField + "," + HopCount.parentIDHashField + " FROM " + HopCount.this.intrinsicLinkManager.getTableName() + " WHERE " + query, newList, null, null);
            for (int i = 0; i < set.getRowCount(); ++i) {
                IResultRow row = set.getRow(i);
                IntrinsicLink cfr_ignored_5 = HopCount.this.intrinsicLinkManager;
                String parentIDHash = (String)row.getValue(HopCount.parentIDHashField);
                IntrinsicLink cfr_ignored_6 = HopCount.this.intrinsicLinkManager;
                String childIDHash = (String)row.getValue("childidhash");
                IntrinsicLink cfr_ignored_7 = HopCount.this.intrinsicLinkManager;
                String linkType = (String)row.getValue(HopCount.linkTypeField);
                if (linkType == null) {
                    linkType = "";
                }
                if (childIDHash == null) {
                    childIDHash = "";
                }
                ArrayList children = (ArrayList)referenceMap.get(parentIDHash);
                children.add(new DocumentReference(childIDHash, linkType));
            }
        }

        protected void queueParents(DocumentNode node) {
            Iterator iter = node.getCurrentParents();
            while (iter.hasNext()) {
                DocumentNode dn = (DocumentNode)iter.next();
                if (dn == null || dn.getTrialAnswer().getAnswer() == -1) continue;
                this.evaluationQueue.addToQueue(dn);
            }
        }

        protected void makeNodeComplete(DocumentNode node) throws ManifoldCFException {
            node.makeComplete();
            this.removeChildLinks(node);
            if (node.isWriteNeeded()) {
                HopCount.this.writeCachedDistance(this.jobID, this.legalLinkTypes, node, this.hopcountMethod);
                node.clearWriteNeeded();
            }
        }

        protected DocumentNode[] queueQuestions(Question[] questions) throws ManifoldCFException {
            Question q;
            DocumentNode[] rval = new DocumentNode[questions.length];
            HashMap<Question, Question> requestHash = new HashMap<Question, Question>();
            int z = 0;
            while (z < questions.length) {
                DocumentNode dn;
                Question q2 = questions[z++];
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Queuing question: DocID='" + q2.getDocumentIdentifierHash() + "' Linktype='" + q2.getLinkType() + "'"));
                }
                if ((dn = (DocumentNode)this.questionLookupMap.get(q2)) != null) {
                    if (Logging.hopcount.isDebugEnabled()) {
                        Logging.hopcount.debug((Object)("Question exists: DocID='" + q2.getDocumentIdentifierHash() + "' Linktype='" + q2.getLinkType() + "'"));
                    }
                    if (dn.isAnswerComplete()) {
                        if (!Logging.hopcount.isDebugEnabled()) continue;
                        Logging.hopcount.debug((Object)("Answer complete for: DocID='" + q2.getDocumentIdentifierHash() + "' Linktype='" + q2.getLinkType() + "'"));
                        continue;
                    }
                    if (!Logging.hopcount.isDebugEnabled()) continue;
                    Logging.hopcount.debug((Object)("Returning incomplete answer: DocID='" + q2.getDocumentIdentifierHash() + "' Linktype='" + q2.getLinkType() + "'"));
                    continue;
                }
                if (q2.getDocumentIdentifierHash() == null || q2.getDocumentIdentifierHash().length() == 0) {
                    Logging.hopcount.debug((Object)"Creating root document node, with distance 0");
                    Answer a = new Answer(0);
                    dn = new DocumentNode(q2);
                    dn.setStartingAnswer(a);
                    dn.setTrialAnswer(a);
                    dn.makeCompleteNoWrite();
                    this.questionLookupMap.put(q2, dn);
                    continue;
                }
                requestHash.put(q2, q2);
            }
            Question[] unansweredQuestions = new Question[requestHash.size()];
            z = 0;
            for (Question q3 : requestHash.keySet()) {
                unansweredQuestions[z++] = q3;
            }
            DocumentNode[] nodes = HopCount.this.readCachedNodes(this.jobID, unansweredQuestions);
            for (z = 0; z < nodes.length; ++z) {
                q = unansweredQuestions[z];
                DocumentNode dn = nodes[z];
                if (!dn.isComplete()) {
                    this.childFetchQueue.addToQueue(dn);
                }
                this.questionLookupMap.put(q, dn);
            }
            for (z = 0; z < questions.length; ++z) {
                q = questions[z];
                rval[z] = (DocumentNode)this.questionLookupMap.get(q);
            }
            return rval;
        }

        protected void notifyParents(DocumentNode node) {
            Iterator iter = node.getCurrentParents();
            while (iter.hasNext()) {
                DocumentNode dn = (DocumentNode)iter.next();
                if (dn.getTrialAnswer().getAnswer() == -1) continue;
                this.evaluationQueue.removeFromQueue(dn);
                this.evaluationQueue.addToQueue(dn);
            }
        }

        protected void removeChildLinks(DocumentNode dn) {
            Iterator iter = dn.getCurrentChildren();
            while (iter.hasNext()) {
                NodeReference nr = (NodeReference)iter.next();
                DocumentNode child = nr.getNode();
                child.removeParent(dn);
            }
            dn.clearChildReferences();
        }
    }

    protected static class NodeQueue {
        protected HashMap nodeMap = new HashMap();

        public void addToQueue(DocumentNode node) {
            if (this.nodeMap.get(node.getQuestion()) == null) {
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Adding document node " + node.toString() + " to queue " + this.toString()));
                }
                this.nodeMap.put(node.getQuestion(), node);
            }
        }

        public void removeFromQueue(DocumentNode node) {
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Removing document node " + node.toString() + " from queue " + this.toString()));
            }
            this.nodeMap.remove(node.getQuestion());
        }

        public DocumentNode nextNode() {
            if (this.nodeMap.size() == 0) {
                if (Logging.hopcount.isDebugEnabled()) {
                    Logging.hopcount.debug((Object)("Retrieving node from queue " + this.toString() + ": none found!"));
                }
                return null;
            }
            Question q = (Question)this.nodeMap.keySet().iterator().next();
            DocumentNode dn = (DocumentNode)this.nodeMap.remove(q);
            if (Logging.hopcount.isDebugEnabled()) {
                Logging.hopcount.debug((Object)("Retrieving node " + dn.toString() + " from queue " + this.toString()));
            }
            return dn;
        }

        public DocumentNode[] nextNodes() {
            DocumentNode[] rval = new DocumentNode[this.nodeMap.size()];
            Iterator iter = this.nodeMap.keySet().iterator();
            int j = 0;
            while (iter.hasNext()) {
                Question q = (Question)iter.next();
                rval[j++] = (DocumentNode)this.nodeMap.get(q);
            }
            this.nodeMap.clear();
            return rval;
        }
    }

    protected static class DocumentNode {
        protected Question question;
        protected int databaseAnswerValue = -1;
        protected Long databaseRow = null;
        protected Answer startingAnswer = new Answer(-1);
        protected Answer trialAnswer = new Answer(-1);
        protected Answer bestPossibleAnswer = new Answer(0);
        protected boolean isComplete = false;
        protected boolean writeNeeded = true;
        protected Map parentsWhoCare = new HashMap();
        protected Map childReferences = new HashMap();

        public DocumentNode(Question question) {
            this.question = question;
        }

        public Question getQuestion() {
            return this.question;
        }

        public void reset() {
            this.isComplete = false;
            this.writeNeeded = true;
            this.databaseAnswerValue = -1;
            this.databaseRow = null;
            this.trialAnswer.initialize(-1);
            this.startingAnswer.initialize(-1);
            this.bestPossibleAnswer.initialize(0);
        }

        public void clearChildReferences() {
            this.childReferences.clear();
        }

        public boolean hasChildren() {
            return this.childReferences.size() > 0;
        }

        public int getFinalAnswer() {
            if (this.isComplete) {
                return this.trialAnswer.getAnswer();
            }
            return -1;
        }

        public boolean isAnswerComplete() {
            return this.isComplete;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public boolean isWriteNeeded() {
            return this.writeNeeded;
        }

        public boolean isAnswerNeeded() {
            return this.parentsWhoCare.size() > 0;
        }

        public Answer getBestPossibleAnswer() {
            return this.bestPossibleAnswer;
        }

        public void setBestPossibleAnswer(Answer answer) {
            this.bestPossibleAnswer.duplicate(answer);
        }

        public Answer getTrialAnswer() {
            return this.trialAnswer;
        }

        public void setTrialAnswer(Answer answer) {
            this.trialAnswer.duplicate(answer);
        }

        public Answer getStartingAnswer() {
            return this.startingAnswer;
        }

        public void setStartingAnswer(Answer answer) {
            this.startingAnswer.duplicate(answer);
        }

        public void makeComplete() {
            if (!this.isComplete) {
                this.isComplete = true;
                this.writeNeeded = true;
            }
        }

        public void makeCompleteNoWrite() {
            this.isComplete = true;
            this.writeNeeded = false;
        }

        public void addParent(DocumentNode parent) {
            this.parentsWhoCare.put(parent, parent);
        }

        public void clearWriteNeeded() {
            this.writeNeeded = false;
        }

        public void addChild(NodeReference childRef) {
            this.childReferences.put(childRef, childRef);
        }

        public void removeChild(NodeReference childRef) {
            this.childReferences.remove(childRef);
        }

        public void removeParent(DocumentNode parent) {
            this.parentsWhoCare.remove(parent);
        }

        public Iterator getCurrentParents() {
            return this.parentsWhoCare.keySet().iterator();
        }

        public Iterator getCurrentChildren() {
            return this.childReferences.keySet().iterator();
        }

        public void setSource(Long rowID, int answerValue) {
            this.databaseRow = rowID;
            this.databaseAnswerValue = answerValue;
        }

        public Long getDatabaseRow() {
            return this.databaseRow;
        }

        public int getDatabaseValue() {
            return this.databaseAnswerValue;
        }
    }

    protected static class NodeReference {
        protected DocumentNode theNode;
        protected String linkType;

        public NodeReference(DocumentNode theNode, String linkType) {
            this.theNode = theNode;
            this.linkType = linkType;
        }

        public DocumentNode getNode() {
            return this.theNode;
        }

        public String getLinkType() {
            return this.linkType;
        }

        public int hashCode() {
            return this.theNode.hashCode() + this.linkType.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof NodeReference)) {
                return false;
            }
            NodeReference other = (NodeReference)o;
            return this.theNode.equals(other.theNode) && this.linkType.equals(other.linkType);
        }
    }

    protected static class DocumentReference {
        protected String childIdentifierHash;
        protected String linkType;

        public DocumentReference(String childIdentifierHash, String linkType) {
            this.childIdentifierHash = childIdentifierHash;
            this.linkType = linkType;
        }

        public String getChildIdentifierHash() {
            return this.childIdentifierHash;
        }

        public String getLinkType() {
            return this.linkType;
        }
    }

    protected static class Answer {
        protected int answer = -1;
        protected HashMap deleteDependencies = new HashMap();

        public Answer() {
        }

        public Answer(Answer other) {
            this.answer = other.answer;
            this.deleteDependencies = (HashMap)other.deleteDependencies.clone();
        }

        public Answer(int value) {
            this.answer = value;
        }

        public Answer(int answer, DeleteDependency[] deleteDeps) {
            this.answer = answer;
            int i = 0;
            while (i < deleteDeps.length) {
                DeleteDependency dep = deleteDeps[i++];
                this.deleteDependencies.put(dep, dep);
            }
        }

        public int getAnswer() {
            return this.answer;
        }

        public int countDeleteDependencies() {
            return this.deleteDependencies.size();
        }

        public Iterator getDeleteDependencies() {
            return this.deleteDependencies.keySet().iterator();
        }

        public boolean hasDependency(DeleteDependency dep) {
            return this.deleteDependencies.get(dep) != null;
        }

        public void initialize(int value) {
            this.answer = value;
            this.deleteDependencies.clear();
        }

        public void duplicate(Answer other) {
            this.answer = other.answer;
            this.deleteDependencies = (HashMap)other.deleteDependencies.clone();
        }

        public void merge(Answer childAnswer, boolean isIncrementingLink, String linkType, String parentIDHash, String childIDHash) {
            int childAnswerValue = childAnswer.getAnswer();
            if (this.answer >= 0) {
                if (childAnswerValue >= 0) {
                    if (isIncrementingLink) {
                        ++childAnswerValue;
                    }
                    if (childAnswerValue < this.answer) {
                        this.setAnswerFromChild(childAnswerValue, childAnswer.deleteDependencies, linkType, parentIDHash, childIDHash);
                        return;
                    }
                }
                return;
            }
            if (this.answer == -2) {
                if (childAnswerValue >= 0) {
                    if (isIncrementingLink) {
                        ++childAnswerValue;
                    }
                    this.setAnswerFromChild(childAnswerValue, childAnswer.deleteDependencies, linkType, parentIDHash, childIDHash);
                    return;
                }
                return;
            }
            if (childAnswerValue >= 0) {
                if (isIncrementingLink) {
                    ++childAnswerValue;
                }
                this.setAnswerFromChild(childAnswerValue, childAnswer.deleteDependencies, linkType, parentIDHash, childIDHash);
                return;
            }
        }

        protected void setAnswerFromChild(int newAnswer, HashMap childDeleteDependencies, String linkType, String parentIDHash, String childIDHash) {
            this.answer = newAnswer;
            this.deleteDependencies = (HashMap)childDeleteDependencies.clone();
            DeleteDependency x = new DeleteDependency(linkType, parentIDHash, childIDHash);
            this.deleteDependencies.put(x, x);
        }

        public void setAnswer(int answer, DeleteDependency[] deleteDeps) {
            this.answer = answer;
            this.deleteDependencies.clear();
            int i = 0;
            while (i < deleteDeps.length) {
                DeleteDependency dep = deleteDeps[i++];
                this.deleteDependencies.put(dep, dep);
            }
        }
    }

    protected static class Question {
        protected String documentIdentifierHash;
        protected String linkType;

        public Question(String documentIdentifierHash, String linkType) {
            this.documentIdentifierHash = documentIdentifierHash;
            this.linkType = linkType;
        }

        public String getDocumentIdentifierHash() {
            return this.documentIdentifierHash;
        }

        public String getLinkType() {
            return this.linkType;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Question)) {
                return false;
            }
            Question dn = (Question)o;
            return dn.documentIdentifierHash.equals(this.documentIdentifierHash) && dn.linkType.equals(this.linkType);
        }

        public int hashCode() {
            return this.documentIdentifierHash.hashCode() + this.linkType.hashCode();
        }
    }
}

