/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.solr.client.solrj.io.StreamContext;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.TupleStream;

public class UniqueStream
extends TupleStream {
    private static final long serialVersionUID = 1L;
    private TupleStream tupleStream;
    private Comparator<Tuple> comp;
    private Tuple currentTuple = null;

    public UniqueStream(TupleStream tupleStream, Comparator<Tuple> comp) {
        this.tupleStream = tupleStream;
        this.comp = comp;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.tupleStream.setStreamContext(context);
    }

    @Override
    public List<TupleStream> children() {
        ArrayList<TupleStream> l = new ArrayList<TupleStream>();
        l.add(this.tupleStream);
        return l;
    }

    @Override
    public void open() throws IOException {
        this.tupleStream.open();
    }

    @Override
    public void close() throws IOException {
        this.tupleStream.close();
    }

    @Override
    public Tuple read() throws IOException {
        int i;
        Tuple tuple = this.tupleStream.read();
        if (tuple.EOF) {
            return tuple;
        }
        if (this.currentTuple == null) {
            this.currentTuple = tuple;
            return tuple;
        }
        while ((i = this.comp.compare(this.currentTuple, tuple)) == 0) {
            tuple = this.tupleStream.read();
            if (!tuple.EOF) continue;
            return tuple;
        }
        this.currentTuple = tuple;
        return tuple;
    }

    @Override
    public int getCost() {
        return 0;
    }
}

