/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.docset.DocIdSets;
import org.elasticsearch.common.lucene.search.function.CombineFunction;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FiltersFunctionScoreQuery
extends Query {
    Query subQuery;
    final FilterFunction[] filterFunctions;
    final ScoreMode scoreMode;
    final float maxBoost;
    protected CombineFunction combineFunction;

    public FiltersFunctionScoreQuery(Query subQuery, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost) {
        this.subQuery = subQuery;
        this.scoreMode = scoreMode;
        this.filterFunctions = filterFunctions;
        this.maxBoost = maxBoost;
        this.combineFunction = CombineFunction.MULT;
    }

    public FiltersFunctionScoreQuery setCombineFunction(CombineFunction combineFunction) {
        this.combineFunction = combineFunction;
        return this;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public FilterFunction[] getFilterFunctions() {
        return this.filterFunctions;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FiltersFunctionScoreQuery bq = (FiltersFunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    public Weight createWeight(IndexSearcher searcher) throws IOException {
        Weight subQueryWeight = this.subQuery.createWeight(searcher);
        return new CustomBoostFactorWeight(subQueryWeight, this.filterFunctions.length);
    }

    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("function score (").append(this.subQuery.toString(field)).append(", functions: [");
        for (FilterFunction filterFunction : this.filterFunctions) {
            sb.append("{filter(").append(filterFunction.filter).append("), function [").append(filterFunction.function).append("]}");
        }
        sb.append("])");
        sb.append(ToStringUtils.boost((float)this.getBoost()));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        FiltersFunctionScoreQuery other = (FiltersFunctionScoreQuery)((Object)o);
        if (this.getBoost() != other.getBoost()) {
            return false;
        }
        if (!this.subQuery.equals((Object)other.subQuery)) {
            return false;
        }
        return Arrays.equals(this.filterFunctions, other.filterFunctions);
    }

    public int hashCode() {
        return this.subQuery.hashCode() + 31 * Arrays.hashCode(this.filterFunctions) ^ Float.floatToIntBits(this.getBoost());
    }

    static class CustomBoostFactorScorer
    extends Scorer {
        private final float subQueryBoost;
        private final Scorer scorer;
        private final FilterFunction[] filterFunctions;
        private final ScoreMode scoreMode;
        private final float maxBoost;
        private final Bits[] docSets;
        private final CombineFunction scoreCombiner;

        private CustomBoostFactorScorer(CustomBoostFactorWeight w, Scorer scorer, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost, Bits[] docSets, CombineFunction scoreCombiner) throws IOException {
            super((Weight)w);
            this.subQueryBoost = w.getQuery().getBoost();
            this.scorer = scorer;
            this.scoreMode = scoreMode;
            this.filterFunctions = filterFunctions;
            this.maxBoost = maxBoost;
            this.docSets = docSets;
            this.scoreCombiner = scoreCombiner;
        }

        public int docID() {
            return this.scorer.docID();
        }

        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }

        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        public float score() throws IOException {
            int docId = this.scorer.docID();
            double factor = 1.0;
            float subQueryScore = this.scorer.score();
            if (this.scoreMode == ScoreMode.First) {
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    factor = this.filterFunctions[i].function.score(docId, subQueryScore);
                    break;
                }
            } else if (this.scoreMode == ScoreMode.Max) {
                double maxFactor = Double.NEGATIVE_INFINITY;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    maxFactor = Math.max(this.filterFunctions[i].function.score(docId, subQueryScore), maxFactor);
                }
                if (maxFactor != Double.NEGATIVE_INFINITY) {
                    factor = maxFactor;
                }
            } else if (this.scoreMode == ScoreMode.Min) {
                double minFactor = Double.POSITIVE_INFINITY;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    minFactor = Math.min(this.filterFunctions[i].function.score(docId, subQueryScore), minFactor);
                }
                if (minFactor != Double.POSITIVE_INFINITY) {
                    factor = minFactor;
                }
            } else if (this.scoreMode == ScoreMode.Multiply) {
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    factor *= this.filterFunctions[i].function.score(docId, subQueryScore);
                }
            } else {
                double totalFactor = 0.0;
                int count = 0;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    totalFactor += this.filterFunctions[i].function.score(docId, subQueryScore);
                    ++count;
                }
                if (count != 0) {
                    factor = totalFactor;
                    if (this.scoreMode == ScoreMode.Avg) {
                        factor /= (double)count;
                    }
                }
            }
            return this.scoreCombiner.combine(this.subQueryBoost, subQueryScore, factor, this.maxBoost);
        }

        public int freq() throws IOException {
            return this.scorer.freq();
        }

        public long cost() {
            return this.scorer.cost();
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        final Weight subQueryWeight;
        final Bits[] docSets;

        public CustomBoostFactorWeight(Weight subQueryWeight, int filterFunctionLength) throws IOException {
            this.subQueryWeight = subQueryWeight;
            this.docSets = new Bits[filterFunctionLength];
        }

        public Query getQuery() {
            return FiltersFunctionScoreQuery.this;
        }

        public float getValueForNormalization() throws IOException {
            float sum = this.subQueryWeight.getValueForNormalization();
            return sum *= FiltersFunctionScoreQuery.this.getBoost() * FiltersFunctionScoreQuery.this.getBoost();
        }

        public void normalize(float norm, float topLevelBoost) {
            this.subQueryWeight.normalize(norm, topLevelBoost * FiltersFunctionScoreQuery.this.getBoost());
        }

        public Scorer scorer(AtomicReaderContext context, boolean scoreDocsInOrder, boolean topScorer, Bits acceptDocs) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(context, true, false, acceptDocs);
            if (subQueryScorer == null) {
                return null;
            }
            for (int i = 0; i < FiltersFunctionScoreQuery.this.filterFunctions.length; ++i) {
                FilterFunction filterFunction = FiltersFunctionScoreQuery.this.filterFunctions[i];
                filterFunction.function.setNextReader(context);
                this.docSets[i] = DocIdSets.toSafeBits(context.reader(), filterFunction.filter.getDocIdSet(context, acceptDocs));
            }
            return new CustomBoostFactorScorer(this, subQueryScorer, FiltersFunctionScoreQuery.this.scoreMode, FiltersFunctionScoreQuery.this.filterFunctions, FiltersFunctionScoreQuery.this.maxBoost, this.docSets, FiltersFunctionScoreQuery.this.combineFunction);
        }

        public Explanation explain(AtomicReaderContext context, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(context, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            ArrayList<ComplexExplanation> filterExplanations = new ArrayList<ComplexExplanation>();
            for (FilterFunction filterFunction : FiltersFunctionScoreQuery.this.filterFunctions) {
                Bits docSet = DocIdSets.toSafeBits(context.reader(), filterFunction.filter.getDocIdSet(context, context.reader().getLiveDocs()));
                if (!docSet.get(doc)) continue;
                filterFunction.function.setNextReader(context);
                Explanation functionExplanation = filterFunction.function.explainScore(doc, subQueryExpl);
                double factor = functionExplanation.getValue();
                float sc = CombineFunction.toFloat(factor);
                ComplexExplanation filterExplanation = new ComplexExplanation(true, sc, "function score, product of:");
                filterExplanation.addDetail(new Explanation(1.0f, "match filter: " + filterFunction.filter.toString()));
                filterExplanation.addDetail(functionExplanation);
                filterExplanations.add(filterExplanation);
            }
            if (filterExplanations.size() == 0) {
                float sc = FiltersFunctionScoreQuery.this.getBoost() * subQueryExpl.getValue();
                ComplexExplanation res = new ComplexExplanation(true, sc, "function score, no filter match, product of:");
                res.addDetail(subQueryExpl);
                res.addDetail(new Explanation(FiltersFunctionScoreQuery.this.getBoost(), "queryBoost"));
                return res;
            }
            double factor = 1.0;
            switch (FiltersFunctionScoreQuery.this.scoreMode) {
                case First: {
                    factor = ((ComplexExplanation)filterExplanations.get(0)).getValue();
                    break;
                }
                case Max: {
                    int i;
                    factor = Double.NEGATIVE_INFINITY;
                    for (i = 0; i < filterExplanations.size(); ++i) {
                        factor = Math.max((double)((ComplexExplanation)filterExplanations.get(i)).getValue(), factor);
                    }
                    break;
                }
                case Min: {
                    int i;
                    factor = Double.POSITIVE_INFINITY;
                    for (i = 0; i < filterExplanations.size(); ++i) {
                        factor = Math.min((double)((ComplexExplanation)filterExplanations.get(i)).getValue(), factor);
                    }
                    break;
                }
                case Multiply: {
                    int i;
                    for (i = 0; i < filterExplanations.size(); ++i) {
                        factor *= (double)((ComplexExplanation)filterExplanations.get(i)).getValue();
                    }
                    break;
                }
                default: {
                    double totalFactor = 0.0;
                    int count = 0;
                    for (int i = 0; i < filterExplanations.size(); ++i) {
                        totalFactor += (double)((ComplexExplanation)filterExplanations.get(i)).getValue();
                        ++count;
                    }
                    if (count == 0) break;
                    factor = totalFactor;
                    if (FiltersFunctionScoreQuery.this.scoreMode != ScoreMode.Avg) break;
                    factor /= (double)count;
                }
            }
            ComplexExplanation factorExplanaition = new ComplexExplanation(true, CombineFunction.toFloat(factor), "function score, score mode [" + FiltersFunctionScoreQuery.this.scoreMode.toString().toLowerCase(Locale.ROOT) + "]");
            for (int i = 0; i < filterExplanations.size(); ++i) {
                factorExplanaition.addDetail((Explanation)filterExplanations.get(i));
            }
            return FiltersFunctionScoreQuery.this.combineFunction.explain(FiltersFunctionScoreQuery.this.getBoost(), subQueryExpl, (Explanation)factorExplanaition, FiltersFunctionScoreQuery.this.maxBoost);
        }
    }

    public static enum ScoreMode {
        First,
        Avg,
        Max,
        Sum,
        Min,
        Multiply;

    }

    public static class FilterFunction {
        public final Filter filter;
        public final ScoreFunction function;

        public FilterFunction(Filter filter, ScoreFunction function) {
            this.filter = filter;
            this.function = function;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterFunction that = (FilterFunction)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
        }

        public int hashCode() {
            int result = this.filter != null ? this.filter.hashCode() : 0;
            result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
            return result;
        }
    }
}

