/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.indices.alias.head;

import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.StringRestResponse;

public class RestAliasesExistAction
extends BaseRestHandler {
    @Inject
    public RestAliasesExistAction(Settings settings, Client client, RestController controller) {
        super(settings, client);
        controller.registerHandler(RestRequest.Method.HEAD, "/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias/{name}", this);
        controller.registerHandler(RestRequest.Method.HEAD, "/{index}/_alias", this);
    }

    @Override
    public void handleRequest(RestRequest request, final RestChannel channel) {
        String[] aliases = request.paramAsStringArray("name", Strings.EMPTY_ARRAY);
        String[] indices = Strings.splitStringByCommaToArray(request.param("index"));
        GetAliasesRequest getAliasesRequest = new GetAliasesRequest(aliases);
        getAliasesRequest.indices(indices);
        getAliasesRequest.indicesOptions(IndicesOptions.fromRequest(request, getAliasesRequest.indicesOptions()));
        getAliasesRequest.local(request.paramAsBoolean("local", getAliasesRequest.local()));
        this.client.admin().indices().aliasesExist(getAliasesRequest, new ActionListener<AliasesExistResponse>(){

            @Override
            public void onResponse(AliasesExistResponse response) {
                try {
                    if (response.isExists()) {
                        channel.sendResponse(new StringRestResponse(RestStatus.OK));
                    } else {
                        channel.sendResponse(new StringRestResponse(RestStatus.NOT_FOUND));
                    }
                }
                catch (Throwable e) {
                    this.onFailure(e);
                }
            }

            @Override
            public void onFailure(Throwable e) {
                try {
                    channel.sendResponse(new StringRestResponse(ExceptionsHelper.status(e)));
                }
                catch (Exception e1) {
                    RestAliasesExistAction.this.logger.error("Failed to send failure response", e1, new Object[0]);
                }
            }
        });
    }
}

