/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.settings;

import java.util.Map;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.regex.Regex;

public class DynamicSettings {
    private ImmutableMap<String, Validator> dynamicSettings = ImmutableMap.of();

    public boolean hasDynamicSetting(String key) {
        for (String dynamicSetting : this.dynamicSettings.keySet()) {
            if (!Regex.simpleMatch(dynamicSetting, key)) continue;
            return true;
        }
        return false;
    }

    public String validateDynamicSetting(String dynamicSetting, String value) {
        for (Map.Entry setting : this.dynamicSettings.entrySet()) {
            if (!Regex.simpleMatch(dynamicSetting, (String)setting.getKey())) continue;
            return ((Validator)setting.getValue()).validate(dynamicSetting, value);
        }
        return null;
    }

    public synchronized void addDynamicSetting(String setting, Validator validator) {
        MapBuilder<String, Validator> updatedSettings = MapBuilder.newMapBuilder(this.dynamicSettings);
        updatedSettings.put(setting, validator);
        this.dynamicSettings = updatedSettings.immutableMap();
    }

    public synchronized void addDynamicSetting(String setting) {
        this.addDynamicSetting(setting, Validator.EMPTY);
    }

    public synchronized void addDynamicSettings(String ... settings) {
        MapBuilder<String, Validator> updatedSettings = MapBuilder.newMapBuilder(this.dynamicSettings);
        for (String setting : settings) {
            updatedSettings.put(setting, Validator.EMPTY);
        }
        this.dynamicSettings = updatedSettings.immutableMap();
    }
}

