/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.compiler.scopes.local;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.AbstractVariableDeclaration;
import com.github.sommeri.less4j.core.ast.Expression;
import com.github.sommeri.less4j.core.ast.ReusableStructure;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.Variable;
import com.github.sommeri.less4j.core.compiler.expressions.ExpressionFilter;
import com.github.sommeri.less4j.core.compiler.scopes.FullMixinDefinition;
import com.github.sommeri.less4j.core.compiler.scopes.ILocalScope;
import com.github.sommeri.less4j.core.compiler.scopes.IScope;
import com.github.sommeri.less4j.core.compiler.scopes.local.LocalScopeData;
import com.github.sommeri.less4j.core.compiler.scopes.local.MixinsDefinitionsStorage;
import com.github.sommeri.less4j.core.compiler.scopes.local.VariablesDeclarationsStorage;
import java.util.List;
import java.util.Stack;

public class LocalScope
implements ILocalScope {
    private String type;
    private final ASTCssNode owner;
    private boolean presentInAst = true;
    private LocalScopeData localData = new LocalScopeData();
    private Stack<LocalScopeData> localDataSnapshots = new Stack();
    private boolean cloneOnWrite = false;
    private boolean cloned;
    private List<String> names;

    public LocalScope(ASTCssNode owner, List<String> names, String type) {
        this.owner = owner;
        this.names = names;
        this.type = type;
    }

    public LocalScope(ASTCssNode owner, LocalScopeData initialLocalData, List<String> names, String type) {
        this(owner, names, type);
        this.localData = initialLocalData;
    }

    public LocalScope(ASTCssNode owner, LocalScopeData initialLocalData, List<String> names, String type, boolean cloneOnWrite, boolean cloned) {
        this(owner, names, type);
        this.localData = initialLocalData;
        this.cloneOnWrite = cloneOnWrite;
        this.cloned = cloned;
    }

    @Override
    public ASTCssNode getOwner() {
        return this.owner;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public boolean isBodyOwnerScope() {
        return "#body-owner#".equals(this.getType());
    }

    @Override
    public void removedFromAst() {
        this.presentInAst = false;
    }

    @Override
    public boolean isPresentInAst() {
        return this.presentInAst;
    }

    @Override
    public void addNames(List<String> names) {
        this.names.addAll(names);
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public void registerVariable(AbstractVariableDeclaration declaration) {
        this.getLocalVariables().store(declaration);
    }

    @Override
    public void registerVariable(AbstractVariableDeclaration node, Expression replacementValue) {
        this.getLocalVariables().store(node, replacementValue);
    }

    @Override
    public void registerVariableIfNotPresent(String name, Expression replacementValue) {
        this.getLocalVariables().storeIfNotPresent(name, replacementValue);
    }

    @Override
    public void registerVariable(String name, Expression replacementValue) {
        this.getLocalVariables().store(name, replacementValue);
    }

    @Override
    public void addFilteredVariables(ExpressionFilter filter, IScope source) {
        this.getLocalVariables().addFilteredVariables(filter, source.getLocalVariables());
    }

    @Override
    public Expression getValue(Variable variable) {
        return this.getLocalVariables().getValue(variable.getName());
    }

    @Override
    public Expression getValue(String name) {
        return this.getLocalVariables().getValue(name);
    }

    @Override
    public void addAllMixins(List<FullMixinDefinition> mixins) {
        this.getLocalMixins().storeAll(mixins);
    }

    @Override
    public void registerMixin(ReusableStructure mixin, IScope mixinsBodyScope) {
        this.getLocalMixins().store(new FullMixinDefinition(mixin, mixinsBodyScope));
    }

    @Override
    public ILocalScope.DataPlaceholder createDataPlaceholder() {
        VariablesDeclarationsStorage.VariablesPlaceholder variablesPlaceholder = this.getLocalVariables().createPlaceholder();
        MixinsDefinitionsStorage.MixinsPlaceholder mixinsPlaceholder = this.getLocalMixins().createPlaceholder();
        return new ILocalScope.DataPlaceholder(variablesPlaceholder, mixinsPlaceholder);
    }

    @Override
    public void addToDataPlaceholder(IScope otherScope) {
        this.getLocalVariables().addToFirstPlaceholderIfNotPresent(otherScope.getLocalVariables());
        this.getLocalMixins().addToPlaceholder(otherScope.getLocalMixins());
    }

    @Override
    public void replacePlaceholder(ILocalScope.DataPlaceholder placeholder, IScope otherScope) {
        this.getLocalVariables().replacePlaceholder(placeholder.getVariablesPlaceholder(), otherScope.getLocalVariables());
        this.getLocalMixins().replacePlaceholder(placeholder.getMixinsPlaceholder(), otherScope.getLocalMixins());
    }

    @Override
    public void closeDataPlaceholder() {
        this.getLocalVariables().closePlaceholder();
        this.getLocalMixins().closePlaceholder();
    }

    @Override
    public void add(IScope otherSope) {
        this.getLocalMixins().storeAll(otherSope.getLocalMixins());
        this.getLocalVariables().storeAll(otherSope.getLocalVariables());
    }

    @Override
    public LocalScopeData getLocalData() {
        return this.localData;
    }

    @Override
    public ILocalScope cloneCurrentDataSnapshot() {
        return new LocalScope(this.owner, this.localData, this.names, this.type, true, false);
    }

    @Override
    public boolean hasTheSameLocalData(ILocalScope otherScope) {
        return otherScope.getLocalData() == this.localData;
    }

    @Override
    public void createCurrentDataSnapshot() {
        this.localDataSnapshots.push(this.localData);
        this.cloneOnWrite = true;
        this.cloned = false;
    }

    @Override
    public void createOriginalDataSnapshot() {
        this.localDataSnapshots.push(this.localData);
        this.localData = (LocalScopeData)this.localDataSnapshots.firstElement();
        this.cloneOnWrite = true;
        this.cloned = false;
    }

    @Override
    public void discardLastDataSnapshot() {
        this.localData = this.localDataSnapshots.pop();
        this.cloneOnWrite = false;
        this.cloned = false;
    }

    @Override
    public MixinsDefinitionsStorage getLocalMixins() {
        this.cloneIfNeeded();
        return this.localData.getMixins();
    }

    @Override
    public VariablesDeclarationsStorage getLocalVariables() {
        this.cloneIfNeeded();
        return this.localData.getVariables();
    }

    @Override
    public List<FullMixinDefinition> getAllMixins() {
        return this.getLocalMixins().getAllMixins();
    }

    @Override
    public List<FullMixinDefinition> getMixinsByName(List<String> nameChain, ReusableStructureName name) {
        return this.getLocalMixins().getMixins(nameChain, name);
    }

    @Override
    public List<FullMixinDefinition> getMixinsByName(ReusableStructureName name) {
        return this.getLocalMixins().getMixins(name);
    }

    @Override
    public List<FullMixinDefinition> getMixinsByName(String name) {
        return this.getLocalMixins().getMixins(name);
    }

    private void cloneIfNeeded() {
        if (this.cloneOnWrite && !this.cloned) {
            this.localData = this.localData.clone();
            this.cloned = true;
        }
    }

    public String toString() {
        return this.localData.toString();
    }
}

