/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.cs;

import javax.measure.Unit;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.cs.AxisFilter;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public enum AxesConvention implements AxisFilter
{
    NORMALIZED{

        @Override
        public Unit<?> getUnitReplacement(CoordinateSystemAxis coordinateSystemAxis, Unit<?> object) {
            if (Units.isLinear(object)) {
                object = Units.METRE;
            } else if (Units.isAngular(object)) {
                object = Units.DEGREE;
            } else if (Units.isTemporal(object)) {
                object = Units.DAY;
            }
            return object;
        }

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis coordinateSystemAxis, AxisDirection axisDirection) {
            if (!AxisDirections.isIntercardinal(axisDirection) && (coordinateSystemAxis == null || coordinateSystemAxis.getMinimumValue() < 0.0)) {
                return AxisDirections.absolute(axisDirection);
            }
            return axisDirection;
        }
    }
    ,
    DISPLAY_ORIENTED{

        @Override
        public AxisDirection getDirectionReplacement(CoordinateSystemAxis coordinateSystemAxis, AxisDirection axisDirection) {
            return NORMALIZED.getDirectionReplacement(coordinateSystemAxis, axisDirection);
        }
    }
    ,
    RIGHT_HANDED,
    POSITIVE_RANGE;

}

