/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import java.math.BigInteger;
import java.util.Enumeration;
import org.exolab.castor.builder.types.XSPatternBase;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public class XSUnsignedLong
extends XSPatternBase {
    BigInteger maxInclusive = null;
    BigInteger maxExclusive = null;
    BigInteger minInclusive = null;
    BigInteger minExclusive = null;
    private static JType jType = new JClass("java.math.BigInteger");

    public XSUnsignedLong() {
        super((short)46);
        this.setMinInclusive(BigInteger.valueOf(0L));
        this.setMaxInclusive(new BigInteger("18446744073709551615"));
    }

    public JType getJType() {
        return jType;
    }

    public BigInteger getMaxExclusive() {
        return this.maxExclusive;
    }

    public BigInteger getMaxInclusive() {
        return this.maxInclusive;
    }

    public BigInteger getMinExclusive() {
        return this.minExclusive;
    }

    public BigInteger getMinInclusive() {
        return this.minInclusive;
    }

    public boolean hasMaximum() {
        return this.maxInclusive != null || this.maxExclusive != null;
    }

    public boolean hasMinimum() {
        return this.minInclusive != null || this.minExclusive != null;
    }

    public void setMaxExclusive(BigInteger max) {
        this.maxExclusive = max;
        this.maxInclusive = null;
    }

    public void setMaxInclusive(BigInteger max) {
        this.maxInclusive = max;
        this.maxExclusive = null;
    }

    public void setMinExclusive(BigInteger min) {
        this.minExclusive = min;
        this.minInclusive = null;
    }

    public void setMinInclusive(BigInteger min) {
        this.minInclusive = min;
        this.minExclusive = null;
    }

    public void setFacets(SimpleType simpleType) {
        Enumeration enumeration = XSUnsignedLong.getFacets(simpleType);
        while (enumeration.hasMoreElements()) {
            Facet facet = (Facet)enumeration.nextElement();
            String name = facet.getName();
            if ("maxExclusive".equals(name)) {
                this.setMaxExclusive(new BigInteger(facet.getValue()));
                continue;
            }
            if ("maxInclusive".equals(name)) {
                this.setMaxInclusive(new BigInteger(facet.getValue()));
                continue;
            }
            if ("minExclusive".equals(name)) {
                this.setMinExclusive(new BigInteger(facet.getValue()));
                continue;
            }
            if ("minInclusive".equals(name)) {
                this.setMinInclusive(new BigInteger(facet.getValue()));
                continue;
            }
            if (!"pattern".equals(name)) continue;
            this.setPattern(facet.getValue());
        }
    }

    public String createToJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("");
        sb.append(variableName);
        sb.append("");
        return sb.toString();
    }

    public String createFromJavaObjectCode(String variableName) {
        StringBuffer sb = new StringBuffer("((java.math.BigInteger)");
        sb.append(variableName);
        sb.append(")");
        return sb.toString();
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String fieldValidatorInstanceName) {
        String pattern;
        if (jsc == null) {
            jsc = new JSourceCode();
        }
        jsc.add("org.exolab.castor.xml.validators.BigIntegerValidator typeValidator = new org.exolab.castor.xml.validators.BigIntegerValidator();");
        if (this.hasMinimum()) {
            BigInteger min = this.getMinExclusive();
            if (min != null) {
                jsc.add("typeValidator.setMinExclusive(new java.math.BigInteger(\"");
            } else {
                min = this.getMinInclusive();
                jsc.add("typeValidator.setMinInclusive(new java.math.BigInteger(\"");
            }
            jsc.append(min.toString());
            jsc.append("\"));");
        }
        if (this.hasMaximum()) {
            BigInteger max = this.getMaxExclusive();
            if (max != null) {
                jsc.add("typeValidator.setMaxExclusive(new java.math.BigInteger(\"");
            } else {
                max = this.getMaxInclusive();
                jsc.add("typeValidator.setMaxInclusive(new java.math.BigInteger(\"");
            }
            jsc.append(max.toString());
            jsc.append("\"));");
        }
        if (fixedValue != null) {
            BigInteger value = new BigInteger(fixedValue);
            jsc.add("typeValidator.setFixed(new BigInteger(\"");
            jsc.append(fixedValue);
            jsc.append("\");");
        }
        if ((pattern = this.getPattern()) != null) {
            jsc.add("typeValidator.setPattern(\"");
            jsc.append(XSUnsignedLong.escapePattern(pattern));
            jsc.append("\");");
        }
        jsc.add(fieldValidatorInstanceName + ".setValidator(typeValidator);");
    }

    public String newInstanceCode() {
        return "new " + this.getJType().getName() + "(\"0\");";
    }
}

