/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.coreit;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoFailureException;

public class LoadableMojo
extends AbstractMojo {
    private String className;

    public void execute() throws MojoFailureException {
        if (!this.load(true) || !this.load(false)) {
            throw new MojoFailureException((Object)this, "Class-loading test failed..", "Failed to load class: " + this.className + " using one or more methods.");
        }
    }

    private boolean load(boolean useContextClassloader) throws MojoFailureException {
        this.getLog().info((CharSequence)("Executing in java version: " + System.getProperty("java.version")));
        ClassLoader cl = useContextClassloader ? Thread.currentThread().getContextClassLoader() : ((Object)((Object)this)).getClass().getClassLoader();
        this.getLog().info((CharSequence)("Attepting to load: " + this.className + " from: " + cl + (useContextClassloader ? " (context classloader)" : "")));
        try {
            Class<?> result = cl.loadClass(this.className);
            this.getLog().info((CharSequence)"Load succeeded.");
            return true;
        }
        catch (ClassNotFoundException e) {
            this.getLog().info((CharSequence)("Failed to load class: " + this.className + (useContextClassloader ? " using context classloader" : "")));
            return false;
        }
    }
}

