/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.sshd.common.config.keys.KeyEntryResolver;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.config.keys.PublicKeyRawDataDecoder;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface PublicKeyEntryDecoder
extends KeyEntryResolver,
PublicKeyRawDataDecoder,
PublicKeyEntryResolver {
    @Override
    default public PublicKey resolve(SessionContext session, String keyType, byte[] keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type provided");
        NavigableSet<String> supported = this.getSupportedKeyTypes();
        if (GenericUtils.size(supported) > 0 && supported.contains(keyType)) {
            return this.decodePublicKey(session, keyType, keyData, headers);
        }
        throw new InvalidKeySpecException("resolve(" + keyType + ") not in listed supported types: " + supported);
    }

    @Override
    default public PublicKey decodePublicKeyByType(SessionContext session, String keyType, InputStream keyData, Map<String, String> headers) throws IOException, GeneralSecurityException {
        String type = KeyEntryResolver.decodeString(keyData, 256);
        if (GenericUtils.isEmpty(type)) {
            throw new StreamCorruptedException("Missing key type string");
        }
        NavigableSet<String> supported = this.getSupportedKeyTypes();
        if (GenericUtils.isEmpty(supported) || !supported.contains(type)) {
            throw new InvalidKeySpecException("Reported key type (" + type + ") not in supported list: " + supported);
        }
        return this.decodePublicKey(session, type, keyData, headers);
    }

    public String encodePublicKey(OutputStream var1, PublicKey var2) throws IOException;
}

