/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.flow;

import jakarta.el.ValueExpression;
import jakarta.faces.context.FacesContext;
import jakarta.faces.flow.SwitchCase;
import jakarta.faces.flow.SwitchNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.myfaces.flow.Freezable;

public class SwitchNodeImpl
extends SwitchNode
implements Freezable {
    private String defaultOutcome;
    private ValueExpression defaultOutcomeEL;
    private String id;
    private List<SwitchCase> cases;
    private List<SwitchCase> unmodifiableCases;
    private boolean initialized;

    public SwitchNodeImpl(String switchNodeId) {
        this.id = switchNodeId;
        this.cases = new ArrayList<SwitchCase>();
        this.unmodifiableCases = Collections.unmodifiableList(this.cases);
    }

    public List<SwitchCase> getCases() {
        return this.unmodifiableCases;
    }

    public void addCase(SwitchCase switchCase) {
        this.checkInitialized();
        this.cases.add(switchCase);
    }

    public String getDefaultOutcome(FacesContext context) {
        if (this.defaultOutcomeEL != null) {
            return (String)this.defaultOutcomeEL.getValue(context.getELContext());
        }
        return this.defaultOutcome;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void freeze() {
        this.initialized = true;
        for (SwitchCase switchCase : this.cases) {
            if (!(switchCase instanceof Freezable)) continue;
            ((Freezable)switchCase).freeze();
        }
    }

    private void checkInitialized() throws IllegalStateException {
        if (this.initialized) {
            throw new IllegalStateException("Flow is inmutable once initialized");
        }
    }

    public void setDefaultOutcome(String defaultOutcome) {
        this.checkInitialized();
        this.defaultOutcome = defaultOutcome;
        this.defaultOutcomeEL = null;
    }

    public void setDefaultOutcome(ValueExpression defaultOutcome) {
        this.checkInitialized();
        this.defaultOutcomeEL = defaultOutcome;
        this.defaultOutcome = null;
    }

    public void setId(String id) {
        this.checkInitialized();
        this.id = id;
    }
}

