/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UpdateTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class InstalledTableModel
extends UnitCategoryTableModel {
    static final String STATE_ENABLED = NbBundle.getMessage(UpdateTableModel.class, "InstalledTableModel_State_Enabled");
    static final String STATE_DISABLED = NbBundle.getMessage(UpdateTableModel.class, "InstalledTableModel_State_Disabled");
    private OperationContainer<OperationSupport> enableContainer = Containers.forEnable();
    private OperationContainer<OperationSupport> disableContainer = Containers.forDisable();
    private OperationContainer<OperationSupport> uninstallContainer = Containers.forUninstall();
    private OperationContainer<OperationSupport> containerCustom = Containers.forCustomUninstall();
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.InstalledTableModel");
    private static String col0;
    private static String col1;
    private static String col2;
    private static String col3;
    private boolean twoViews = true;

    public InstalledTableModel(List<UpdateUnit> units) {
        this.setUnits(units);
    }

    @Override
    public final void setUnits(List<UpdateUnit> units) {
        this.setData(Utilities.makeInstalledCategories(units));
    }

    final void setUnits(List<UpdateUnit> units, List<UpdateUnit> features) {
        if (features.isEmpty()) {
            this.setUnits(units);
            this.twoViews = false;
        } else {
            this.setUnits(features);
            this.twoViews = true;
        }
    }

    @Override
    boolean supportsTwoViews() {
        return this.twoViews;
    }

    @Override
    public String getToolTipText(int row, int col) {
        if (col == 3) {
            Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
            assert (u != null) : "Unit must found at row " + row;
            String key = null;
            UpdateElement ue = u.getRelevantElement();
            UpdateUnit uu = u.getRelevantElement().getUpdateUnit();
            key = uu.isPending() ? (ue.getUpdateUnit().getInstalled() == null || !ue.getUpdateUnit().getInstalled().equals(ue) ? "InstallTab_PendingForInstall_Tooltip" : "InstallTab_PendingForDeactivate_Tooltip") : (ue.isEnabled() ? "InstallTab_Active_Tooltip" : "InstallTab_InActive_Tooltip");
            return key != null ? this.getBundle(key, new Object[0]) : null;
        }
        if (col == 0) {
            Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
            assert (u != null) : "Unit must found at row " + row;
            String key = null;
            UpdateElement ue = u.getRelevantElement();
            if (!u.canBeMarked()) {
                key = "InstallTab_ReadOnly_Tooltip";
            }
            return key != null ? this.getBundle(key, ue.getDisplayName()) : super.getToolTipText(row, col);
        }
        return super.getToolTipText(row, col);
    }

    @Override
    public void setValueAt(Object anValue, int row, int col) {
        super.setValueAt(anValue, row, col);
        if (col == 1) {
            return;
        }
        assert (col == 0) : "First column.";
        if (anValue == null) {
            return;
        }
        Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
        assert (anValue instanceof Boolean) : anValue + " must be instanceof Boolean.";
        boolean beforeMarked = u.isMarked();
        if ((Boolean)anValue != beforeMarked) {
            u.setMarked(!beforeMarked);
            if (u.isMarked() != beforeMarked) {
                this.fireButtonsChange();
            } else {
                String message = this.getBundle("NotificationAlreadyPreparedToIntsall", u.getDisplayName());
                DialogDisplayer.getDefault().notify(new NotifyDescriptor.Message(message));
            }
        }
    }

    @Override
    public Object getValueAt(int row, int col) {
        Object res = null;
        Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
        if (u == null) {
            return res;
        }
        switch (col) {
            case 0: {
                res = u.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: {
                res = u.getDisplayName();
                break;
            }
            case 2: {
                res = u.getCategoryName();
                break;
            }
            case 3: {
                res = u.getRelevantElement().isEnabled();
            }
        }
        return res;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class getColumnClass(int c) {
        Class res = null;
        switch (c) {
            case 0: {
                res = Boolean.class;
                break;
            }
            case 1: {
                res = String.class;
                break;
            }
            case 2: {
                res = String.class;
                break;
            }
            case 3: {
                res = Boolean.class;
            }
        }
        return res;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                if (col0 == null) {
                    col0 = this.getBundle("InstalledTableModel_Columns_Uninstall", new Object[0]);
                }
                return col0;
            }
            case 1: {
                if (col1 == null) {
                    col1 = this.getBundle("InstalledTableModel_Columns_Name", new Object[0]);
                }
                return col1;
            }
            case 2: {
                if (col2 == null) {
                    col2 = this.getBundle("InstalledTableModel_Columns_Category", new Object[0]);
                }
                return col2;
            }
            case 3: {
                if (col3 == null) {
                    col3 = this.getBundle("InstalledTableModel_Columns_Enabled", new Object[0]);
                }
                return col3;
            }
        }
        assert (false);
        return super.getColumnName(column);
    }

    @Override
    public int getMinWidth(JTableHeader header, int col) {
        return super.getMinWidth(header, col);
    }

    @Override
    public int getPreferredWidth(JTableHeader header, int col) {
        int minWidth = super.getMinWidth(header, col);
        switch (col) {
            case 1: {
                return minWidth * 5;
            }
            case 2: {
                return minWidth * 3;
            }
        }
        return minWidth;
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.INSTALLED;
    }

    @Override
    public boolean isSortAllowed(Object columnIdentifier) {
        boolean isUninstall = this.getColumnName(0).equals(columnIdentifier);
        return !isUninstall;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object columnIdentifier, final boolean sortAscending) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit o1, Unit o2) {
                Unit unit2;
                Unit unit1 = sortAscending ? o1 : o2;
                Unit unit = unit2 = sortAscending ? o2 : o1;
                if (InstalledTableModel.this.getColumnName(0).equals(columnIdentifier)) {
                    assert (false) : columnIdentifier.toString();
                } else {
                    if (InstalledTableModel.this.getColumnName(1).equals(columnIdentifier)) {
                        return Unit.compareDisplayNames(unit1, unit2);
                    }
                    if (InstalledTableModel.this.getColumnName(2).equals(columnIdentifier)) {
                        return Unit.compareCategories(unit1, unit2);
                    }
                    if (InstalledTableModel.this.getColumnName(3).equals(columnIdentifier)) {
                        return Unit.Installed.compareEnabledState(unit1, unit2);
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public int getDownloadSize() {
        return 0;
    }

    private String getBundle(String key, Object ... params) {
        return NbBundle.getMessage(this.getClass(), key, params);
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        Unit.Installed u = (Unit.Installed)this.getUnitAtRow(row);
        return col == 0 ? u != null && u.canBeMarked() : super.isCellEditable(row, col);
    }

    @Override
    public String getTabTitle() {
        return NbBundle.getMessage(PluginManagerUI.class, "PluginManagerUI_UnitTab_Installed_Title");
    }

    @Override
    public int getTabIndex() {
        return 3;
    }

    @Override
    public boolean needsRestart() {
        return true;
    }
}

