/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.protocol.foo;

import crawlercommons.robots.BaseRobotRules;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.net.protocols.HttpDateFormat;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.protocol.Protocol;
import org.apache.nutch.protocol.ProtocolOutput;
import org.apache.nutch.protocol.ProtocolStatus;
import org.apache.nutch.protocol.RobotRulesParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Foo
implements Protocol {
    protected static final Logger LOG = LoggerFactory.getLogger(Foo.class);
    private Configuration conf;

    public Configuration getConf() {
        LOG.debug("getConf()");
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public ProtocolOutput getProtocolOutput(Text url, CrawlDatum datum) {
        LOG.debug("getProtocolOutput({}, {})", (Object)url, (Object)datum);
        try {
            String urlstr = String.valueOf(url);
            URL u = new URL(urlstr);
            URL base = new URL(u, ".");
            byte[] bytes = new byte[]{};
            String contentType = "foo/something";
            ProtocolStatus status = ProtocolStatus.STATUS_GONE;
            switch (urlstr) {
                case "foo://example.com": 
                case "foo://example.com/": {
                    String time = HttpDateFormat.toString((long)System.currentTimeMillis());
                    contentType = "text/html";
                    StringBuffer sb = new StringBuffer();
                    sb.append("<html><head>");
                    sb.append("<title>Index of /</title></head>\n");
                    sb.append("<body><h1>Index of /</h1><pre>\n");
                    sb.append("<a href='a/'>a/</a>\t" + time + "\t-\n");
                    sb.append("<a href='a.txt'>a.txt</a>\t" + time + "\t0\n");
                    sb.append("</pre></html></body>");
                    bytes = sb.toString().getBytes();
                    status = ProtocolStatus.STATUS_SUCCESS;
                    break;
                }
                case "foo://example.com/a/": {
                    String time = HttpDateFormat.toString((long)System.currentTimeMillis());
                    contentType = "text/html";
                    StringBuffer sb = new StringBuffer();
                    sb.append("<html><head>");
                    sb.append("<title>Index of /a/</title></head>\n");
                    sb.append("<body><h1>Index of /a/</h1><pre>\n");
                    sb.append("<a href='aa.txt'>aa.txt</a>\t" + time + "\t0\n");
                    sb.append("<a href='ab.txt'>ab.txt</a>\t" + time + "\t0\n");
                    sb.append("</pre></html></body>");
                    bytes = sb.toString().getBytes();
                    status = ProtocolStatus.STATUS_SUCCESS;
                    break;
                }
                case "foo://example.com/a.txt": 
                case "foo://example.com/a/aa.txt": 
                case "foo://example.com/a/ab.txt": {
                    contentType = "text/plain";
                    bytes = "In publishing and graphic design, lorem ipsum is a filler text or greeking commonly used to demonstrate the textual elements of a graphic document or visual presentation. Replacing meaningful content with placeholder text allows designers to design the form of the content before the content itself has been produced.".getBytes();
                    status = ProtocolStatus.STATUS_SUCCESS;
                    break;
                }
                default: {
                    LOG.warn("Unknown url '{}'. This dummy implementation only supports 'foo://example.com'", (Object)url);
                }
            }
            Metadata metadata = new Metadata();
            Content content = new Content(String.valueOf(url), String.valueOf(base), bytes, contentType, metadata, this.getConf());
            return new ProtocolOutput(content, status);
        }
        catch (MalformedURLException mue) {
            LOG.error("Could not retrieve {}", (Object)url);
            LOG.error("", (Throwable)mue);
            return new ProtocolOutput(null, ProtocolStatus.STATUS_GONE);
        }
    }

    public BaseRobotRules getRobotRules(Text url, CrawlDatum datum, List<Content> robotsTxtContent) {
        LOG.debug("getRobotRules({}, {}, {})", new Object[]{url, datum, robotsTxtContent});
        return RobotRulesParser.EMPTY_RULES;
    }
}

