/*
 * Decompiled with CFR 0.152.
 */
package org.archive.format.arc;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Date;
import org.archive.format.arc.ARCConstants;
import org.archive.format.arc.ARCFormatException;
import org.archive.format.arc.ARCMetaData;
import org.archive.util.DateUtils;
import org.archive.util.StringParse;

public class ARCMetaDataParser
implements ARCConstants {
    private boolean strict = false;
    private byte[] buffer;

    public ARCMetaDataParser() {
        this(32768);
    }

    public ARCMetaDataParser(int maxLength) {
        this.buffer = new byte[maxLength];
    }

    public ARCMetaData parse(InputStream is) throws ARCFormatException, IOException {
        return this.parse(is, this.strict);
    }

    public ARCMetaData parse(InputStream is, boolean strict) throws ARCFormatException, IOException {
        return this.parse(is, strict, false);
    }

    public ARCMetaData parseEOFOK(InputStream is) throws ARCFormatException, IOException {
        return this.parseEOFOK(is, this.strict);
    }

    public ARCMetaData parseEOFOK(InputStream is, boolean strict) throws ARCFormatException, IOException {
        return this.parse(is, strict, true);
    }

    public ARCMetaData parse(InputStream is, boolean strict, boolean emptyOK) throws ARCFormatException, IOException {
        ARCMetaData data = new ARCMetaData();
        int bufPos = 0;
        int leadingNL = 0;
        boolean gotNonNL = false;
        boolean gotNL = false;
        boolean sawSpace = false;
        int bufLen = this.buffer.length;
        while (bufPos < bufLen) {
            int c = is.read();
            if (c == -1) {
                if (emptyOK && bufPos == 0) {
                    return null;
                }
                throw new ARCFormatException("Got EOF before newline");
            }
            if (c == 10) {
                if (gotNonNL) {
                    gotNL = true;
                    break;
                }
                ++leadingNL;
                continue;
            }
            gotNonNL = true;
            if (sawSpace) {
                if (c < 32 || c > 127) {
                    throw new ARCFormatException("Non-ASCII CHARS in metadata.");
                }
            } else {
                sawSpace = c == 32;
            }
            this.buffer[bufPos] = (byte)(c & 0xFF);
            ++bufPos;
        }
        if (!gotNL) {
            throw new ARCFormatException("No newline");
        }
        data.setLeadingNL(leadingNL);
        data.setHeaderLength(bufPos + 1);
        String line = new String(this.buffer, 0, bufPos, ARC_META_CHARSET);
        String[] parts = line.split(" ", -1);
        if (parts.length == 5) {
            this.parseUrl(data, parts[0], strict);
            this.parseIP(data, parts[1], strict);
            this.parseDate(data, parts[2], strict);
            this.parseMime(data, parts[3], strict);
            this.parseLength(data, parts[4], strict);
        } else {
            if (strict) {
                throw new ARCFormatException("Wrong number of fields in(" + line + ")");
            }
            if (parts.length < 5) {
                throw new ARCFormatException("Too few fields in(" + line + ")");
            }
            if (parts.length == 6) {
                this.parseUrl(data, parts[0], strict);
                this.parseIP(data, parts[1], strict);
                this.parseDate(data, parts[2], strict);
                this.parseMime(data, parts[3] + "%20" + parts[4], strict);
                this.parseLength(data, parts[5], strict);
            } else {
                for (int i = 5; i < parts.length; ++i) {
                    if (parts[i].length() == 0) continue;
                    throw new ARCFormatException("Extra fields in(" + line + ")");
                }
                this.parseUrl(data, parts[0], strict);
                this.parseIP(data, parts[1], strict);
                this.parseDate(data, parts[2], strict);
                this.parseMime(data, parts[3], strict);
                this.parseLength(data, parts[4], strict);
            }
        }
        return data;
    }

    private void parseUrl(ARCMetaData data, String u, boolean strict) throws ARCFormatException {
        if (u.length() < 1) {
            throw new ARCFormatException("Bad Url(" + u + ")");
        }
        data.setUrl(u);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseIP(ARCMetaData data, String ip, boolean strict) throws ARCFormatException {
        if (strict) {
            if (!StringParse.isIP(ip)) throw new ARCFormatException("Bad IP address(" + ip + ")");
            data.setIP(ip);
            return;
        } else {
            if (ip.length() < 1) {
                throw new ARCFormatException("Bad IP(" + ip + ")");
            }
            data.setIP(ip);
        }
    }

    private void parseDate(ARCMetaData data, String ds, boolean strict) throws ARCFormatException {
        try {
            Date d = DateUtils.getDate(ds);
            data.setDateBoth(d, ds);
        }
        catch (ParseException e) {
            throw new ARCFormatException("Bad date(" + ds + ")");
        }
    }

    private void parseMime(ARCMetaData data, String m, boolean strict) throws ARCFormatException {
        if (strict) {
            if (m.length() < 1) {
                throw new ARCFormatException("Bad Mime(" + m + ")");
            }
            data.setMime(m);
        } else if (m.length() < 1) {
            data.setMime("x-archive/unknown");
        } else {
            data.setMime(m);
        }
    }

    private void parseLength(ARCMetaData data, String ls, boolean strict) throws ARCFormatException {
        try {
            long l = Long.valueOf(ls);
            if (l < 0L) {
                throw new ARCFormatException("Bad Length(" + ls + ")");
            }
            data.setLength(l);
        }
        catch (NumberFormatException e) {
            throw new ARCFormatException("Bad Length(" + ls + ")");
        }
    }
}

