/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.sampler;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.common.collect.List;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.NonCollectingAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.sampler.DiversifiedNumericSamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.SamplerAggregator;
import org.elasticsearch.search.aggregations.bucket.sampler.UnmappedSampler;
import org.elasticsearch.search.aggregations.support.CoreValuesSourceType;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceRegistry;
import org.elasticsearch.search.aggregations.support.ValuesSourceType;
import org.elasticsearch.search.internal.SearchContext;

public class DiversifiedAggregatorFactory
extends ValuesSourceAggregatorFactory {
    private final int shardSize;
    private final int maxDocsPerValue;
    private final String executionHint;

    public static void registerAggregators(ValuesSourceRegistry.Builder builder) {
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, List.of((Object[])new ValuesSourceType[]{CoreValuesSourceType.NUMERIC, CoreValuesSourceType.DATE, CoreValuesSourceType.BOOLEAN}), (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> new DiversifiedNumericSamplerAggregator(name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue), true);
        builder.register(DiversifiedAggregationBuilder.REGISTRY_KEY, CoreValuesSourceType.BYTES, (name, shardSize, factories, context, parent, metadata, valuesSourceConfig, maxDocsPerValue, executionHint) -> {
            SamplerAggregator.ExecutionMode execution = null;
            if (executionHint != null) {
                execution = SamplerAggregator.ExecutionMode.fromString(executionHint);
            }
            if (execution == null) {
                execution = SamplerAggregator.ExecutionMode.GLOBAL_ORDINALS;
            }
            if (execution.needsGlobalOrdinals() && !valuesSourceConfig.hasGlobalOrdinals()) {
                execution = SamplerAggregator.ExecutionMode.MAP;
            }
            return execution.create(name, factories, shardSize, maxDocsPerValue, valuesSourceConfig, context, parent, metadata);
        }, true);
    }

    DiversifiedAggregatorFactory(String name, ValuesSourceConfig config, int shardSize, int maxDocsPerValue, String executionHint, QueryShardContext queryShardContext, AggregatorFactory parent, AggregatorFactories.Builder subFactoriesBuilder, Map<String, Object> metadata) throws IOException {
        super(name, config, queryShardContext, parent, subFactoriesBuilder, metadata);
        this.shardSize = shardSize;
        this.maxDocsPerValue = maxDocsPerValue;
        this.executionHint = executionHint;
    }

    @Override
    protected Aggregator doCreateInternal(SearchContext searchContext, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        return this.queryShardContext.getValuesSourceRegistry().getAggregator(DiversifiedAggregationBuilder.REGISTRY_KEY, this.config).build(this.name, this.shardSize, this.factories, searchContext, parent, metadata, this.config, this.maxDocsPerValue, this.executionHint);
    }

    @Override
    protected Aggregator createUnmapped(SearchContext searchContext, Aggregator parent, Map<String, Object> metadata) throws IOException {
        final UnmappedSampler aggregation = new UnmappedSampler(this.name, metadata);
        return new NonCollectingAggregator(this.name, searchContext, parent, this.factories, metadata){

            @Override
            public InternalAggregation buildEmptyAggregation() {
                return aggregation;
            }
        };
    }
}

