/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class CommandRunner {
    private boolean _waitForExit = true;
    private String _command;
    private int _timeout = 10;
    private InputStream _stdin;
    private OutputStream _stdout;
    private OutputStream _stderr;
    private static final int BUF = 4096;
    private int _xit;
    private Throwable _thrownError;
    private CyclicBarrier _barrier;

    public int getExitValue() {
        return this._xit;
    }

    public void setCommand(String s) {
        this._command = s;
    }

    public String getCommand() {
        return this._command;
    }

    public void setInputStream(InputStream is) {
        this._stdin = is;
    }

    public void setStdOutputStream(OutputStream os) {
        this._stdout = os;
    }

    public void setStdErrorStream(OutputStream os) {
        this._stderr = os;
    }

    public void evaluate() throws IOException {
        this.exec();
    }

    public int exec() throws IOException {
        Process proc = Runtime.getRuntime().exec(this._command);
        this._barrier = new CyclicBarrier(3 + (this._stdin != null ? 1 : 0));
        PullerThread so = new PullerThread("STDOUT", proc.getInputStream(), this._stdout);
        so.setDaemon(true);
        so.start();
        PullerThread se = new PullerThread("STDERR", proc.getErrorStream(), this._stderr);
        se.setDaemon(true);
        se.start();
        PusherThread si = null;
        if (this._stdin != null) {
            si = new PusherThread("STDIN", this._stdin, proc.getOutputStream());
            si.setDaemon(true);
            si.start();
        }
        boolean _timedout = false;
        long end = System.currentTimeMillis() + (long)(this._timeout * 1000);
        try {
            if (this._timeout == 0) {
                this._barrier.await();
            } else {
                this._barrier.await(this._timeout, TimeUnit.SECONDS);
            }
        }
        catch (TimeoutException ex) {
            _timedout = true;
        }
        catch (BrokenBarrierException ex) {
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        if (si != null) {
            si.interrupt();
        }
        so.interrupt();
        se.interrupt();
        this._xit = -1;
        if (!_timedout) {
            if (this._waitForExit) {
                do {
                    try {
                        Thread.sleep(1000L);
                        this._xit = proc.exitValue();
                        break;
                    }
                    catch (InterruptedException ie) {
                        if (!Thread.interrupted()) continue;
                        break;
                    }
                    catch (IllegalThreadStateException iltse) {
                        // empty catch block
                    }
                } while (!(_timedout = System.currentTimeMillis() > end));
            } else {
                try {
                    this._xit = proc.exitValue();
                }
                catch (IllegalThreadStateException iltse) {
                    _timedout = true;
                }
            }
        }
        if (this._waitForExit) {
            proc.destroy();
        }
        return this._xit;
    }

    public Throwable getThrownError() {
        return this._thrownError;
    }

    public int getTimeout() {
        return this._timeout;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    public boolean getWaitForExit() {
        return this._waitForExit;
    }

    public void setWaitForExit(boolean waitForExit) {
        this._waitForExit = waitForExit;
    }

    public static void main(String[] args) throws Exception {
        String commandPath = null;
        String filePath = null;
        int timeout = 10;
        String usage = "Usage: CommandRunner [-timeout timeoutSecs] commandPath filePath";
        if (args.length < 2) {
            System.err.println(usage);
            System.exit(-1);
        }
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-timeout")) {
                timeout = Integer.parseInt(args[++i]);
                continue;
            }
            if (i != args.length - 2) {
                System.err.println(usage);
                System.exit(-1);
                continue;
            }
            commandPath = args[i];
            filePath = args[++i];
        }
        CommandRunner cr = new CommandRunner();
        cr.setCommand(commandPath);
        cr.setInputStream(new FileInputStream(filePath));
        cr.setStdErrorStream(System.err);
        cr.setStdOutputStream(System.out);
        cr.setTimeout(timeout);
        cr.evaluate();
        System.err.println("output value: " + cr.getExitValue());
    }

    private class PullerThread
    extends PumperThread {
        PullerThread(String name, InputStream is, OutputStream os) {
            super(name, is, os, true);
        }
    }

    private class PusherThread
    extends PumperThread {
        PusherThread(String name, InputStream is, OutputStream os) {
            super(name, is, os, false);
        }
    }

    private class PumperThread
    extends Thread {
        private OutputStream _os;
        private InputStream _is;
        private boolean _closeInput;

        protected PumperThread(String name, InputStream is, OutputStream os, boolean closeInput) {
            super(name);
            this._is = is;
            this._os = os;
            this._closeInput = closeInput;
        }

        @Override
        public void run() {
            try {
                byte[] buf = new byte[4096];
                int read = 0;
                while (!this.isInterrupted() && (read = this._is.read(buf)) != -1) {
                    if (read == 0) continue;
                    this._os.write(buf, 0, read);
                    this._os.flush();
                }
            }
            catch (InterruptedIOException buf) {
            }
            catch (Throwable t) {
                CommandRunner.this._thrownError = t;
            }
            finally {
                try {
                    if (this._closeInput) {
                        this._is.close();
                    } else {
                        this._os.close();
                    }
                }
                catch (IOException buf) {}
            }
            try {
                CommandRunner.this._barrier.await();
            }
            catch (InterruptedException interruptedException) {
            }
            catch (BrokenBarrierException brokenBarrierException) {
                // empty catch block
            }
        }
    }
}

