/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.management.events;

import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.events.AbstractWanConfigurationEventBase;
import com.hazelcast.internal.management.events.EventMetadata;
import com.hazelcast.internal.util.UuidUtil;
import java.util.Collection;

public class WanConfigurationExtendedEvent
extends AbstractWanConfigurationEventBase {
    private final Collection<String> wanPublisherIds;

    public WanConfigurationExtendedEvent(String wanConfigName, Collection<String> wanPublisherIds) {
        super(UuidUtil.newUnsecureUUID(), wanConfigName);
        this.wanPublisherIds = wanPublisherIds;
    }

    @Override
    public EventMetadata.EventType getType() {
        return EventMetadata.EventType.WAN_CONFIGURATION_EXTENDED;
    }

    @Override
    public JsonObject toJson() {
        JsonObject json = super.toJson();
        JsonArray publisherIds = new JsonArray();
        for (String publisherId : this.wanPublisherIds) {
            publisherIds.add(publisherId);
        }
        json.add("wanPublisherIds", publisherIds);
        return json;
    }
}

