/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.db.dao.basic;

import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.util.Date;
import java.util.List;
import org.apache.openmeetings.db.entity.basic.ChatMessage;
import org.apache.openmeetings.db.util.DaoHelper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
@Transactional
public class ChatDao {
    @PersistenceContext
    private EntityManager em;

    public ChatMessage get(long id) {
        return (ChatMessage)this.em.createNamedQuery("getChatMessageById", ChatMessage.class).setParameter("id", (Object)id).getSingleResult();
    }

    public List<ChatMessage> get(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getChatMessages", ChatMessage.class), start, count).getResultList();
    }

    public List<ChatMessage> getGlobal(long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getGlobalChatMessages", ChatMessage.class), start, count).getResultList();
    }

    public List<ChatMessage> getRoom(long roomId, long start, long count, boolean all) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getChatMessagesByRoom", ChatMessage.class).setParameter("roomId", (Object)roomId).setParameter("all", (Object)all), start, count).getResultList();
    }

    public List<ChatMessage> getUser(long userId, long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getChatMessagesByUser", ChatMessage.class).setParameter("userId", (Object)userId), start, count).getResultList();
    }

    public List<ChatMessage> getUserRecent(long userId, Date date, long start, long count) {
        return DaoHelper.setLimits(this.em.createNamedQuery("getChatMessagesByUserTime", ChatMessage.class).setParameter("userId", (Object)userId).setParameter("status", (Object)ChatMessage.Status.CLOSED).setParameter("date", (Object)date), start, count).getResultList();
    }

    public void closeMessages(long userId) {
        this.em.createNamedQuery("chatCloseMessagesByUser").setParameter("userId", (Object)userId).setParameter("status", (Object)ChatMessage.Status.CLOSED).executeUpdate();
    }

    public ChatMessage update(ChatMessage entity) {
        return this.update(entity, null);
    }

    public ChatMessage update(ChatMessage entity, Date sent) {
        entity.setSent(sent == null ? new Date() : sent);
        if (entity.getId() == null) {
            this.em.persist((Object)entity);
        }
        return entity;
    }

    public void delete(ChatMessage entity, long userId) {
    }

    public void deleteGlobal() {
        this.em.createNamedQuery("deleteChatGlobal").executeUpdate();
    }

    public void deleteRoom(Long roomId) {
        this.em.createNamedQuery("deleteChatRoom").setParameter("roomId", (Object)roomId).executeUpdate();
    }

    public void deleteUser(Long userId) {
        this.em.createNamedQuery("deleteChatUser").setParameter("userId", (Object)userId).executeUpdate();
    }
}

