/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openmeetings.web.common.upload;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.apache.openmeetings.util.OpenmeetingsVariables;
import org.apache.openmeetings.web.app.WebSession;
import org.apache.openmeetings.web.common.MainPanel;
import org.apache.openmeetings.web.util.upload.BootstrapFileUploadBehavior;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.PriorityHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Bytes;

public abstract class UploadForm
extends Panel {
    private static final long serialVersionUID = 1L;
    private final String action;
    protected final WebMarkupContainer form = new WebMarkupContainer("form");

    protected UploadForm(String id, String action) {
        super(id);
        this.action = action;
        this.setRenderBodyOnly(true);
    }

    protected void onInitialize() {
        MainPanel mainPanel = (MainPanel)((Object)this.findParent(MainPanel.class));
        this.add(new Component[]{this.form.add(new Behavior[]{AttributeModifier.append((String)"data-max-size", (Serializable)Long.valueOf(OpenmeetingsVariables.getMaxUploadSize()))}).add(new Behavior[]{AttributeModifier.append((String)"data-max-size-lbl", (Serializable)((Object)Bytes.bytes((long)OpenmeetingsVariables.getMaxUploadSize()).toString(WebSession.get().getLocale())))}).add(new Behavior[]{AttributeModifier.append((String)"data-upload-lbl", (Serializable)((Object)this.getString(this.buttonLabelKey())))}).add(new Behavior[]{AttributeModifier.append((String)"action", (Serializable)((Object)this.action))}).setOutputMarkupId(true).setOutputMarkupPlaceholderTag(true)});
        this.form.add(new Component[]{new WebMarkupContainer("sid").add(new Behavior[]{AttributeModifier.append((String)"value", (Serializable)((Object)mainPanel.getClient().getSid()))}).setOutputMarkupId(true)});
        WebMarkupContainer file = new WebMarkupContainer("file");
        if (this.allowMultiple()) {
            file.add(new Behavior[]{AttributeModifier.append((String)"multiple", (Serializable)((Object)"multiple"))});
        }
        this.form.add(new Component[]{file});
        this.form.add(new Component[]{new WebMarkupContainer("desc-block").setVisible(this.showDescBlock())});
        Long maxBytes = OpenmeetingsVariables.getMaxUploadSize();
        double megaBytes = maxBytes.doubleValue() / 1024.0 / 1024.0;
        DecimalFormat formatter = new DecimalFormat("#,###.00");
        this.form.add(new Component[]{new Label("MaxUploadSize", (Serializable)((Object)formatter.format(megaBytes)))});
        this.form.add(new Component[]{new Label("btn-label", (IModel)new ResourceModel(this.buttonLabelKey()))});
        this.add(new Component[]{new WebMarkupContainer("progress-title").add(new Behavior[]{AttributeModifier.append((String)"data-processing-lbl", (Serializable)((Object)this.getString(this.processingLabelKey())))})});
        this.add(new Behavior[]{BootstrapFileUploadBehavior.getInstance()});
        super.onInitialize();
    }

    public void show(IPartialPageRequestHandler handler) {
        handler.add(new Component[]{this.form.setVisible(true)});
        handler.appendJavaScript((CharSequence)("Upload.bindUpload(\"" + this.uploadLocation() + "\", " + this.extraBindFunc() + ", " + this.onCompleteFunc() + ");"));
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)new PriorityHeaderItem((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)new JavaScriptResourceReference(UploadForm.class, "upload.js"))));
    }

    protected abstract String uploadLocation();

    protected String extraBindFunc() {
        return "null";
    }

    protected String onCompleteFunc() {
        return "null";
    }

    protected boolean allowMultiple() {
        return true;
    }

    protected boolean showDescBlock() {
        return true;
    }

    protected String buttonLabelKey() {
        return "593";
    }

    protected String processingLabelKey() {
        return "upload.dlg.convert.title";
    }
}

