/*
 * Decompiled with CFR 0.152.
 */
package com.github.caldav4j.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.Header;
import org.apache.http.HttpResponse;

public class UrlUtils {
    public static String stripHost(String href) {
        if (!href.startsWith("http")) {
            return href;
        }
        int indexOfColon = href.indexOf(":");
        int index = href.indexOf("/", indexOfColon + 3);
        return href.substring(index);
    }

    public static String removeDoubleSlashes(String s) {
        return s.replaceAll("([^:])/{2,}", "$1/");
    }

    public static String ensureTrailingSlash(String s) {
        return s.endsWith("/") ? s : s.concat("/");
    }

    public static String getHeaderPrettyValue(HttpResponse response, String headerName) {
        Header header;
        if (response != null && headerName != null && (header = response.getFirstHeader(headerName)) != null) {
            return header.getValue();
        }
        return null;
    }

    public static String parseISToString(InputStream is) {
        StringBuffer sb = new StringBuffer();
        try (InputStream inputStream = is;){
            BufferedReader din = new BufferedReader(new InputStreamReader(inputStream));
            String line = null;
            while ((line = din.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (Exception ex) {
            ex.getMessage();
        }
        return sb.toString();
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null ? str2 == null : str1.equalsIgnoreCase(str2);
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    public static boolean isBlank(String str) {
        return str == null || str.length() == 0 || "".equals(str.trim());
    }

    public static boolean isNotBlank(String str) {
        return !UrlUtils.isBlank(str);
    }
}

