/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class NLMNetworkNumberIs extends NLM implements Message {

  // Accessors for discriminator values.
  public Short getMessageType() {
    return (short) 0x13;
  }

  // Properties.
  protected final int networkNumber;
  protected final boolean networkNumberConfigured;

  // Arguments.
  protected final Integer apduLength;
  // Reserved Fields
  private Byte reservedField0;

  public NLMNetworkNumberIs(
      int networkNumber, boolean networkNumberConfigured, Integer apduLength) {
    super(apduLength);
    this.networkNumber = networkNumber;
    this.networkNumberConfigured = networkNumberConfigured;
    this.apduLength = apduLength;
  }

  public int getNetworkNumber() {
    return networkNumber;
  }

  public boolean getNetworkNumberConfigured() {
    return networkNumberConfigured;
  }

  @Override
  protected void serializeNLMChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("NLMNetworkNumberIs");

    // Simple Field (networkNumber)
    writeSimpleField("networkNumber", networkNumber, writeUnsignedInt(writeBuffer, 16));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (byte) 0,
        writeUnsignedByte(writeBuffer, 7));

    // Simple Field (networkNumberConfigured)
    writeSimpleField("networkNumberConfigured", networkNumberConfigured, writeBoolean(writeBuffer));

    writeBuffer.popContext("NLMNetworkNumberIs");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    NLMNetworkNumberIs _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (networkNumber)
    lengthInBits += 16;

    // Reserved Field (reserved)
    lengthInBits += 7;

    // Simple field (networkNumberConfigured)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static NLMBuilder staticParseNLMBuilder(ReadBuffer readBuffer, Integer apduLength)
      throws ParseException {
    readBuffer.pullContext("NLMNetworkNumberIs");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int networkNumber = readSimpleField("networkNumber", readUnsignedInt(readBuffer, 16));

    Byte reservedField0 = readReservedField("reserved", readUnsignedByte(readBuffer, 7), (byte) 0);

    boolean networkNumberConfigured =
        readSimpleField("networkNumberConfigured", readBoolean(readBuffer));

    readBuffer.closeContext("NLMNetworkNumberIs");
    // Create the instance
    return new NLMNetworkNumberIsBuilderImpl(
        networkNumber, networkNumberConfigured, apduLength, reservedField0);
  }

  public static class NLMNetworkNumberIsBuilderImpl implements NLM.NLMBuilder {
    private final int networkNumber;
    private final boolean networkNumberConfigured;
    private final Integer apduLength;
    private final Byte reservedField0;

    public NLMNetworkNumberIsBuilderImpl(
        int networkNumber,
        boolean networkNumberConfigured,
        Integer apduLength,
        Byte reservedField0) {
      this.networkNumber = networkNumber;
      this.networkNumberConfigured = networkNumberConfigured;
      this.apduLength = apduLength;
      this.reservedField0 = reservedField0;
    }

    public NLMNetworkNumberIs build(Integer apduLength) {

      NLMNetworkNumberIs nLMNetworkNumberIs =
          new NLMNetworkNumberIs(networkNumber, networkNumberConfigured, apduLength);
      nLMNetworkNumberIs.reservedField0 = reservedField0;
      return nLMNetworkNumberIs;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof NLMNetworkNumberIs)) {
      return false;
    }
    NLMNetworkNumberIs that = (NLMNetworkNumberIs) o;
    return (getNetworkNumber() == that.getNetworkNumber())
        && (getNetworkNumberConfigured() == that.getNetworkNumberConfigured())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNetworkNumber(), getNetworkNumberConfigured());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
