/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.client.impl;

import java.util.BitSet;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.api.MessageIdAdv;
import org.apache.pulsar.client.impl.ChunkMessageIdImpl;
import org.apache.pulsar.client.impl.MessageIdImpl;

public class MessageIdAdvUtils {
    static int hashCode(MessageIdAdv msgId) {
        return (int)(31L * (msgId.getLedgerId() + 31L * msgId.getEntryId()) + 31L * (long)msgId.getPartitionIndex() + (long)msgId.getBatchIndex());
    }

    static boolean equals(MessageIdAdv lhs, Object o) {
        if (!(o instanceof MessageIdAdv)) {
            return false;
        }
        MessageIdAdv rhs = (MessageIdAdv)o;
        return lhs.getLedgerId() == rhs.getLedgerId() && lhs.getEntryId() == rhs.getEntryId() && lhs.getPartitionIndex() == rhs.getPartitionIndex() && lhs.getBatchIndex() == rhs.getBatchIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean acknowledge(MessageIdAdv msgId, boolean individual) {
        if (!MessageIdAdvUtils.isBatch(msgId)) {
            return true;
        }
        BitSet ackSet = msgId.getAckSet();
        if (ackSet == null) {
            return false;
        }
        int batchIndex = msgId.getBatchIndex();
        BitSet bitSet = ackSet;
        synchronized (bitSet) {
            if (individual) {
                ackSet.clear(batchIndex);
            } else {
                ackSet.clear(0, batchIndex + 1);
            }
            return ackSet.isEmpty();
        }
    }

    static boolean isBatch(MessageIdAdv msgId) {
        return msgId.getBatchIndex() >= 0 && msgId.getBatchSize() > 0;
    }

    static MessageIdAdv discardBatch(MessageId messageId) {
        if (messageId instanceof ChunkMessageIdImpl) {
            return (MessageIdAdv)messageId;
        }
        MessageIdAdv msgId = (MessageIdAdv)messageId;
        return new MessageIdImpl(msgId.getLedgerId(), msgId.getEntryId(), msgId.getPartitionIndex());
    }

    static MessageIdAdv prevMessageId(MessageIdAdv msgId) {
        return new MessageIdImpl(msgId.getLedgerId(), msgId.getEntryId() - 1L, msgId.getPartitionIndex());
    }
}

