/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.functions.api.state;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.pulsar.functions.api.StateStore;
import org.apache.pulsar.functions.api.state.StateValue;

public interface ByteBufferStateStore
extends StateStore {
    public void put(String var1, ByteBuffer var2);

    public CompletableFuture<Void> putAsync(String var1, ByteBuffer var2);

    public void delete(String var1);

    public CompletableFuture<Void> deleteAsync(String var1);

    public ByteBuffer get(String var1);

    public CompletableFuture<ByteBuffer> getAsync(String var1);

    default public StateValue getStateValue(String key) {
        return this.getStateValueAsync(key).join();
    }

    default public CompletableFuture<StateValue> getStateValueAsync(String key) {
        return this.getAsync(key).thenApply(val -> {
            if (val != null && val.remaining() >= 0) {
                byte[] data = new byte[val.remaining()];
                val.get(data);
                return new StateValue(data, null, null);
            }
            return null;
        });
    }
}

