/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.broker.service.persistent;

import io.netty.buffer.ByteBuf;
import java.util.List;
import lombok.Generated;
import org.apache.bookkeeper.mledger.AsyncCallbacks;
import org.apache.bookkeeper.mledger.Entry;
import org.apache.bookkeeper.mledger.ManagedCursor;
import org.apache.pulsar.broker.PulsarServerException;
import org.apache.pulsar.broker.service.AbstractReplicator;
import org.apache.pulsar.broker.service.BrokerService;
import org.apache.pulsar.broker.service.persistent.PersistentReplicator;
import org.apache.pulsar.broker.service.persistent.PersistentTopic;
import org.apache.pulsar.client.api.Message;
import org.apache.pulsar.client.api.MessageId;
import org.apache.pulsar.client.impl.MessageIdImpl;
import org.apache.pulsar.client.impl.MessageImpl;
import org.apache.pulsar.client.impl.PulsarClientImpl;
import org.apache.pulsar.client.impl.SendCallback;
import org.apache.pulsar.common.util.Codec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShadowReplicator
extends PersistentReplicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ShadowReplicator.class);

    public ShadowReplicator(String shadowTopic, PersistentTopic sourceTopic, ManagedCursor cursor, BrokerService brokerService, PulsarClientImpl replicationClient) throws PulsarServerException {
        super(brokerService.pulsar().getConfiguration().getClusterName(), sourceTopic, cursor, brokerService.pulsar().getConfiguration().getClusterName(), shadowTopic, brokerService, replicationClient);
    }

    @Override
    protected String getProducerName() {
        return this.replicatorPrefix + "-" + this.localTopicName + "-->" + this.remoteTopicName;
    }

    @Override
    protected boolean replicateEntries(List<Entry> entries, PersistentReplicator.InFlightTask inFlightTask) {
        boolean atLeastOneMessageSentForReplication = false;
        try {
            boolean isLocalMessageSkippedOnce = false;
            boolean skipRemainingMessages = inFlightTask.isSkipReadResultDueToCursorRewind();
            for (int i = 0; i < entries.size(); ++i) {
                MessageImpl msg;
                Entry entry = entries.get(i);
                if (skipRemainingMessages) {
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    continue;
                }
                int length = entry.getLength();
                ByteBuf headersAndPayload = entry.getDataBuffer();
                try {
                    msg = MessageImpl.deserializeMetadataWithEmptyPayload((ByteBuf)headersAndPayload);
                }
                catch (Throwable t) {
                    log.error("[{}] Failed to deserialize message at {} (buffer size: {}): {}", new Object[]{this.replicatorId, entry.getPosition(), length, t.getMessage(), t});
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    continue;
                }
                if (msg.isExpired(this.messageTTLInSeconds)) {
                    this.msgExpired.recordEvent(0L);
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Discarding expired message at position {}, replicateTo {}", new Object[]{this.replicatorId, entry.getPosition(), msg.getReplicateTo()});
                    }
                    this.cursor.asyncDelete(entry.getPosition(), (AsyncCallbacks.DeleteCallback)this, (Object)entry.getPosition());
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                if (STATE_UPDATER.get(this) != AbstractReplicator.State.Started || isLocalMessageSkippedOnce) {
                    if (log.isDebugEnabled()) {
                        log.debug("[{}] Dropping read message at {} because producer is not ready", (Object)this.replicatorId, (Object)entry.getPosition());
                    }
                    isLocalMessageSkippedOnce = true;
                    inFlightTask.incCompletedEntries();
                    entry.release();
                    msg.recycle();
                    continue;
                }
                this.dispatchRateLimiter.ifPresent(rateLimiter -> rateLimiter.consumeDispatchQuota(1L, entry.getLength()));
                this.msgOut.recordEvent((long)msg.getDataBuffer().readableBytes());
                this.stats.incrementMsgOutCounter();
                this.stats.incrementBytesOutCounter((long)msg.getDataBuffer().readableBytes());
                msg.setReplicatedFrom(this.localCluster);
                msg.setMessageId((MessageId)new MessageIdImpl(entry.getLedgerId(), entry.getEntryId(), -1));
                msg.getMessageBuilder().addProperty().setKey("__MSG_PROP_REPL_SOURCE_POSITION").setValue(String.format("%s:%s", entry.getLedgerId(), entry.getEntryId()));
                headersAndPayload.retain();
                this.producer.sendAsync((Message)msg, (SendCallback)PersistentReplicator.ProducerSendCallback.create(this, entry, msg, inFlightTask));
                atLeastOneMessageSentForReplication = true;
            }
        }
        catch (Exception e) {
            log.error("[{}] Unexpected exception in replication task for shadow topic: {}", new Object[]{this.replicatorId, e.getMessage(), e});
        }
        return atLeastOneMessageSentForReplication;
    }

    public static String getShadowReplicatorName(String replicatorPrefix, String shadowTopic) {
        return replicatorPrefix + "-" + Codec.encode((String)shadowTopic);
    }
}

