/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.consumer;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.qpid.server.consumer.AbstractConsumerTarget;

public class ScheduledConsumerTargetSet<C extends AbstractConsumerTarget>
implements Set<C> {
    private final ConcurrentLinkedQueue<C> _underlying = new ConcurrentLinkedQueue();

    @Override
    public boolean add(C c) {
        if (((AbstractConsumerTarget)c).setScheduled()) {
            return this._underlying.add(c);
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this._underlying.isEmpty();
    }

    @Override
    public int size() {
        return this._underlying.size();
    }

    @Override
    public boolean contains(Object o) {
        return this._underlying.contains(o);
    }

    @Override
    public boolean remove(Object o) {
        ((AbstractConsumerTarget)o).clearScheduled();
        return this._underlying.remove(o);
    }

    @Override
    public boolean addAll(Collection<? extends C> c) {
        boolean result = false;
        for (AbstractConsumerTarget consumer : c) {
            result = this._underlying.add(consumer) || result;
        }
        return result;
    }

    @Override
    public Object[] toArray() {
        return this._underlying.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this._underlying.toArray(a);
    }

    @Override
    public Iterator<C> iterator() {
        return new ScheduledConsumerIterator();
    }

    @Override
    public void clear() {
        for (AbstractConsumerTarget consumer : this._underlying) {
            this.remove(consumer);
        }
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this._underlying.containsAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object consumer : c) {
            result = this._underlying.remove((AbstractConsumerTarget)consumer) || result;
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<C> iterator = this.iterator();
        while (iterator.hasNext()) {
            if (c.contains(iterator.next())) continue;
            iterator.remove();
            modified = true;
        }
        return modified;
    }

    public String toString() {
        return this._underlying.toString();
    }

    @Override
    public boolean equals(Object o) {
        return this._underlying.equals(o);
    }

    @Override
    public int hashCode() {
        return this._underlying.hashCode();
    }

    private class ScheduledConsumerIterator
    implements Iterator<C> {
        private final Iterator<C> _underlyingIterator;
        private C _current;

        public ScheduledConsumerIterator() {
            this._underlyingIterator = ScheduledConsumerTargetSet.this._underlying.iterator();
        }

        @Override
        public boolean hasNext() {
            return this._underlyingIterator.hasNext();
        }

        @Override
        public C next() {
            this._current = (AbstractConsumerTarget)this._underlyingIterator.next();
            return this._current;
        }

        @Override
        public void remove() {
            this._underlyingIterator.remove();
            ((AbstractConsumerTarget)this._current).clearScheduled();
        }
    }
}

