/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.util;

import java.lang.invoke.LambdaMetafactory;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IteratingCallback
implements Callback {
    private static final Logger LOG = LoggerFactory.getLogger(IteratingCallback.class);
    private final AutoLock _lock = new AutoLock();
    private final Consumer<Throwable> _onCompleted = this::onCompleted;
    private State _state;
    private Throwable _failure;
    private boolean _reprocess;
    private boolean _aborted;

    protected IteratingCallback() {
        this._state = State.IDLE;
    }

    protected IteratingCallback(boolean needReset) {
        this._state = needReset ? State.COMPLETE : State.IDLE;
    }

    protected abstract Action process() throws Throwable;

    protected void onSuccess() {
    }

    protected void onFailure(Throwable cause) {
    }

    protected void onCompleteSuccess() {
    }

    protected void onCompleteFailure(Throwable cause) {
    }

    protected void onAborted(Throwable cause) {
    }

    protected void onCompleted(Throwable causeOrNull) {
        if (causeOrNull == null) {
            this.onCompleteSuccess();
        } else {
            this.onCompleteFailure(causeOrNull);
        }
    }

    private void doOnSuccessProcessing() {
        ExceptionUtil.callAndThen(this::onSuccess, () -> this.processing(this.isProcessing()));
    }

    private void doCompleteSuccess() {
        this.onCompleted(null);
    }

    private void doOnCompleted(Throwable cause) {
        ExceptionUtil.call(cause, this._onCompleted);
    }

    private void doOnFailureOnCompleted(Throwable cause) {
        ExceptionUtil.callAndThen(cause, this::onFailure, this._onCompleted);
    }

    private void doOnAbortedOnFailure(Throwable cause) {
        ExceptionUtil.callAndThen(cause, this::onAborted, this::onFailure);
    }

    private void doOnAbortedOnFailureOnCompleted(Throwable cause) {
        ExceptionUtil.callAndThen(cause, this::doOnAbortedOnFailure, this._onCompleted);
    }

    private void doOnAbortedOnFailureIfNotPendingDoCompleted(Throwable cause) {
        ExceptionUtil.callAndThen(cause, this::doOnAbortedOnFailure, this::ifNotPendingDoCompleted);
    }

    private void ifNotPendingDoCompleted() {
        Throwable completeFailure = null;
        try (AutoLock ignored = this._lock.lock();){
            this._failure = this._failure.getCause();
            if (Objects.requireNonNull(this._state) != State.PENDING) {
                completeFailure = this._failure;
            }
        }
        if (completeFailure != null) {
            this.doOnCompleted(completeFailure);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void iterate() {
        process = false;
        ignored = this._lock.lock();
        try {
            switch (this._state.ordinal()) {
                case 0: {
                    this._state = State.PROCESSING;
                    process = true;
                    ** break;
lbl9:
                    // 1 sources

                    break;
                }
                case 1: 
                case 2: {
                    this._reprocess = true;
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                ** default:
lbl15:
                // 1 sources

                break;
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (process) {
            this.processing(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void processing(boolean processFirst) {
        completeSuccess = false;
        onAbortedOnFailureOnCompleted = null;
        onFailureOnCompleted = null;
        onAbortedOnFailureIfNotPendingDoCompleted = null;
        block35: while (true) lbl-1000:
        // 6 sources

        {
            action = null;
            if (processFirst) {
                try {
                    action = this.process();
                }
                catch (Throwable x) {
                    this.failed(x);
                }
            }
            callOnSuccess = false;
            try {
                ignored = this._lock.lock();
                try {
                    if (IteratingCallback.LOG.isDebugEnabled()) {
                        IteratingCallback.LOG.debug("processing {} {}", (Object)action, (Object)this);
                    }
                    switch (this._state.ordinal()) {
                        case 1: {
                            if (action == null) break block35;
                            switch (action.ordinal()) {
                                case 0: {
                                    if (this._aborted) {
                                        this._state = this._failure instanceof ClosedException != false ? State.CLOSED : State.COMPLETE;
                                        onAbortedOnFailureOnCompleted = this._failure;
                                    } else {
                                        if (this._reprocess) {
                                            this._reprocess = false;
                                            continue block35;
                                        }
                                        this._state = State.IDLE;
                                    }
                                    break block35;
                                }
                                case 1: {
                                    this._state = State.PENDING;
                                    this._reprocess = false;
                                    if (this._aborted) {
                                        onAbortedOnFailureIfNotPendingDoCompleted = this._failure;
                                        this._failure = new AbortingException(onAbortedOnFailureIfNotPendingDoCompleted);
                                    }
                                    break block35;
                                }
                                case 2: {
                                    this._reprocess = false;
                                    if (this._aborted) {
                                        this._state = this._failure instanceof ClosedException != false ? State.CLOSED : State.COMPLETE;
                                        onAbortedOnFailureOnCompleted = this._failure;
                                    } else {
                                        this._state = State.COMPLETE;
                                        completeSuccess = true;
                                    }
                                    break block35;
                                }
                                default: {
                                    throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                                }
                            }
                        }
                        case 2: {
                            if (action != Action.SCHEDULED && action != null) {
                                this._state = State.CLOSED;
                                this._failure = onAbortedOnFailureOnCompleted = ExceptionUtil.combine(this._failure, new IllegalStateException("Action not scheduled"));
                                break block35;
                            }
                            if (this._failure != null) {
                                if (this._aborted) {
                                    onAbortedOnFailureOnCompleted = this._failure;
                                } else {
                                    onFailureOnCompleted = this._failure;
                                }
                                this._state = this._failure instanceof ClosedException != false ? State.CLOSED : State.COMPLETE;
                                break block35;
                            }
                            callOnSuccess = true;
                            this._state = State.PROCESSING;
                            this._reprocess = false;
                            ** break;
                        }
                        default: {
                            throw new IllegalStateException(String.format("%s[action=%s]", new Object[]{this, action}));
                        }
                    }
                }
                finally {
                    if (ignored == null) continue;
                    ignored.close();
                    continue;
                }
            }
            finally {
                if (!callOnSuccess) continue;
                this.onSuccess();
                if (!this.isAborted()) continue;
                onAbortedOnFailureOnCompleted = this._failure;
                processFirst = false;
                continue;
            }
            break;
        }
        if (onAbortedOnFailureOnCompleted != null) {
            this.doOnAbortedOnFailureOnCompleted(onAbortedOnFailureOnCompleted);
        } else if (completeSuccess) {
            this.doCompleteSuccess();
        } else if (onFailureOnCompleted != null) {
            this.doOnFailureOnCompleted(onFailureOnCompleted);
        } else if (onAbortedOnFailureIfNotPendingDoCompleted != null) {
            this.doOnAbortedOnFailureIfNotPendingDoCompleted(onAbortedOnFailureIfNotPendingDoCompleted);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void succeeded() {
        onSuccessProcessing = false;
        onCompleted = null;
        ignored = this._lock.lock();
        try {
            if (IteratingCallback.LOG.isDebugEnabled()) {
                IteratingCallback.LOG.debug("succeeded {}", (Object)this);
            }
            switch (this._state.ordinal()) {
                case 1: {
                    this._state = State.PROCESSING_CALLED;
                    ** break;
lbl11:
                    // 1 sources

                    break;
                }
                case 3: {
                    if (this._aborted) {
                        if (this._failure instanceof AbortingException) {
                            this._state = this._failure.getCause() instanceof ClosedException != false ? State.CLOSED : State.COMPLETE;
                            ** break;
lbl17:
                            // 1 sources

                        } else {
                            this._state = this._failure instanceof ClosedException != false ? State.CLOSED : State.COMPLETE;
                            onCompleted = this._failure;
                            ** break;
                        }
lbl21:
                        // 1 sources

                    } else {
                        this._state = State.PROCESSING;
                        onSuccessProcessing = true;
                        ** break;
                    }
lbl25:
                    // 1 sources

                    break;
                }
                case 4: 
                case 5: {
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (onSuccessProcessing) {
            this.doOnSuccessProcessing();
        } else if (onCompleted != null) {
            this.doOnCompleted(onCompleted);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final void failed(Throwable cause) {
        cause = Objects.requireNonNullElseGet(cause, (Supplier<Throwable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/Throwable;)());
        onFailureOnCompleted = null;
        onCompleted = null;
        ignored = this._lock.lock();
        try {
            if (IteratingCallback.LOG.isDebugEnabled()) {
                IteratingCallback.LOG.atDebug().setCause(cause).log("failed {}", (Object)this);
            }
            switch (this._state.ordinal()) {
                case 1: 
                case 2: {
                    this._state = State.PROCESSING_CALLED;
                    this._failure = ExceptionUtil.combine(this._failure, cause);
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 3: {
                    if (this._aborted) {
                        if (this._failure instanceof AbortingException) {
                            ExceptionUtil.addSuppressedIfNotAssociated(this._failure.getCause(), cause);
                            this._state = this._failure.getCause() instanceof ClosedException != false ? State.CLOSED : State.COMPLETE;
                            ** break;
lbl20:
                            // 1 sources

                        } else {
                            ExceptionUtil.addSuppressedIfNotAssociated(this._failure, cause);
                            this._state = this._failure instanceof ClosedException != false ? State.CLOSED : State.COMPLETE;
                            onCompleted = this._failure;
                            ** break;
                        }
lbl25:
                        // 1 sources

                    } else {
                        this._state = State.COMPLETE;
                        onFailureOnCompleted = this._failure = cause;
                        ** break;
                    }
lbl29:
                    // 1 sources

                    break;
                }
                case 4: 
                case 5: {
                    ExceptionUtil.addSuppressedIfNotAssociated(this._failure, cause);
                    return;
                }
                default: {
                    throw new IllegalStateException(this.toString());
                }
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (onFailureOnCompleted != null) {
            this.doOnFailureOnCompleted(onFailureOnCompleted);
        } else if (onCompleted != null) {
            this.doOnCompleted(onCompleted);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final void close() {
        onAbortedOnFailureIfNotPendingDoCompleted = null;
        onAbortedOnFailureOnCompleted = null;
        ignored = this._lock.lock();
        try {
            if (IteratingCallback.LOG.isDebugEnabled()) {
                IteratingCallback.LOG.debug("close {}", (Object)this);
            }
            switch (this._state.ordinal()) {
                case 0: {
                    this._state = State.CLOSED;
                    onAbortedOnFailureOnCompleted = this._failure = new ClosedException();
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 1: 
                case 2: {
                    if (this._aborted) {
                        ExceptionUtil.addSuppressedIfNotAssociated(this._failure, new ClosedException());
                        ** break;
lbl17:
                        // 1 sources

                    } else {
                        this._aborted = true;
                        this._failure = new ClosedException();
                        ** break;
                    }
lbl21:
                    // 1 sources

                    break;
                }
                case 3: {
                    onAbortedOnFailureIfNotPendingDoCompleted = new ClosedException();
                    this._failure = new AbortingException(onAbortedOnFailureIfNotPendingDoCompleted);
                    this._aborted = true;
                    ** break;
lbl27:
                    // 1 sources

                    break;
                }
                case 4: {
                    this._state = State.CLOSED;
                    ** break;
lbl31:
                    // 1 sources

                    break;
                }
                case 5: {
                    return;
                }
                ** default:
lbl35:
                // 1 sources

                break;
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (onAbortedOnFailureIfNotPendingDoCompleted != null) {
            this.doOnAbortedOnFailureIfNotPendingDoCompleted(onAbortedOnFailureIfNotPendingDoCompleted);
        } else if (onAbortedOnFailureOnCompleted != null) {
            this.doOnAbortedOnFailureOnCompleted(onAbortedOnFailureOnCompleted);
        }
    }

    /*
     * Unable to fully structure code
     */
    public final boolean abort(Throwable cause) {
        cause = Objects.requireNonNullElseGet(cause, (Supplier<Throwable>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Ljava/lang/Throwable;)());
        onAbort = false;
        onAbortedOnFailureOnCompleted = false;
        ignored = this._lock.lock();
        try {
            if (IteratingCallback.LOG.isDebugEnabled()) {
                IteratingCallback.LOG.atDebug().setCause(cause).log("abort {}", (Object)this);
            }
            if (this._aborted) {
                ExceptionUtil.addSuppressedIfNotAssociated(this._failure, cause);
                var5_5 = false;
                return var5_5;
            }
            switch (this._state.ordinal()) {
                case 0: {
                    this._state = State.COMPLETE;
                    this._failure = cause;
                    this._aborted = true;
                    onAbortedOnFailureOnCompleted = true;
                    ** break;
lbl19:
                    // 1 sources

                    break;
                }
                case 1: {
                    this._failure = cause;
                    this._aborted = true;
                    ** break;
lbl24:
                    // 1 sources

                    break;
                }
                case 2: {
                    this._failure = ExceptionUtil.combine(this._failure, cause);
                    this._aborted = true;
                    ** break;
lbl29:
                    // 1 sources

                    break;
                }
                case 3: {
                    onAbort = true;
                    this._failure = new AbortingException(cause);
                    this._aborted = true;
                    ** break;
lbl35:
                    // 1 sources

                    break;
                }
                case 4: 
                case 5: {
                    ExceptionUtil.addSuppressedIfNotAssociated(this._failure, cause);
                    var5_6 = false;
                    return var5_6;
                }
                ** default:
lbl41:
                // 1 sources

                break;
            }
        }
        finally {
            if (ignored != null) {
                ignored.close();
            }
        }
        if (onAbortedOnFailureOnCompleted) {
            this.doOnAbortedOnFailureOnCompleted(cause);
        } else if (onAbort) {
            this.doOnAbortedOnFailureIfNotPendingDoCompleted(cause);
        }
        return true;
    }

    boolean isPending() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._state == State.PENDING;
            return bl;
        }
    }

    boolean isIdle() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._state == State.IDLE;
            return bl;
        }
    }

    public boolean isClosed() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._state == State.CLOSED || this._failure instanceof ClosedException;
            return bl;
        }
    }

    public boolean isFailed() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._failure != null;
            return bl;
        }
    }

    public boolean isSucceeded() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._state == State.COMPLETE && this._failure == null && !this._aborted;
            return bl;
        }
    }

    private boolean isProcessing() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._state == State.PROCESSING && this._failure == null && !this._aborted;
            return bl;
        }
    }

    public boolean isAborted() {
        try (AutoLock ignored = this._lock.lock();){
            boolean bl = this._aborted;
            return bl;
        }
    }

    public boolean reset() {
        try (AutoLock ignored = this._lock.lock();){
            switch (this._state.ordinal()) {
                case 0: {
                    boolean bl = true;
                    return bl;
                }
                case 4: {
                    this._state = State.IDLE;
                    this._failure = null;
                    this._reprocess = false;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    public String toString() {
        try (AutoLock ignored = this._lock.tryLock();){
            String held = this._lock.isHeldByCurrentThread() ? "" : "?";
            String string = String.format("%s@%x[%s:%s,aborted=%b,failure=%s]", new Object[]{TypeUtil.toShortName(this.getClass()), this.hashCode(), held, this._state, this._aborted, this._failure});
            return string;
        }
    }

    static enum State {
        IDLE,
        PROCESSING,
        PROCESSING_CALLED,
        PENDING,
        COMPLETE,
        CLOSED;

    }

    protected static enum Action {
        IDLE,
        SCHEDULED,
        SUCCEEDED;

    }

    private static class ClosedException
    extends Exception {
        ClosedException() {
            super("Closed");
        }
    }

    private static class AbortingException
    extends Exception {
        AbortingException(Throwable cause) {
            super(cause.getMessage(), cause);
        }
    }
}

