/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import java.util.UUID;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionURL;
import org.apache.qpid.client.AbstractConnectionFactory;
import org.apache.qpid.client.XAConnectionImpl;
import org.apache.qpid.client.util.JMSExceptionHelper;
import org.apache.qpid.configuration.ClientProperties;
import org.apache.qpid.jms.ConnectionURL;
import org.apache.qpid.jndi.ObjectFactory;
import org.apache.qpid.url.URLSyntaxException;

public class AMQConnectionFactory
extends AbstractConnectionFactory
implements ConnectionFactory,
QueueConnectionFactory,
TopicConnectionFactory,
javax.naming.spi.ObjectFactory,
Referenceable,
XATopicConnectionFactory,
XAQueueConnectionFactory,
XAConnectionFactory,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String NO_URL_CONFIGURED = "The connection factory wasn't created with a proper URL, the connection details are empty";
    private static final ObjectFactory OBJECT_FACTORY;
    private ConnectionURL _connectionDetails;

    public AMQConnectionFactory() {
    }

    public AMQConnectionFactory(String url) throws URLSyntaxException {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this._connectionDetails = new AMQConnectionURL(url);
    }

    public AMQConnectionFactory(ConnectionURL url) {
        if (url == null) {
            throw new IllegalArgumentException("url cannot be null");
        }
        this._connectionDetails = url;
    }

    public final String getVirtualPath() {
        return this._connectionDetails.getVirtualHost();
    }

    public static String getUniqueClientID() {
        try {
            InetAddress addr = InetAddress.getLocalHost();
            return addr.getHostName() + System.currentTimeMillis();
        }
        catch (UnknownHostException e) {
            return "UnknownHost" + UUID.randomUUID();
        }
    }

    public AMQConnection createConnection() throws JMSException {
        if (this._connectionDetails == null) {
            throw new JMSException(NO_URL_CONFIGURED);
        }
        try {
            if (this._connectionDetails.getClientName() == null || this._connectionDetails.getClientName().equals("")) {
                this._connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
            }
            return this.newAMQConnectionInstance(this._connectionDetails);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating connection: " + e.getMessage()), e);
        }
    }

    public AMQConnection createConnection(String userName, String password) throws JMSException {
        return this.createConnection(userName, password, null);
    }

    public AMQConnection createConnection(String userName, String password, String id) throws JMSException {
        if (this._connectionDetails != null) {
            try {
                AMQConnectionURL connectionDetails = new AMQConnectionURL(this._connectionDetails.getURL());
                connectionDetails.setUsername(userName);
                connectionDetails.setPassword(password);
                if (id != null && !id.equals("")) {
                    connectionDetails.setClientName(id);
                } else if (connectionDetails.getClientName() == null || connectionDetails.getClientName().equals("")) {
                    connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
                }
                return this.newAMQConnectionInstance(connectionDetails);
            }
            catch (Exception e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating connection: " + e.getMessage()), e);
            }
        }
        throw new JMSException(NO_URL_CONFIGURED);
    }

    public QueueConnection createQueueConnection() throws JMSException {
        return this.createConnection();
    }

    public QueueConnection createQueueConnection(String username, String password) throws JMSException {
        return this.createConnection(username, password);
    }

    public TopicConnection createTopicConnection() throws JMSException {
        return this.createConnection();
    }

    public TopicConnection createTopicConnection(String username, String password) throws JMSException {
        return this.createConnection(username, password);
    }

    public ConnectionURL getConnectionURL() {
        return this._connectionDetails;
    }

    public String getConnectionURLString() {
        return this._connectionDetails.toString();
    }

    public final void setConnectionURLString(String url) throws URLSyntaxException {
        this._connectionDetails = new AMQConnectionURL(url);
    }

    @Deprecated
    public Object getObjectInstance(Object obj, Name name, Context ctx, Hashtable env) throws Exception {
        return OBJECT_FACTORY.getObjectInstance(obj, name, ctx, env);
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(AMQConnectionFactory.class.getName(), new StringRefAddr("connectionURL", this._connectionDetails.getURL()), ObjectFactory.class.getName(), null);
    }

    public XAConnection createXAConnection() throws JMSException {
        try {
            return new XAConnectionImpl(this._connectionDetails);
        }
        catch (Exception e) {
            throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating connection: " + e.getMessage()), e);
        }
    }

    public XAConnection createXAConnection(String username, String password) throws JMSException {
        if (this._connectionDetails != null) {
            try {
                AMQConnectionURL connectionDetails = new AMQConnectionURL(this._connectionDetails.toString());
                connectionDetails.setUsername(username);
                connectionDetails.setPassword(password);
                if (connectionDetails.getClientName() == null || connectionDetails.getClientName().equals("")) {
                    connectionDetails.setClientName(AMQConnectionFactory.getUniqueClientID());
                }
                return new XAConnectionImpl(connectionDetails);
            }
            catch (Exception e) {
                throw JMSExceptionHelper.chainJMSException(new JMSException("Error creating XA Connection: " + e.getMessage()), e);
            }
        }
        throw new JMSException(NO_URL_CONFIGURED);
    }

    public XATopicConnection createXATopicConnection() throws JMSException {
        return (XATopicConnection)this.createXAConnection();
    }

    public XATopicConnection createXATopicConnection(String username, String password) throws JMSException {
        return (XATopicConnection)this.createXAConnection(username, password);
    }

    public XAQueueConnection createXAQueueConnection() throws JMSException {
        return (XAQueueConnection)this.createXAConnection();
    }

    public XAQueueConnection createXAQueueConnection(String username, String password) throws JMSException {
        return (XAQueueConnection)this.createXAConnection(username, password);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AMQConnectionFactory that = (AMQConnectionFactory)o;
        return !(this._connectionDetails != null ? !this._connectionDetails.equals(that._connectionDetails) : that._connectionDetails != null);
    }

    public int hashCode() {
        return this._connectionDetails != null ? this._connectionDetails.hashCode() : 0;
    }

    public String toString() {
        return "AMQConnectionFactory{_connectionDetails=" + this._connectionDetails + '}';
    }

    static {
        ClientProperties.ensureIsLoaded();
        OBJECT_FACTORY = new ObjectFactory();
    }
}

