/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing;

import java.nio.ByteBuffer;
import org.apache.qpid.QpidException;
import org.apache.qpid.framing.AMQFrame;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.EncodingUtils;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.protocol.AMQVersionAwareProtocolSession;
import org.apache.qpid.transport.ByteBufferSender;
import org.apache.qpid.util.ByteBufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQMethodBodyImpl
implements AMQMethodBody {
    private static final Logger LOGGER = LoggerFactory.getLogger(AMQMethodBodyImpl.class);
    public static final byte TYPE = 1;

    @Override
    public byte getFrameType() {
        return 1;
    }

    protected abstract int getBodySize();

    @Override
    public AMQFrame generateFrame(int channelId) {
        return new AMQFrame(channelId, this);
    }

    @Override
    public void handle(int channelId, AMQVersionAwareProtocolSession session) throws QpidException {
        session.methodFrameReceived(channelId, this);
    }

    @Override
    public int getSize() {
        return 4 + this.getBodySize();
    }

    @Override
    public long writePayload(ByteBufferSender sender) {
        int size = this.getSize();
        ByteBuffer buf = ByteBuffer.allocate(size);
        ByteBufferUtils.putUnsignedShort(buf, this.getClazz());
        ByteBufferUtils.putUnsignedShort(buf, this.getMethod());
        this.writeMethodPayload(buf);
        buf.flip();
        sender.send(buf);
        return size;
    }

    protected abstract void writeMethodPayload(ByteBuffer var1);

    protected int getSizeOf(AMQShortString string) {
        return EncodingUtils.encodedShortStringLength(string);
    }

    protected void writeByte(ByteBuffer buffer, byte b) {
        buffer.put(b);
    }

    protected void writeAMQShortString(ByteBuffer buffer, AMQShortString string) {
        EncodingUtils.writeShortStringBytes(buffer, string);
    }

    protected void writeInt(ByteBuffer buffer, int i) {
        buffer.putInt(i);
    }

    protected int getSizeOf(FieldTable table) {
        return EncodingUtils.encodedFieldTableLength(table);
    }

    protected void writeFieldTable(ByteBuffer buffer, FieldTable table) {
        EncodingUtils.writeFieldTableBytes(buffer, table);
    }

    protected void writeLong(ByteBuffer buffer, long l) {
        buffer.putLong(l);
    }

    protected int getSizeOf(byte[] response) {
        return response == null ? 4 : response.length + 4;
    }

    protected void writeBytes(ByteBuffer buffer, byte[] data) {
        EncodingUtils.writeBytes(buffer, data);
    }

    protected void writeShort(ByteBuffer buffer, short s) {
        buffer.putShort(s);
    }

    protected void writeBitfield(ByteBuffer buffer, byte bitfield0) {
        buffer.put(bitfield0);
    }

    protected void writeUnsignedShort(ByteBuffer buffer, int s) {
        ByteBufferUtils.putUnsignedShort(buffer, s);
    }

    protected void writeUnsignedInteger(ByteBuffer buffer, long i) {
        ByteBufferUtils.putUnsignedInt(buffer, i);
    }

    protected void writeUnsignedByte(ByteBuffer buffer, short unsignedByte) {
        ByteBufferUtils.putUnsignedByte(buffer, unsignedByte);
    }
}

