/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.ElementType;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.validation.ConstraintDeclarationException;
import javax.validation.ElementKind;
import javax.validation.Valid;
import javax.validation.executable.ValidateOnExecution;
import org.apache.bval.jsr.metadata.HierarchyBuilder;
import org.apache.bval.jsr.metadata.Meta;
import org.apache.bval.util.Exceptions;
import org.apache.bval.util.Validate;

class Liskov {
    static void validateContainerHierarchy(Collection<? extends HierarchyBuilder.ContainerDelegate<?>> delegates, ElementKind elementKind) {
        if (Validate.notNull(delegates, "delegates", new Object[0]).isEmpty()) {
            return;
        }
        if (Validate.notNull(elementKind, "elementKind", new Object[0]) == ElementKind.CONTAINER_ELEMENT) {
            elementKind = Liskov.getContainer(delegates.iterator().next().getHierarchyElement());
        }
        switch (elementKind) {
            case RETURN_VALUE: {
                Liskov.noRedeclarationOfReturnValueCascading(delegates);
                Map<Meta<?>, Set<ValidationElement>> detectedValidationElements = Liskov.detectValidationElements(delegates, HierarchyBuilder.HierarchyDelegate::getHierarchyElement, Liskov.detectGroupConversion());
                Stream.of(StrengtheningIssue.values()).filter(si -> si != StrengtheningIssue.overriddenHierarchy || detectedValidationElements.values().stream().filter(s -> !s.isEmpty()).count() >= 2L).forEach(si -> si.check(detectedValidationElements));
                break;
            }
            case PARAMETER: {
                Liskov.noStrengtheningOfPreconditions(delegates, Liskov.detectConstraints(), Liskov.detectCascading(), Liskov.detectGroupConversion());
                break;
            }
        }
    }

    static void validateCrossParameterHierarchy(Collection<? extends HierarchyBuilder.ElementDelegate<?, ?>> delegates) {
        if (Validate.notNull(delegates, "delegates", new Object[0]).isEmpty()) {
            return;
        }
        Liskov.noStrengtheningOfPreconditions(delegates, Liskov.detectConstraints());
    }

    static void validateValidateOnExecution(Collection<? extends HierarchyBuilder.HierarchyDelegate<?, ?>> delegates) {
        Liskov.noStrengtheningOfPreconditions(delegates, Liskov.detectValidateOnExecution());
    }

    private static ElementKind getContainer(Meta<?> meta) {
        Meta<?> m = meta;
        while (m.getElementType() == ElementType.TYPE_USE) {
            m = m.getParent();
        }
        switch (m.getElementType()) {
            case METHOD: {
                return ElementKind.RETURN_VALUE;
            }
            case PARAMETER: {
                return ElementKind.PARAMETER;
            }
        }
        return ElementKind.PROPERTY;
    }

    private static void noRedeclarationOfReturnValueCascading(Collection<? extends HierarchyBuilder.ContainerDelegate<?>> delegates) {
        Map cascadedReturnValues = delegates.stream().filter(HierarchyBuilder.ContainerDelegate::isCascade).map(HierarchyBuilder.HierarchyDelegate::getHierarchyElement).collect(Collectors.toMap(Meta::getDeclaringClass, Function.identity()));
        boolean anyRelated = cascadedReturnValues.keySet().stream().anyMatch(t -> cascadedReturnValues.keySet().stream().filter(Predicate.isEqual(t).negate()).anyMatch(t2 -> Liskov.related(t, t2)));
        Exceptions.raiseIf(anyRelated, ConstraintDeclarationException::new, "Multiple method return values marked @%s in hierarchy %s", f -> f.args(Valid.class.getSimpleName(), cascadedReturnValues.values()));
    }

    @SafeVarargs
    private static <D extends HierarchyBuilder.HierarchyDelegate<?, ?>> void noStrengtheningOfPreconditions(Collection<? extends D> delegates, Function<? super D, ValidationElement> ... detectors) {
        Map<Meta<?>, Set<ValidationElement>> detectedValidationElements = Liskov.detectValidationElements(delegates, HierarchyBuilder.HierarchyDelegate::getHierarchyElement, detectors);
        if (detectedValidationElements.isEmpty()) {
            return;
        }
        for (StrengtheningIssue s : StrengtheningIssue.values()) {
            s.check(detectedValidationElements);
        }
    }

    @SafeVarargs
    private static <T> Map<Meta<?>, Set<ValidationElement>> detectValidationElements(Collection<? extends T> delegates, Function<? super T, Meta<?>> toMeta, Function<? super T, ValidationElement> ... detectors) {
        LinkedHashMap detectedValidationElements = new LinkedHashMap();
        delegates.forEach(d -> detectedValidationElements.put((Meta<?>)toMeta.apply(d), Stream.of(detectors).map(dt -> (ValidationElement)((Object)((Object)((Object)dt.apply(d))))).filter(Objects::nonNull).collect(Collectors.toCollection(() -> EnumSet.noneOf(ValidationElement.class)))));
        if (detectedValidationElements.values().stream().allMatch(Collection::isEmpty)) {
            return Collections.emptyMap();
        }
        return detectedValidationElements;
    }

    private static boolean related(Class<?> c1, Class<?> c2) {
        return c1.isAssignableFrom(c2) || c2.isAssignableFrom(c1);
    }

    private static Function<HierarchyBuilder.ElementDelegate<?, ?>, ValidationElement> detectConstraints() {
        return d -> d.getDeclaredConstraints().length > 0 ? ValidationElement.constraints : null;
    }

    private static Function<HierarchyBuilder.ContainerDelegate<?>, ValidationElement> detectCascading() {
        return d -> d.isCascade() ? ValidationElement.cascades : null;
    }

    private static Function<HierarchyBuilder.ContainerDelegate<?>, ValidationElement> detectGroupConversion() {
        return d -> d.getGroupConversions().isEmpty() ? null : ValidationElement.groupConversions;
    }

    private static Function<HierarchyBuilder.HierarchyDelegate<?, ?>, ValidationElement> detectValidateOnExecution() {
        return d -> d.getHierarchyElement().getHost().isAnnotationPresent(ValidateOnExecution.class) ? ValidationElement.validateOnExecution : null;
    }

    private Liskov() {
    }

    private static enum StrengtheningIssue implements Predicate<Map<Meta<?>, Set<ValidationElement>>>
    {
        overriddenHierarchy("overridden %s in inheritance hierarchy: %s"){

            @Override
            public boolean test(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
                boolean lowestFound = false;
                for (Set<ValidationElement> validated : detectedValidationElements.values()) {
                    if (lowestFound) {
                        return false;
                    }
                    lowestFound = !validated.isEmpty();
                }
                return true;
            }
        }
        ,
        unrelatedInheritance("declared %s in unrelated inheritance hierarchies: %s"){

            @Override
            public boolean test(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
                Set interfaces = detectedValidationElements.keySet().stream().map(Meta::getDeclaringClass).filter(Class::isInterface).collect(Collectors.toSet());
                if (interfaces.isEmpty()) {
                    return true;
                }
                boolean allRelated = detectedValidationElements.keySet().stream().map(Meta::getDeclaringClass).allMatch(ifc -> interfaces.stream().filter(Predicate.isEqual(ifc).negate()).allMatch(ifc2 -> Liskov.related(ifc, ifc2)));
                return allRelated;
            }
        };

        final String format;

        private StrengtheningIssue(String format) {
            this.format = "Illegal strengthening: " + format;
        }

        Supplier<String> messageFor(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
            return () -> {
                Set validationElements = detectedValidationElements.values().stream().flatMap(Collection::stream).collect(Collectors.toCollection(() -> EnumSet.noneOf(ValidationElement.class)));
                String describeHierarchy = detectedValidationElements.keySet().stream().map(Meta::describeHost).collect(Collectors.joining(", ", "[", "]"));
                return String.format(this.format, validationElements, describeHierarchy);
            };
        }

        void check(Map<Meta<?>, Set<ValidationElement>> detectedValidationElements) {
            Exceptions.raiseUnless(this.test(detectedValidationElements), ConstraintDeclarationException::new, this.messageFor(detectedValidationElements));
        }
    }

    private static enum ValidationElement {
        constraints,
        cascades,
        groupConversions,
        validateOnExecution;

    }
}

