/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.common;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.ranger.common.RangerVersionAnnotation;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class RangerVersionInfo {
    private static Package myPackage = RangerVersionAnnotation.class.getPackage();
    private static RangerVersionAnnotation version = myPackage.getAnnotation(RangerVersionAnnotation.class);

    static Package getPackage() {
        return myPackage;
    }

    public static String getVersion() {
        return version != null ? version.version() : "Unknown";
    }

    public static String getShortVersion() {
        return version != null ? version.shortVersion() : "Unknown";
    }

    public static String getRevision() {
        return version != null ? version.revision() : "Unknown";
    }

    public static String getBranch() {
        return version != null ? version.branch() : "Unknown";
    }

    public static String getDate() {
        return version != null ? version.date() : "Unknown";
    }

    public static String getUser() {
        return version != null ? version.user() : "Unknown";
    }

    public static String getUrl() {
        return version != null ? version.url() : "Unknown";
    }

    public static String getSrcChecksum() {
        return version != null ? version.srcChecksum() : "Unknown";
    }

    public static String getBuildVersion() {
        return RangerVersionInfo.getVersion() + " from " + RangerVersionInfo.getRevision() + " by " + RangerVersionInfo.getUser() + " source checksum " + RangerVersionInfo.getSrcChecksum();
    }

    public static void main(String[] args) {
        System.out.println("");
        System.out.println("Ranger " + RangerVersionInfo.getVersion());
        System.out.println("Subversion " + RangerVersionInfo.getUrl() + " -r " + RangerVersionInfo.getRevision());
        System.out.println("Compiled by " + RangerVersionInfo.getUser() + " on " + RangerVersionInfo.getDate());
        System.out.println("From source with checksum " + RangerVersionInfo.getSrcChecksum());
    }
}

