/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metamodel;

import java.lang.reflect.Field;
import javax.persistence.metamodel.Bindable;
import javax.persistence.metamodel.SingularAttribute;
import javax.persistence.metamodel.Type;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.jpa.metamodel.AttributeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.ManagedTypeImpl;
import org.eclipse.persistence.internal.jpa.metamodel.MetamodelImpl;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.mappings.AggregateMapping;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.VariableOneToOneMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.mappings.structures.ReferenceMapping;

public class SingularAttributeImpl<X, T>
extends AttributeImpl<X, T>
implements SingularAttribute<X, T> {
    private static final long serialVersionUID = 3928292425281232234L;
    private Type<T> elementType;

    protected SingularAttributeImpl(ManagedTypeImpl<X> managedType, DatabaseMapping mapping) {
        this(managedType, mapping, false);
    }

    protected SingularAttributeImpl(ManagedTypeImpl<X> managedType, DatabaseMapping mapping, boolean validationEnabled) {
        super(managedType, mapping);
        Class attributeClass = mapping.getAttributeClassification();
        if (attributeClass == null) {
            if (mapping instanceof ForeignReferenceMapping) {
                attributeClass = ((ForeignReferenceMapping)mapping).getReferenceClass();
            } else if (mapping.isAbstractDirectMapping()) {
                attributeClass = mapping.getField().getType();
                if (attributeClass == null) {
                    attributeClass = managedType.getTypeClassFromAttributeOrMethodLevelAccessor(mapping);
                }
            } else if (mapping.isAggregateObjectMapping()) {
                attributeClass = ((AggregateMapping)mapping).getReferenceClass();
            } else if (mapping.isVariableOneToOneMapping()) {
                if (validationEnabled) {
                    AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_mapping_type_is_unsupported", (Object)mapping, (Object)this);
                }
                attributeClass = ((VariableOneToOneMapping)mapping).getReferenceClass();
            } else if (mapping.isEISMapping() || mapping.isTransformationMapping()) {
                if (validationEnabled) {
                    AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_mapping_type_is_unsupported", (Object)mapping, (Object)this);
                }
            } else if (mapping.isReferenceMapping()) {
                if (validationEnabled) {
                    AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_mapping_type_is_unsupported", (Object)mapping, (Object)this);
                }
                attributeClass = ((ReferenceMapping)mapping).getReferenceClass();
            }
        }
        if (attributeClass == null && validationEnabled) {
            attributeClass = MetamodelImpl.DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS;
            AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_attribute_class_type_is_null", (Object)this);
        }
        this.elementType = this.getMetamodel().getType(attributeClass);
    }

    @Override
    public Class<T> getBindableJavaType() {
        return this.elementType.getJavaType();
    }

    @Override
    public boolean isId() {
        if (this.getManagedTypeImpl().isMappedSuperclass()) {
            return this.getDescriptor().getPrimaryKeyFields().contains(this.getMapping().getField());
        }
        return this.getMapping().isPrimaryKeyMapping() || this.getMapping().isJPAId();
    }

    @Override
    public boolean isOptional() {
        return this.getMapping().isOptional();
    }

    @Override
    public boolean isPlural() {
        return false;
    }

    @Override
    public boolean isVersion() {
        if (this.getDescriptor().usesOptimisticLocking() && this.getMapping().isDirectToFieldMapping()) {
            OptimisticLockingPolicy policy = this.getDescriptor().getOptimisticLockingPolicy();
            return policy.getWriteLockField().equals(((AbstractDirectMapping)this.getMapping()).getField());
        }
        return false;
    }

    @Override
    public Bindable.BindableType getBindableType() {
        return Bindable.BindableType.SINGULAR_ATTRIBUTE;
    }

    @Override
    public Class<T> getJavaType() {
        if (this.elementType == null) {
            Class<?> aJavaType;
            block4: {
                aJavaType = this.getMapping().getAttributeClassification();
                if (aJavaType == null && (aJavaType = this.getMapping().getField().getType()) == null) {
                    Class containingClass = this.getMapping().getDescriptor().getJavaClass();
                    Field aField = null;
                    try {
                        aField = containingClass.getDeclaredField(this.getMapping().getAttributeName());
                        aJavaType = aField.getType();
                        return aJavaType;
                    }
                    catch (NoSuchFieldException nsfe) {
                        if (aJavaType != null) break block4;
                        AbstractSessionLog.getLog().log(1, "metamodel", "metamodel_attribute_class_type_is_null", (Object)this);
                        return MetamodelImpl.DEFAULT_ELEMENT_TYPE_FOR_UNSUPPORTED_MAPPINGS;
                    }
                }
            }
            return aJavaType;
        }
        return this.elementType.getJavaType();
    }

    @Override
    public Type<T> getType() {
        return this.elementType;
    }

    public String toString() {
        StringBuffer aBuffer = new StringBuffer("SingularAttributeImpl[");
        aBuffer.append(this.getType());
        aBuffer.append(",");
        aBuffer.append(this.getMapping());
        aBuffer.append("]");
        return aBuffer.toString();
    }
}

