/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerPass;
import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.IR;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class ObjectPropertyStringPostprocess
implements CompilerPass {
    private final AbstractCompiler compiler;

    public ObjectPropertyStringPostprocess(AbstractCompiler compiler) {
        this.compiler = compiler;
    }

    @Override
    public void process(Node externs, Node root) {
        NodeTraversal.traverse(this.compiler, root, new Callback());
    }

    private class Callback
    extends NodeTraversal.AbstractPostOrderCallback {
        private Callback() {
        }

        @Override
        public void visit(NodeTraversal t, Node n, Node parent) {
            if (!n.isNew()) {
                return;
            }
            Node objectName = n.getFirstChild();
            if (!objectName.matchesQualifiedName("JSCompiler_ObjectPropertyString")) {
                return;
            }
            Node firstArgument = objectName.getNext();
            Node secondArgument = firstArgument.getNext();
            Token secondArgumentType = secondArgument.getToken();
            if (secondArgumentType == Token.GETPROP) {
                Node newChild = secondArgument.getFirstChild();
                secondArgument.removeChild(newChild);
                n.replaceChild(firstArgument, newChild);
                n.replaceChild(secondArgument, IR.string(secondArgument.getFirstChild().getString()));
            } else if (secondArgumentType == Token.GETELEM) {
                Node newFirstArgument = secondArgument.getFirstChild();
                secondArgument.removeChild(newFirstArgument);
                Node newSecondArgument = secondArgument.getLastChild();
                secondArgument.removeChild(newSecondArgument);
                n.replaceChild(firstArgument, newFirstArgument);
                n.replaceChild(secondArgument, newSecondArgument);
            } else {
                n.replaceChild(secondArgument, IR.string(secondArgument.getString()));
            }
            t.reportCodeChange();
        }
    }
}

