/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public final class MCAddWanBatchPublisherConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 2102528;
    public static final int RESPONSE_MESSAGE_TYPE = 2102529;
    private static final int REQUEST_QUEUE_CAPACITY_FIELD_OFFSET = 16;
    private static final int REQUEST_BATCH_SIZE_FIELD_OFFSET = 20;
    private static final int REQUEST_BATCH_MAX_DELAY_MILLIS_FIELD_OFFSET = 24;
    private static final int REQUEST_RESPONSE_TIMEOUT_MILLIS_FIELD_OFFSET = 28;
    private static final int REQUEST_ACK_TYPE_FIELD_OFFSET = 32;
    private static final int REQUEST_QUEUE_FULL_BEHAVIOR_FIELD_OFFSET = 36;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 40;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 13;

    private MCAddWanBatchPublisherConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, String targetCluster, @Nullable String publisherId, String endpoints, int queueCapacity, int batchSize, int batchMaxDelayMillis, int responseTimeoutMillis, int ackType, int queueFullBehavior) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("MC.AddWanBatchPublisherConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[40], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2102528);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, queueCapacity);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, batchSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, batchMaxDelayMillis);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, responseTimeoutMillis);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 32, ackType);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 36, queueFullBehavior);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        StringCodec.encode(clientMessage, targetCluster);
        CodecUtil.encodeNullable(clientMessage, publisherId, StringCodec::encode);
        StringCodec.encode(clientMessage, endpoints);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.queueCapacity = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.batchMaxDelayMillis = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.responseTimeoutMillis = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.ackType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 32);
        request.queueFullBehavior = FixedSizeTypesCodec.decodeInt(initialFrame.content, 36);
        request.name = StringCodec.decode(iterator2);
        request.targetCluster = StringCodec.decode(iterator2);
        request.publisherId = CodecUtil.decodeNullable(iterator2, StringCodec::decode);
        request.endpoints = StringCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse(Collection<String> addedPublisherIds, Collection<String> ignoredPublisherIds) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[13], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2102529);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, addedPublisherIds, StringCodec::encode);
        ListMultiFrameCodec.encode(clientMessage, ignoredPublisherIds, StringCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator2.next();
        response.addedPublisherIds = ListMultiFrameCodec.decode(iterator2, StringCodec::decode);
        response.ignoredPublisherIds = ListMultiFrameCodec.decode(iterator2, StringCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public List<String> addedPublisherIds;
        public List<String> ignoredPublisherIds;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public String targetCluster;
        @Nullable
        public String publisherId;
        public String endpoints;
        public int queueCapacity;
        public int batchSize;
        public int batchMaxDelayMillis;
        public int responseTimeoutMillis;
        public int ackType;
        public int queueFullBehavior;
    }
}

