/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.internal.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class MultiMapTryLockCodec {
    public static final int REQUEST_MESSAGE_TYPE = 135424;
    public static final int RESPONSE_MESSAGE_TYPE = 135425;
    private static final int REQUEST_THREAD_ID_FIELD_OFFSET = 16;
    private static final int REQUEST_LEASE_FIELD_OFFSET = 24;
    private static final int REQUEST_TIMEOUT_FIELD_OFFSET = 32;
    private static final int REQUEST_REFERENCE_ID_FIELD_OFFSET = 40;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 48;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 13;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 14;

    private MultiMapTryLockCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data key, long threadId, long lease, long timeout, long referenceId) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("MultiMap.TryLock");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[48], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 135424);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 12, -1);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, threadId);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, lease);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 32, timeout);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 40, referenceId);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, key);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator2.next();
        request.threadId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        request.lease = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        request.timeout = FixedSizeTypesCodec.decodeLong(initialFrame.content, 32);
        request.referenceId = FixedSizeTypesCodec.decodeLong(initialFrame.content, 40);
        request.name = StringCodec.decode(iterator2);
        request.key = DataCodec.decode(iterator2);
        return request;
    }

    public static ClientMessage encodeResponse(boolean response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[14], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 135425);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 13, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static boolean decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator2 = clientMessage.frameIterator();
        ClientMessage.Frame initialFrame = iterator2.next();
        return FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 13);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data key;
        public long threadId;
        public long lease;
        public long timeout;
        public long referenceId;
    }
}

