/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.core.HazelcastJsonValue;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.DataType;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.internal.serialization.impl.DataSerializableSerializer;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.defaultserializers.ArrayBlockingQueueStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.ArrayDequeStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.ArrayListStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.ArrayStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.ConcurrentHashMapStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.ConcurrentSkipListMapStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.ConcurrentSkipListSetStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.ConstantSerializers;
import com.hazelcast.internal.serialization.impl.defaultserializers.CopyOnWriteArrayListStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.CopyOnWriteArraySetStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.DelayQueueStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.HashMapStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.HashSetStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.JavaDefaultSerializers;
import com.hazelcast.internal.serialization.impl.defaultserializers.LinkedBlockingQueueStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.LinkedHashMapStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.LinkedHashSetStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.LinkedListStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.LinkedTransferQueueStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.PriorityBlockingQueueStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.PriorityQueueStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.SynchronousQueueStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.TreeMapStreamSerializer;
import com.hazelcast.internal.serialization.impl.defaultserializers.TreeSetStreamSerializer;
import com.hazelcast.internal.serialization.impl.portable.PortableContext;
import com.hazelcast.internal.serialization.impl.portable.PortableContextImpl;
import com.hazelcast.internal.serialization.impl.portable.PortableHookLoader;
import com.hazelcast.internal.serialization.impl.portable.PortableSerializer;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassNameFilter;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.partition.PartitioningStrategy;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import javax.annotation.Nonnull;

public class SerializationServiceV1
extends AbstractSerializationService {
    private static final int FACTORY_AND_CLASS_ID_BYTE_LENGTH = 8;
    private static final int EE_BYTE_LENGTH = 2;
    private final PortableContextImpl portableContext;
    private final PortableSerializer portableSerializer;

    SerializationServiceV1(AbstractBuilder<?> builder) {
        super(builder);
        PortableHookLoader loader = new PortableHookLoader(((AbstractBuilder)builder).portableFactories, builder.getClassLoader());
        this.portableContext = new PortableContextImpl(this, ((AbstractBuilder)builder).portableVersion, ((AbstractBuilder)builder).checkClassDefErrors);
        for (ClassDefinition cd : loader.getDefinitions()) {
            this.portableContext.registerClassDefinition(cd);
        }
        this.dataSerializerAdapter = SerializationUtil.createSerializerAdapter(new DataSerializableSerializer(((AbstractBuilder)builder).dataSerializableFactories, builder.getClassLoader()));
        this.portableSerializer = new PortableSerializer(this.portableContext, loader.getFactories());
        this.portableSerializerAdapter = SerializationUtil.createSerializerAdapter(this.portableSerializer);
        this.javaSerializerAdapter = SerializationUtil.createSerializerAdapter(new JavaDefaultSerializers.JavaSerializer(((AbstractBuilder)builder).enableSharedObject, ((AbstractBuilder)builder).enableCompression, ((AbstractBuilder)builder).classNameFilter));
        this.javaExternalizableAdapter = SerializationUtil.createSerializerAdapter(new JavaDefaultSerializers.ExternalizableSerializer(((AbstractBuilder)builder).enableCompression, ((AbstractBuilder)builder).classNameFilter));
        this.registerConstantSerializers(builder.isCompatibility());
        this.registerJavaTypeSerializers(builder.isCompatibility());
    }

    @Override
    public <B extends Data> B toData(Object obj, DataType type) {
        if (type == DataType.NATIVE) {
            throw new IllegalArgumentException("Native data type is not supported");
        }
        return this.toData(obj);
    }

    @Override
    public <B extends Data> B toData(Object obj, DataType type, PartitioningStrategy strategy) {
        if (type == DataType.NATIVE) {
            throw new IllegalArgumentException("Native data type is not supported");
        }
        return this.toData(obj, strategy);
    }

    @Override
    public <B extends Data> B convertData(Data data, DataType type) {
        if (type == DataType.NATIVE) {
            throw new IllegalArgumentException("Native data type is not supported");
        }
        return (B)data;
    }

    @Override
    public InternalGenericRecord readAsInternalGenericRecord(Data data) throws IOException {
        if (data.isPortable()) {
            BufferObjectDataInput in = this.createObjectDataInput(data);
            return this.portableSerializer.readAsInternalGenericRecord(in);
        }
        if (data.isCompact()) {
            return this.compactStreamSerializer.readAsInternalGenericRecord(this.createObjectDataInput(data));
        }
        throw new IllegalArgumentException("Given type does not support query over data, type id " + data.getType());
    }

    @Override
    public Schema extractSchemaFromData(@Nonnull Data data) throws IOException {
        if (!data.isCompact()) {
            throw new IllegalArgumentException("Can not extract schema from given data type " + data.getType());
        }
        return this.compactStreamSerializer.extractSchema(this.createObjectDataInput(data));
    }

    @Override
    public Schema extractSchemaFromObject(@Nonnull Object object) {
        if (!this.isCompactSerializable(object)) {
            throw new IllegalArgumentException("Can not extract schema from given class " + object.getClass());
        }
        return this.compactStreamSerializer.extractSchema(object);
    }

    @Override
    public PortableContext getPortableContext() {
        return this.portableContext;
    }

    private void registerConstantSerializers(boolean isCompatibility) {
        this.registerConstant(this.nullSerializerAdapter);
        if (!isCompatibility) {
            this.registerConstant(this.compactSerializerAdapter);
            this.registerConstant(this.compactWithSchemaSerializerAdapter);
        }
        this.registerConstant(DataSerializable.class, this.dataSerializerAdapter);
        this.registerConstant(Portable.class, this.portableSerializerAdapter);
        this.registerConstant(Byte.class, new ConstantSerializers.ByteSerializer());
        this.registerConstant(Boolean.class, new ConstantSerializers.BooleanSerializer());
        this.registerConstant(Character.class, new ConstantSerializers.CharSerializer());
        this.registerConstant(Short.class, new ConstantSerializers.ShortSerializer());
        this.registerConstant(Integer.class, new ConstantSerializers.IntegerSerializer());
        this.registerConstant(Long.class, new ConstantSerializers.LongSerializer());
        this.registerConstant(Float.class, new ConstantSerializers.FloatSerializer());
        this.registerConstant(Double.class, new ConstantSerializers.DoubleSerializer());
        this.registerConstant(String.class, new ConstantSerializers.StringSerializer());
        if (!isCompatibility) {
            this.registerConstant(UUID.class, new ConstantSerializers.UuidSerializer());
            this.registerConstant(AbstractMap.SimpleEntry.class, new ConstantSerializers.SimpleEntrySerializer());
            this.registerConstant(AbstractMap.SimpleImmutableEntry.class, new ConstantSerializers.SimpleImmutableEntrySerializer());
        }
        this.registerConstant(byte[].class, new ConstantSerializers.TheByteArraySerializer());
        this.registerConstant(boolean[].class, new ConstantSerializers.BooleanArraySerializer());
        this.registerConstant(char[].class, new ConstantSerializers.CharArraySerializer());
        this.registerConstant(short[].class, new ConstantSerializers.ShortArraySerializer());
        this.registerConstant(int[].class, new ConstantSerializers.IntegerArraySerializer());
        this.registerConstant(long[].class, new ConstantSerializers.LongArraySerializer());
        this.registerConstant(float[].class, new ConstantSerializers.FloatArraySerializer());
        this.registerConstant(double[].class, new ConstantSerializers.DoubleArraySerializer());
        this.registerConstant(String[].class, new ConstantSerializers.StringArraySerializer());
    }

    private void registerJavaTypeSerializers(boolean isCompatibility) {
        this.registerConstant(Class.class, new JavaDefaultSerializers.ClassSerializer(isCompatibility));
        if (!isCompatibility) {
            this.registerConstant(Optional.class, new JavaDefaultSerializers.OptionalSerializer());
        }
        this.registerConstant(Date.class, new JavaDefaultSerializers.DateSerializer(isCompatibility));
        this.registerConstant(BigInteger.class, new JavaDefaultSerializers.BigIntegerSerializer(isCompatibility));
        this.registerConstant(BigDecimal.class, new JavaDefaultSerializers.BigDecimalSerializer(isCompatibility));
        if (!isCompatibility) {
            this.registerConstant(Object[].class, new ArrayStreamSerializer());
        }
        this.registerConstant(ArrayList.class, new ArrayListStreamSerializer(isCompatibility));
        this.registerConstant(LinkedList.class, new LinkedListStreamSerializer(isCompatibility));
        if (!isCompatibility) {
            this.registerConstant(CopyOnWriteArrayList.class, new CopyOnWriteArrayListStreamSerializer());
            this.registerConstant(HashMap.class, new HashMapStreamSerializer());
            this.registerConstant(ConcurrentSkipListMap.class, new ConcurrentSkipListMapStreamSerializer());
            this.registerConstant(ConcurrentHashMap.class, new ConcurrentHashMapStreamSerializer());
            this.registerConstant(LinkedHashMap.class, new LinkedHashMapStreamSerializer());
            this.registerConstant(TreeMap.class, new TreeMapStreamSerializer());
            this.registerConstant(HashSet.class, new HashSetStreamSerializer());
            this.registerConstant(TreeSet.class, new TreeSetStreamSerializer());
            this.registerConstant(LinkedHashSet.class, new LinkedHashSetStreamSerializer());
            this.registerConstant(CopyOnWriteArraySet.class, new CopyOnWriteArraySetStreamSerializer());
            this.registerConstant(ConcurrentSkipListSet.class, new ConcurrentSkipListSetStreamSerializer());
            this.registerConstant(ArrayDeque.class, new ArrayDequeStreamSerializer());
            this.registerConstant(LinkedBlockingQueue.class, new LinkedBlockingQueueStreamSerializer());
            this.registerConstant(ArrayBlockingQueue.class, new ArrayBlockingQueueStreamSerializer());
            this.registerConstant(PriorityBlockingQueue.class, new PriorityBlockingQueueStreamSerializer());
            this.registerConstant(PriorityQueue.class, new PriorityQueueStreamSerializer());
            this.registerConstant(DelayQueue.class, new DelayQueueStreamSerializer());
            this.registerConstant(SynchronousQueue.class, new SynchronousQueueStreamSerializer());
            this.registerConstant(LinkedTransferQueue.class, new LinkedTransferQueueStreamSerializer());
            this.registerConstant(LocalTime.class, new JavaDefaultSerializers.LocalTimeSerializer());
            this.registerConstant(LocalDate.class, new JavaDefaultSerializers.LocalDateSerializer());
            this.registerConstant(LocalDateTime.class, new JavaDefaultSerializers.LocalDateTimeSerializer());
            this.registerConstant(OffsetDateTime.class, new JavaDefaultSerializers.OffsetDateTimeSerializer());
        }
        if (isCompatibility) {
            this.registerConstant(Enum.class, new JavaDefaultSerializers.EnumSerializer());
        }
        this.safeRegister(Serializable.class, this.javaSerializerAdapter);
        this.safeRegister(Externalizable.class, this.javaExternalizableAdapter);
        this.safeRegister(HazelcastJsonValue.class, new JavaDefaultSerializers.HazelcastJsonValueSerializer());
    }

    public void registerClassDefinitions(Collection<ClassDefinition> classDefinitions) {
        Map<Integer, Map<Integer, ClassDefinition>> factoryMap = MapUtil.createHashMap(classDefinitions.size());
        for (ClassDefinition cd : classDefinitions) {
            int classId;
            int factoryId = cd.getFactoryId();
            Map classDefMap = factoryMap.computeIfAbsent(factoryId, k -> new HashMap());
            if (classDefMap.containsKey(classId = cd.getClassId())) {
                throw new HazelcastSerializationException("Duplicate registration found for factory-id : " + factoryId + ", class-id " + classId);
            }
            classDefMap.put(classId, cd);
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            this.registerClassDefinition(classDefinition, factoryMap);
        }
    }

    private void registerClassDefinition(ClassDefinition cd, Map<Integer, Map<Integer, ClassDefinition>> factoryMap) {
        Set<String> fieldNames = cd.getFieldNames();
        for (String fieldName : fieldNames) {
            ClassDefinition nestedCd;
            FieldDefinition fd = cd.getField(fieldName);
            if (fd.getType() != FieldType.PORTABLE && fd.getType() != FieldType.PORTABLE_ARRAY) continue;
            int factoryId = fd.getFactoryId();
            int classId = fd.getClassId();
            Map<Integer, ClassDefinition> classDefinitionMap = factoryMap.get(factoryId);
            if (classDefinitionMap != null && (nestedCd = classDefinitionMap.get(classId)) != null) {
                this.registerClassDefinition(nestedCd, factoryMap);
                this.portableContext.registerClassDefinition(nestedCd);
                continue;
            }
            if (!this.portableContext.shouldCheckClassDefinitionErrors()) continue;
            throw new HazelcastSerializationException("Could not find registered ClassDefinition for factory-id : " + factoryId + ", class-id " + classId);
        }
        this.portableContext.registerClassDefinition(cd);
    }

    public final PortableSerializer getPortableSerializer() {
        return this.portableSerializer;
    }

    public ObjectDataInput initDataSerializableInputAndSkipTheHeader(Data data) throws IOException {
        BufferObjectDataInput input2 = this.createObjectDataInput(data);
        byte header = input2.readByte();
        if (DataSerializableSerializer.isFlagSet(header, (byte)1)) {
            this.skipBytesSafely(input2, 8);
        } else {
            input2.readString();
        }
        if (DataSerializableSerializer.isFlagSet(header, (byte)2)) {
            this.skipBytesSafely(input2, 2);
        }
        return input2;
    }

    public static Builder builder() {
        return new Builder();
    }

    private void skipBytesSafely(ObjectDataInput input2, int count2) throws IOException {
        if (input2.skipBytes(count2) != count2) {
            throw new HazelcastSerializationException("Malformed serialization format");
        }
    }

    public static final class Builder
    extends AbstractBuilder<Builder> {
        protected Builder() {
        }

        @Override
        protected Builder self() {
            return this;
        }

        public SerializationServiceV1 build() {
            return new SerializationServiceV1(this);
        }
    }

    public static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
    extends AbstractSerializationService.Builder<T> {
        private int portableVersion;
        private Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories = Collections.emptyMap();
        private Map<Integer, ? extends PortableFactory> portableFactories = Collections.emptyMap();
        private boolean enableCompression;
        private boolean enableSharedObject;
        private ClassNameFilter classNameFilter;
        private boolean checkClassDefErrors;

        protected AbstractBuilder() {
        }

        public final T withPortableVersion(int portableVersion) {
            this.portableVersion = portableVersion;
            return (T)((AbstractBuilder)this.self());
        }

        public final T withDataSerializableFactories(Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories) {
            this.dataSerializableFactories = dataSerializableFactories;
            return (T)((AbstractBuilder)this.self());
        }

        public Map<Integer, ? extends DataSerializableFactory> getDataSerializableFactories() {
            return this.dataSerializableFactories;
        }

        public final T withPortableFactories(Map<Integer, ? extends PortableFactory> portableFactories) {
            this.portableFactories = portableFactories;
            return (T)((AbstractBuilder)this.self());
        }

        public final T withEnableCompression(boolean enableCompression) {
            this.enableCompression = enableCompression;
            return (T)((AbstractBuilder)this.self());
        }

        public final T withEnableSharedObject(boolean enableSharedObject) {
            this.enableSharedObject = enableSharedObject;
            return (T)((AbstractBuilder)this.self());
        }

        public final T withClassNameFilter(ClassNameFilter classNameFilter) {
            this.classNameFilter = classNameFilter;
            return (T)((AbstractBuilder)this.self());
        }

        public final T withCheckClassDefErrors(boolean checkClassDefErrors) {
            this.checkClassDefErrors = checkClassDefErrors;
            return (T)((AbstractBuilder)this.self());
        }
    }
}

