/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.seatunnel.engine.checkpoint.storage.PipelineState;
import org.apache.seatunnel.engine.checkpoint.storage.api.CheckpointStorage;
import org.apache.seatunnel.engine.checkpoint.storage.common.ProtoStuffSerializer;
import org.apache.seatunnel.engine.checkpoint.storage.common.Serializer;
import org.apache.seatunnel.engine.checkpoint.storage.common.StorageThreadFactory;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCheckpointStorage
implements CheckpointStorage {
    private static final Logger log = LoggerFactory.getLogger(AbstractCheckpointStorage.class);
    private final Serializer serializer = new ProtoStuffSerializer();
    public static final String DEFAULT_CHECKPOINT_FILE_PATH_SPLIT = "/";
    private String storageNameSpace = "/seatunnel/checkpoint/";
    public static final String FILE_NAME_SPLIT = "-";
    public static final int FILE_NAME_PIPELINE_ID_INDEX = 2;
    public static final int FILE_NAME_CHECKPOINT_ID_INDEX = 3;
    public static final int FILE_SORT_ID_INDEX = 0;
    public static final int FILE_NAME_RANDOM_RANGE = 1000;
    public static final String FILE_FORMAT = "ser";
    private volatile ExecutorService executorService;
    private static final int DEFAULT_THREAD_POOL_MIN_SIZE = Runtime.getRuntime().availableProcessors() * 2 + 1;
    private static final int DEFAULT_THREAD_POOL_MAX_SIZE = Runtime.getRuntime().availableProcessors() * 4 + 1;
    private static final int DEFAULT_THREAD_POOL_QUENE_SIZE = 1024;

    public abstract void initStorage(Map<String, String> var1) throws CheckpointStorageException;

    public String getStorageParentDirectory() {
        return this.storageNameSpace;
    }

    public String getCheckPointName(PipelineState state) {
        return System.nanoTime() + FILE_NAME_SPLIT + ThreadLocalRandom.current().nextInt(1000) + FILE_NAME_SPLIT + state.getPipelineId() + FILE_NAME_SPLIT + state.getCheckpointId() + "." + FILE_FORMAT;
    }

    public byte[] serializeCheckPointData(PipelineState state) throws IOException {
        return this.serializer.serialize(state);
    }

    public PipelineState deserializeCheckPointData(byte[] data) throws IOException {
        return this.serializer.deserialize(data, PipelineState.class);
    }

    public void setStorageNameSpace(String storageNameSpace) {
        if (storageNameSpace != null) {
            this.storageNameSpace = storageNameSpace;
        }
    }

    public Set<String> getLatestPipelineNames(List<String> fileNames) {
        HashMap<String, String> latestPipelineMap = new HashMap<String, String>();
        fileNames.forEach(fileName -> {
            String[] fileNameSegments = fileName.split(FILE_NAME_SPLIT);
            long fileVersion = Long.parseLong(fileNameSegments[0]);
            String filePipelineId = fileNameSegments[2];
            if (latestPipelineMap.containsKey(filePipelineId)) {
                long oldVersion = Long.parseLong(((String)latestPipelineMap.get(filePipelineId)).split(FILE_NAME_SPLIT)[0]);
                if (fileVersion > oldVersion) {
                    latestPipelineMap.put(filePipelineId, (String)fileName);
                }
            } else {
                latestPipelineMap.put(filePipelineId, (String)fileName);
            }
        });
        HashSet<String> latestPipelines = new HashSet<String>(latestPipelineMap.size());
        latestPipelineMap.forEach((pipelineId, fileName) -> latestPipelines.add((String)fileName));
        return latestPipelines;
    }

    public String getLatestCheckpointFileNameByJobIdAndPipelineId(List<String> fileNames, String pipelineId) {
        AtomicReference latestFileName = new AtomicReference();
        AtomicLong latestVersion = new AtomicLong();
        fileNames.forEach(fileName -> {
            String[] fileNameSegments = fileName.split(FILE_NAME_SPLIT);
            long fileVersion = Long.parseLong(fileNameSegments[0]);
            String filePipelineId = fileNameSegments[2];
            if (pipelineId.equals(filePipelineId) && fileVersion > latestVersion.get()) {
                latestVersion.set(fileVersion);
                latestFileName.set(fileName);
            }
        });
        return (String)latestFileName.get();
    }

    public String getPipelineIdByFileName(String fileName) {
        return fileName.split(FILE_NAME_SPLIT)[2];
    }

    public String getCheckpointIdByFileName(String fileName) {
        return fileName.split(FILE_NAME_SPLIT)[3].split("\\.")[0];
    }

    @Override
    public void asyncStoreCheckPoint(PipelineState state) {
        this.initExecutor();
        this.executorService.submit(() -> {
            try {
                this.storeCheckPoint(state);
            }
            catch (Exception e) {
                log.error(String.format("store checkpoint failed, job id : %s, pipeline id : %d", state.getJobId(), state.getPipelineId()), e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initExecutor() {
        if (null == this.executorService || this.executorService.isShutdown()) {
            AbstractCheckpointStorage abstractCheckpointStorage = this;
            synchronized (abstractCheckpointStorage) {
                if (null == this.executorService || this.executorService.isShutdown()) {
                    this.executorService = new ThreadPoolExecutor(DEFAULT_THREAD_POOL_MIN_SIZE, DEFAULT_THREAD_POOL_MAX_SIZE, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(1024), new StorageThreadFactory());
                }
            }
        }
    }
}

