/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.client;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.logging.ILogger;
import lombok.NonNull;
import org.apache.seatunnel.engine.client.SeaTunnelClientInstance;
import org.apache.seatunnel.engine.client.SeaTunnelHazelcastClient;
import org.apache.seatunnel.engine.client.job.JobClient;
import org.apache.seatunnel.engine.client.job.JobExecutionEnvironment;
import org.apache.seatunnel.engine.common.config.JobConfig;
import org.apache.seatunnel.engine.core.protocol.codec.SeaTunnelPrintMessageCodec;

public class SeaTunnelClient
implements SeaTunnelClientInstance {
    private final SeaTunnelHazelcastClient hazelcastClient;

    public SeaTunnelClient(@NonNull ClientConfig clientConfig) {
        if (clientConfig == null) {
            throw new NullPointerException("clientConfig is marked @NonNull but is null");
        }
        this.hazelcastClient = new SeaTunnelHazelcastClient(clientConfig);
    }

    @Override
    public JobExecutionEnvironment createExecutionContext(@NonNull String filePath, JobConfig jobConfig) {
        if (filePath == null) {
            throw new NullPointerException("filePath is marked @NonNull but is null");
        }
        return new JobExecutionEnvironment(jobConfig, filePath, this.hazelcastClient);
    }

    @Override
    public JobClient createJobClient() {
        return new JobClient(this.hazelcastClient);
    }

    @Override
    public void close() {
        this.hazelcastClient.getHazelcastInstance().shutdown();
    }

    public ILogger getLogger() {
        return this.hazelcastClient.getLogger(this.getClass());
    }

    public String printMessageToMaster(@NonNull String msg) {
        if (msg == null) {
            throw new NullPointerException("msg is marked @NonNull but is null");
        }
        return (String)this.hazelcastClient.requestOnMasterAndDecodeResponse(SeaTunnelPrintMessageCodec.encodeRequest(msg), SeaTunnelPrintMessageCodec::decodeResponse);
    }

    public void shutdown() {
        if (this.hazelcastClient != null) {
            this.hazelcastClient.shutdown();
        }
    }
}

