/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.NodeEngineImpl;
import java.util.HashMap;
import java.util.Map;
import org.apache.seatunnel.engine.server.SeaTunnelServer;

class NodeExtensionCommon {
    private static final String ST_LOGO = "                                                         \n _____               _____                             _ \n/  ___|             |_   _|                           | |\n\\ `--.   ___   __ _   | |   _   _  _ __   _ __    ___ | |\n `--. \\ / _ \\ / _` |  | |  | | | || '_ \\ | '_ \\  / _ \\| |\n/\\__/ /|  __/| (_| |  | |  | |_| || | | || | | ||  __/| |\n\\____/  \\___| \\__,_|  \\_/   \\__,_||_| |_||_| |_| \\___||_|\n                                                         \n";
    private static final String COPYRIGHT_LINE = "Copyright \u00a9 2021-2022 The Apache Software Foundation. Apache SeaTunnel, SeaTunnel, and its feather logo are trademarks of The Apache Software Foundation.";
    private final Node node;
    private final ILogger logger;
    private final SeaTunnelServer server;

    NodeExtensionCommon(Node node, SeaTunnelServer server) {
        this.node = node;
        this.logger = node.getLogger(this.getClass().getName());
        this.server = server;
    }

    void afterStart() {
    }

    void beforeClusterStateChange(ClusterState requestedState) {
        if (requestedState != ClusterState.PASSIVE) {
            return;
        }
        this.logger.info("st is preparing to enter the PASSIVE cluster state");
        NodeEngineImpl ne = this.node.nodeEngine;
    }

    void onClusterStateChange(ClusterState ignored) {
    }

    void printNodeInfo(ILogger log, String addToProductName) {
        log.info(this.imdgVersionMessage());
        log.info(this.clusterNameMessage());
        log.fine(this.serializationVersionMessage());
        log.info("\n                                                         \n _____               _____                             _ \n/  ___|             |_   _|                           | |\n\\ `--.   ___   __ _   | |   _   _  _ __   _ __    ___ | |\n `--. \\ / _ \\ / _` |  | |  | | | || '_ \\ | '_ \\  / _ \\| |\n/\\__/ /|  __/| (_| |  | |  | |_| || | | || | | ||  __/| |\n\\____/  \\___| \\__,_|  \\_/   \\__,_||_| |_||_| |_| \\___||_|\n                                                         \n");
        log.info(COPYRIGHT_LINE);
    }

    private String imdgVersionMessage() {
        String build = this.node.getBuildInfo().getBuild();
        String revision = this.node.getBuildInfo().getRevision();
        if (!revision.isEmpty()) {
            build = build + " - " + revision;
        }
        return "Based on Hazelcast IMDG version: " + this.node.getVersion() + " (" + build + ")";
    }

    private String serializationVersionMessage() {
        return "Configured Hazelcast Serialization version: " + this.node.getBuildInfo().getSerializationVersion();
    }

    private String clusterNameMessage() {
        return "Cluster name: " + this.node.getConfig().getClusterName();
    }

    Map<String, Object> createExtensionServices() {
        HashMap<String, Object> extensionServices = new HashMap<String, Object>();
        extensionServices.put("st:impl:seaTunnelServer", this.server);
        return extensionServices;
    }
}

