/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint.operation;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.CheckpointDataSerializerHook;
import org.apache.seatunnel.engine.server.task.operation.TaskOperation;
import org.apache.seatunnel.engine.server.task.record.Barrier;

public class CheckpointBarrierTriggerOperation
extends TaskOperation {
    protected Barrier barrier;

    public CheckpointBarrierTriggerOperation(Barrier barrier, TaskLocation taskLocation) {
        super(taskLocation);
        this.barrier = barrier;
    }

    @Override
    public int getFactoryId() {
        return CheckpointDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.barrier);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.barrier = (Barrier)in.readObject();
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        RetryUtils.retryWithException(() -> {
            Object task = server.getTaskExecutionService().getExecutionContext(this.taskLocation.getTaskGroupLocation()).getTaskGroup().getTask(this.taskLocation.getTaskID());
            try {
                task.triggerBarrier(this.barrier);
            }
            catch (Exception e) {
                ExceptionUtil.sneakyThrow(e);
            }
            return null;
        }, new RetryUtils.RetryMaterial(5, true, exception -> exception instanceof NullPointerException && !server.taskIsEnded(this.taskLocation.getTaskGroupLocation()), 2000L));
    }

    public CheckpointBarrierTriggerOperation() {
    }
}

