/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.dag.physical;

import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.IMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.common.utils.ExceptionUtils;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.job.JobImmutableInformation;
import org.apache.seatunnel.engine.core.job.PipelineStatus;
import org.apache.seatunnel.engine.server.dag.physical.PhysicalVertex;
import org.apache.seatunnel.engine.server.dag.physical.PipelineLocation;
import org.apache.seatunnel.engine.server.execution.ExecutionState;
import org.apache.seatunnel.engine.server.execution.TaskExecutionState;
import org.apache.seatunnel.engine.server.master.JobMaster;

public class SubPlan {
    private static final ILogger LOGGER = Logger.getLogger(SubPlan.class);
    private final List<PhysicalVertex> physicalVertexList;
    private final List<PhysicalVertex> coordinatorVertexList;
    private final int pipelineId;
    private final int totalPipelineNum;
    private final JobImmutableInformation jobImmutableInformation;
    private AtomicInteger finishedTaskNum = new AtomicInteger(0);
    private AtomicInteger canceledTaskNum = new AtomicInteger(0);
    private AtomicInteger failedTaskNum = new AtomicInteger(0);
    private final String pipelineFullName;
    private final IMap<Object, Object> runningJobStateIMap;
    private final IMap<Object, Long[]> runningJobStateTimestampsIMap;
    private CompletableFuture<PipelineStatus> pipelineFuture;
    private final PipelineLocation pipelineLocation;
    private final ExecutorService executorService;
    private JobMaster jobMaster;
    private PassiveCompletableFuture<Void> reSchedulerPipelineFuture;
    private Integer pipelineRestoreNum;

    public SubPlan(int pipelineId, int totalPipelineNum, long initializationTimestamp, @NonNull List<PhysicalVertex> physicalVertexList, @NonNull List<PhysicalVertex> coordinatorVertexList, @NonNull JobImmutableInformation jobImmutableInformation, @NonNull ExecutorService executorService, @NonNull IMap runningJobStateIMap, @NonNull IMap runningJobStateTimestampsIMap) {
        if (physicalVertexList == null) {
            throw new NullPointerException("physicalVertexList is marked @NonNull but is null");
        }
        if (coordinatorVertexList == null) {
            throw new NullPointerException("coordinatorVertexList is marked @NonNull but is null");
        }
        if (jobImmutableInformation == null) {
            throw new NullPointerException("jobImmutableInformation is marked @NonNull but is null");
        }
        if (executorService == null) {
            throw new NullPointerException("executorService is marked @NonNull but is null");
        }
        if (runningJobStateIMap == null) {
            throw new NullPointerException("runningJobStateIMap is marked @NonNull but is null");
        }
        if (runningJobStateTimestampsIMap == null) {
            throw new NullPointerException("runningJobStateTimestampsIMap is marked @NonNull but is null");
        }
        this.pipelineId = pipelineId;
        this.pipelineLocation = new PipelineLocation(jobImmutableInformation.getJobId(), pipelineId);
        this.pipelineFuture = new CompletableFuture();
        this.totalPipelineNum = totalPipelineNum;
        this.physicalVertexList = physicalVertexList;
        this.coordinatorVertexList = coordinatorVertexList;
        this.pipelineRestoreNum = 0;
        Long[] stateTimestamps = new Long[PipelineStatus.values().length];
        if (runningJobStateTimestampsIMap.get(this.pipelineLocation) == null) {
            stateTimestamps[PipelineStatus.INITIALIZING.ordinal()] = initializationTimestamp;
            runningJobStateTimestampsIMap.put(this.pipelineLocation, stateTimestamps);
        }
        if (runningJobStateIMap.get(this.pipelineLocation) == null) {
            stateTimestamps[PipelineStatus.CREATED.ordinal()] = System.currentTimeMillis();
            runningJobStateTimestampsIMap.put(this.pipelineLocation, stateTimestamps);
            runningJobStateIMap.put(this.pipelineLocation, PipelineStatus.CREATED);
        }
        this.jobImmutableInformation = jobImmutableInformation;
        this.pipelineFullName = String.format("Job %s (%s), Pipeline: [(%d/%d)]", jobImmutableInformation.getJobConfig().getName(), jobImmutableInformation.getJobId(), pipelineId, totalPipelineNum);
        this.runningJobStateIMap = runningJobStateIMap;
        this.runningJobStateTimestampsIMap = runningJobStateTimestampsIMap;
        this.executorService = executorService;
    }

    public PassiveCompletableFuture<PipelineStatus> initStateFuture() {
        this.physicalVertexList.stream().forEach(physicalVertex -> this.addPhysicalVertexCallBack(physicalVertex.initStateFuture()));
        this.coordinatorVertexList.stream().forEach(coordinator -> this.addPhysicalVertexCallBack(coordinator.initStateFuture()));
        this.pipelineFuture = new CompletableFuture();
        return new PassiveCompletableFuture<PipelineStatus>(this.pipelineFuture);
    }

    private void addPhysicalVertexCallBack(PassiveCompletableFuture<TaskExecutionState> future) {
        future.thenAcceptAsync(executionState -> {
            try {
                if (ExecutionState.CANCELED.equals(executionState.getExecutionState())) {
                    this.canceledTaskNum.incrementAndGet();
                } else if (ExecutionState.FAILED.equals(executionState.getExecutionState())) {
                    LOGGER.severe(String.format("Task %s Failed in %s, Begin to cancel other tasks in this pipeline.", executionState.getTaskGroupLocation(), this.getPipelineFullName()));
                    this.failedTaskNum.incrementAndGet();
                    this.cancelPipeline();
                }
                if (this.finishedTaskNum.incrementAndGet() == this.physicalVertexList.size() + this.coordinatorVertexList.size()) {
                    if (this.failedTaskNum.get() > 0) {
                        this.turnToEndState(PipelineStatus.FAILED);
                        LOGGER.info(String.format("%s end with state FAILED", this.pipelineFullName));
                    } else if (this.canceledTaskNum.get() > 0) {
                        this.turnToEndState(PipelineStatus.CANCELED);
                        LOGGER.info(String.format("%s end with state CANCELED", this.pipelineFullName));
                    } else {
                        this.turnToEndState(PipelineStatus.FINISHED);
                        LOGGER.info(String.format("%s end with state FINISHED", this.pipelineFullName));
                    }
                    this.pipelineFuture.complete((PipelineStatus)((Object)((Object)this.runningJobStateIMap.get(this.pipelineLocation))));
                }
            }
            catch (Throwable e) {
                LOGGER.severe(String.format("Never come here. handle %s %s error", executionState.getTaskGroupLocation(), executionState.getExecutionState()), e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void turnToEndState(@NonNull PipelineStatus endState) {
        if (endState == null) {
            throw new NullPointerException("endState is marked @NonNull but is null");
        }
        SubPlan subPlan = this;
        synchronized (subPlan) {
            PipelineStatus current = (PipelineStatus)((Object)this.runningJobStateIMap.get(this.pipelineLocation));
            if (current.isEndState()) {
                String message = "Pipeline is trying to leave terminal state " + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (!endState.isEndState()) {
                String message = "Need a end state, not " + (Object)((Object)endState);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            this.updateStateTimestamps(endState);
            this.runningJobStateIMap.set(this.pipelineLocation, (Object)endState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatePipelineState(@NonNull PipelineStatus current, @NonNull PipelineStatus targetState) {
        if (current == null) {
            throw new NullPointerException("current is marked @NonNull but is null");
        }
        if (targetState == null) {
            throw new NullPointerException("targetState is marked @NonNull but is null");
        }
        SubPlan subPlan = this;
        synchronized (subPlan) {
            if (current.isEndState()) {
                String message = "Pipeline is trying to leave terminal state " + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (PipelineStatus.SCHEDULED.equals((Object)targetState) && !PipelineStatus.CREATED.equals((Object)current)) {
                String message = "Only [CREATED] pipeline can turn to [SCHEDULED]" + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (PipelineStatus.DEPLOYING.equals((Object)targetState) && !PipelineStatus.SCHEDULED.equals((Object)current)) {
                String message = "Only [SCHEDULED] pipeline can turn to [DEPLOYING]" + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (PipelineStatus.RUNNING.equals((Object)targetState) && !PipelineStatus.DEPLOYING.equals((Object)current)) {
                String message = "Only [DEPLOYING] pipeline can turn to [RUNNING]" + (Object)((Object)current);
                LOGGER.severe(message);
                throw new IllegalStateException(message);
            }
            if (current.equals(this.runningJobStateIMap.get(this.pipelineLocation))) {
                LOGGER.info(String.format("%s turn from state %s to %s.", new Object[]{this.pipelineFullName, current, targetState}));
                this.updateStateTimestamps(targetState);
                this.runningJobStateIMap.set(this.pipelineLocation, (Object)targetState);
                return true;
            }
            return false;
        }
    }

    public void cancelPipeline() {
        if (this.getPipelineState().isEndState()) {
            LOGGER.warning(String.format("%s is in end state %s, can not be cancel", new Object[]{this.pipelineFullName, this.getPipelineState()}));
            return;
        }
        if (!PipelineStatus.CANCELING.equals((Object)((PipelineStatus)((Object)this.runningJobStateIMap.get(this.pipelineLocation))))) {
            this.updatePipelineState(this.getPipelineState(), PipelineStatus.CANCELING);
        }
        this.cancelPipelineTasks();
    }

    private void cancelPipelineTasks() {
        List<CompletableFuture> coordinatorCancelList = this.coordinatorVertexList.stream().map(coordinator -> this.cancelTask((PhysicalVertex)coordinator)).filter(x -> x != null).collect(Collectors.toList());
        List taskCancelList = this.physicalVertexList.stream().map(task -> this.cancelTask((PhysicalVertex)task)).filter(x -> x != null).collect(Collectors.toList());
        try {
            coordinatorCancelList.addAll(taskCancelList);
            CompletableFuture<Void> voidCompletableFuture = CompletableFuture.allOf(coordinatorCancelList.toArray(new CompletableFuture[coordinatorCancelList.size()]));
            voidCompletableFuture.get();
        }
        catch (Exception e) {
            LOGGER.severe(String.format("%s cancel error with exception: %s", this.pipelineFullName, ExceptionUtils.getMessage(e)));
        }
    }

    private CompletableFuture<Void> cancelTask(@NonNull PhysicalVertex task) {
        if (task == null) {
            throw new NullPointerException("task is marked @NonNull but is null");
        }
        if (!task.getExecutionState().isEndState() && !ExecutionState.CANCELING.equals(task.getExecutionState())) {
            CompletableFuture<Void> future = CompletableFuture.supplyAsync(() -> {
                task.cancel();
                return null;
            }, this.executorService);
            return future;
        }
        return null;
    }

    private void reset() {
        this.resetPipelineState();
        this.finishedTaskNum.set(0);
        this.canceledTaskNum.set(0);
        this.failedTaskNum.set(0);
        this.coordinatorVertexList.forEach(coordinate -> coordinate.reset());
        this.physicalVertexList.forEach(task -> task.reset());
    }

    private void updateStateTimestamps(@NonNull PipelineStatus targetState) {
        if (targetState == null) {
            throw new NullPointerException("targetState is marked @NonNull but is null");
        }
        Long[] stateTimestamps = this.runningJobStateTimestampsIMap.get(this.pipelineLocation);
        stateTimestamps[targetState.ordinal()] = System.currentTimeMillis();
        this.runningJobStateTimestampsIMap.set(this.pipelineLocation, stateTimestamps);
    }

    private void resetPipelineState() {
        PipelineStatus pipelineState = this.getPipelineState();
        if (!pipelineState.isEndState()) {
            String message = String.format("%s reset state failed, only end state can be reset, current is %s", new Object[]{this.getPipelineFullName(), pipelineState});
            LOGGER.severe(message);
            throw new IllegalStateException(message);
        }
        this.updateStateTimestamps(PipelineStatus.CREATED);
        this.runningJobStateIMap.set(this.pipelineLocation, (Object)PipelineStatus.CREATED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restorePipeline() {
        Integer n = this.pipelineRestoreNum;
        synchronized (n) {
            try {
                Integer n2 = this.pipelineRestoreNum;
                Integer n3 = this.pipelineRestoreNum = Integer.valueOf(this.pipelineRestoreNum + 1);
                LOGGER.info(String.format("Restore pipeline %s", this.pipelineFullName));
                if (this.jobMaster.getScheduleFuture() != null) {
                    this.jobMaster.getScheduleFuture().join();
                }
                if (this.reSchedulerPipelineFuture != null) {
                    this.reSchedulerPipelineFuture.join();
                }
                this.reset();
                this.jobMaster.getPhysicalPlan().addPipelineEndCallback(this);
                if (this.jobMaster.getCheckpointManager().isCompletedPipeline(this.pipelineId)) {
                    this.forcePipelineFinish();
                    return;
                }
                this.reSchedulerPipelineFuture = this.jobMaster.reSchedulerPipeline(this);
                if (this.reSchedulerPipelineFuture != null) {
                    this.reSchedulerPipelineFuture.join();
                }
            }
            catch (Throwable e) {
                LOGGER.severe(String.format("Restore pipeline %s error with exception: %s", this.pipelineFullName, ExceptionUtils.getMessage(e)));
                this.cancelPipeline();
            }
        }
    }

    private void forcePipelineFinish() {
        this.coordinatorVertexList.forEach(coordinator -> coordinator.updateTaskExecutionState(new TaskExecutionState(coordinator.getTaskGroupLocation(), ExecutionState.FINISHED, null)));
        this.physicalVertexList.forEach(task -> task.updateTaskExecutionState(new TaskExecutionState(task.getTaskGroupLocation(), ExecutionState.FINISHED, null)));
    }

    public void restorePipelineState() {
        if (this.getPipelineState().ordinal() < PipelineStatus.RUNNING.ordinal()) {
            this.restorePipeline();
        } else if (PipelineStatus.CANCELING.equals((Object)this.getPipelineState())) {
            this.cancelPipelineTasks();
        } else if (PipelineStatus.RUNNING.equals((Object)this.getPipelineState())) {
            this.jobMaster.getCheckpointManager().reportedPipelineRunning(this.getPipelineLocation().getPipelineId());
        }
    }

    public List<PhysicalVertex> getPhysicalVertexList() {
        return this.physicalVertexList;
    }

    public List<PhysicalVertex> getCoordinatorVertexList() {
        return this.coordinatorVertexList;
    }

    public String getPipelineFullName() {
        return this.pipelineFullName;
    }

    public PipelineStatus getPipelineState() {
        return (PipelineStatus)((Object)this.runningJobStateIMap.get(this.pipelineLocation));
    }

    public PipelineLocation getPipelineLocation() {
        return this.pipelineLocation;
    }

    public void setJobMaster(JobMaster jobMaster) {
        this.jobMaster = jobMaster;
        this.coordinatorVertexList.forEach(coordinator -> coordinator.setJobMaster(jobMaster));
        this.physicalVertexList.forEach(task -> task.setJobMaster(jobMaster));
    }

    public int getPipelineRestoreNum() {
        return this.pipelineRestoreNum;
    }
}

