/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.transformer;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.context.IntegrationContextUtils;
import org.springframework.integration.expression.FunctionExpression;
import org.springframework.integration.expression.ValueExpression;
import org.springframework.integration.transformer.AbstractTransformer;
import org.springframework.integration.transformer.MessageTransformationException;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.ProtobufMessageConverter;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public class FromProtobufTransformer
extends AbstractTransformer
implements BeanClassLoaderAware {
    private final ProtobufMessageConverter protobufMessageConverter;
    private ClassLoader beanClassLoader;
    private Expression expectedTypeExpression = new FunctionExpression<Message>(message -> message.getHeaders().get((Object)"proto_type"));
    private EvaluationContext evaluationContext;

    public FromProtobufTransformer() {
        this(new ProtobufMessageConverter());
    }

    public FromProtobufTransformer(ProtobufMessageConverter protobufMessageConverter) {
        Assert.notNull((Object)protobufMessageConverter, (String)"'protobufMessageConverter' must not be null");
        this.protobufMessageConverter = protobufMessageConverter;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public FromProtobufTransformer setExpectedType(Class<? extends com.google.protobuf.Message> expectedType) {
        return this.setExpectedTypeExpression(new ValueExpression<Class<? extends com.google.protobuf.Message>>(expectedType));
    }

    public FromProtobufTransformer setExpectedTypeExpressionString(String expression) {
        return this.setExpectedTypeExpression(EXPRESSION_PARSER.parseExpression(expression));
    }

    public FromProtobufTransformer setExpectedTypeExpression(Expression expression) {
        Assert.notNull((Object)expression, (String)"'expression' must not be null");
        this.expectedTypeExpression = expression;
        return this;
    }

    @Override
    protected void onInit() {
        this.evaluationContext = IntegrationContextUtils.getEvaluationContext(this.getBeanFactory());
    }

    @Override
    protected Object doTransform(Message<?> message) {
        Class targetClass = null;
        Object value = this.expectedTypeExpression.getValue(this.evaluationContext, message);
        if (value instanceof Class) {
            targetClass = (Class)value;
        } else if (value instanceof String) {
            try {
                targetClass = ClassUtils.forName((String)((String)value), (ClassLoader)this.beanClassLoader);
            }
            catch (ClassNotFoundException | LinkageError e) {
                throw new IllegalStateException(e);
            }
        }
        if (targetClass == null) {
            throw new MessageTransformationException(message, "The 'expectedTypeExpression' (" + this.expectedTypeExpression + ") returned 'null'.");
        }
        return this.protobufMessageConverter.fromMessage(message, targetClass);
    }
}

