/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.common.dto;

import java.util.List;
import java.util.Objects;
import org.apache.shenyu.common.dto.BaseData;
import org.apache.shenyu.common.dto.ConditionData;

public class SelectorData
extends BaseData {
    private String pluginId;
    private String pluginName;
    private Integer matchMode;
    private Integer type;
    private Boolean logged;
    private Boolean continued = Boolean.TRUE;
    private String handle;
    private List<ConditionData> conditionList;
    private List<ConditionData> beforeConditionList;
    private Boolean matchRestful;

    public SelectorData() {
    }

    private SelectorData(Builder builder) {
        this.setId(builder.id);
        this.pluginId = builder.pluginId;
        this.pluginName = builder.pluginName;
        this.setName(builder.name);
        this.matchMode = builder.matchMode;
        this.type = builder.type;
        this.setSort(builder.sort);
        this.setEnabled(builder.enabled);
        this.logged = builder.logged;
        this.continued = builder.continued;
        this.handle = builder.handle;
        this.conditionList = builder.conditionList;
        this.matchRestful = builder.matchRestful;
        this.beforeConditionList = builder.beforeConditionList;
        this.setNamespaceId(builder.namespaceId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public void setPluginId(String pluginId) {
        this.pluginId = pluginId;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String pluginName) {
        this.pluginName = pluginName;
    }

    public Integer getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(Integer matchMode) {
        this.matchMode = matchMode;
    }

    public Integer getType() {
        return this.type;
    }

    public void setType(Integer type) {
        this.type = type;
    }

    public Boolean getLogged() {
        return this.logged;
    }

    public void setLogged(Boolean logged) {
        this.logged = logged;
    }

    public Boolean getContinued() {
        if (Objects.isNull(this.continued)) {
            return true;
        }
        return this.continued;
    }

    public void setContinued(Boolean continued) {
        this.continued = continued;
    }

    public String getHandle() {
        return this.handle;
    }

    public void setHandle(String handle) {
        this.handle = handle;
    }

    public List<ConditionData> getConditionList() {
        return this.conditionList;
    }

    public void setConditionList(List<ConditionData> conditionList) {
        this.conditionList = conditionList;
    }

    public Boolean getMatchRestful() {
        return this.matchRestful;
    }

    public void setMatchRestful(Boolean matchRestful) {
        this.matchRestful = matchRestful;
    }

    public List<ConditionData> getBeforeConditionList() {
        return this.beforeConditionList;
    }

    public void setBeforeConditionList(List<ConditionData> beforeConditionList) {
        this.beforeConditionList = beforeConditionList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        SelectorData that = (SelectorData)o;
        return Objects.equals(this.getId(), that.getId()) && Objects.equals(this.pluginId, that.pluginId) && Objects.equals(this.pluginName, that.pluginName) && Objects.equals(this.getName(), that.getName()) && Objects.equals(this.matchMode, that.matchMode) && Objects.equals(this.type, that.type) && Objects.equals(this.getSort(), that.getSort()) && Objects.equals(this.getEnabled(), that.getEnabled()) && Objects.equals(this.logged, that.logged) && Objects.equals(this.continued, that.continued) && Objects.equals(this.handle, that.handle) && Objects.equals(this.conditionList, that.conditionList) && Objects.equals(this.beforeConditionList, that.beforeConditionList) && Objects.equals(this.matchRestful, that.matchRestful) && Objects.equals(this.getNamespaceId(), that.getNamespaceId());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.pluginId, this.pluginName, this.getName(), this.matchMode, this.type, this.getSort(), this.getEnabled(), this.logged, this.continued, this.handle, this.conditionList, this.beforeConditionList, this.matchRestful, this.getNamespaceId());
    }

    public String toString() {
        return "SelectorData{id='" + this.getId() + "', pluginId='" + this.pluginId + "', pluginName='" + this.pluginName + "', name='" + this.getName() + "', matchMode=" + this.matchMode + ", type=" + this.type + ", sort=" + this.getSort() + ", enabled=" + this.getEnabled() + ", logged=" + this.logged + ", continued=" + this.continued + ", handle='" + this.handle + "', conditionList=" + this.conditionList + ", matchRestful=" + this.matchRestful + ", namespaceId=" + this.getNamespaceId() + "}";
    }

    public static final class Builder {
        private String id;
        private String name;
        private String pluginId;
        private String pluginName;
        private Integer matchMode;
        private Integer type;
        private Integer sort;
        private Boolean enabled;
        private Boolean logged;
        private Boolean continued;
        private String handle;
        private List<ConditionData> conditionList;
        private Boolean matchRestful;
        private List<ConditionData> beforeConditionList;
        private String namespaceId;

        private Builder() {
        }

        public SelectorData build() {
            return new SelectorData(this);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder pluginId(String pluginId) {
            this.pluginId = pluginId;
            return this;
        }

        public Builder pluginName(String pluginName) {
            this.pluginName = pluginName;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder matchMode(Integer matchMode) {
            this.matchMode = matchMode;
            return this;
        }

        public Builder type(Integer type) {
            this.type = type;
            return this;
        }

        public Builder sort(Integer sort) {
            this.sort = sort;
            return this;
        }

        public Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder logged(Boolean logged) {
            this.logged = logged;
            return this;
        }

        public Builder continued(Boolean continued) {
            this.continued = continued;
            return this;
        }

        public Builder handle(String handle) {
            this.handle = handle;
            return this;
        }

        public Builder conditionList(List<ConditionData> conditionList) {
            this.conditionList = conditionList;
            return this;
        }

        public Builder matchRestful(Boolean matchRestful) {
            this.matchRestful = matchRestful;
            return this;
        }

        public Builder beforeConditionList(List<ConditionData> beforeConditionList) {
            this.beforeConditionList = beforeConditionList;
            return this;
        }

        public Builder namespaceId(String namespaceId) {
            this.namespaceId = namespaceId;
            return this;
        }
    }
}

