/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.util;

import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.statistic.base.LeapArray;
import com.alibaba.csp.sentinel.slots.statistic.base.WindowWrap;
import com.alibaba.csp.sentinel.util.function.Tuple2;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;

public final class TimeUtil
implements Runnable {
    private static final long CHECK_INTERVAL = 3000L;
    private static final long HITS_LOWER_BOUNDARY = 800L;
    private static final long HITS_UPPER_BOUNDARY = 1200L;
    private static TimeUtil INSTANCE = new TimeUtil();
    private volatile long currentTimeMillis;
    private volatile STATE state = STATE.IDLE;
    private LeapArray<Statistic> statistics = new LeapArray<Statistic>(3, 3000){

        @Override
        public Statistic newEmptyBucket(long timeMillis) {
            return new Statistic();
        }

        @Override
        protected WindowWrap<Statistic> resetWindowTo(WindowWrap<Statistic> windowWrap, long startTime) {
            Statistic val = windowWrap.value();
            val.getReads().reset();
            val.getWrites().reset();
            windowWrap.resetTo(startTime);
            return windowWrap;
        }
    };
    private long lastCheck = this.currentTimeMillis = System.currentTimeMillis();

    public TimeUtil() {
        Thread daemon = new Thread(this);
        daemon.setDaemon(true);
        daemon.setName("sentinel-time-tick-thread");
        daemon.start();
    }

    @Override
    public void run() {
        while (true) {
            this.check();
            if (this.state == STATE.RUNNING) {
                this.currentTimeMillis = System.currentTimeMillis();
                this.statistics.currentWindow(this.currentTimeMillis).value().getWrites().increment();
                try {
                    TimeUnit.MILLISECONDS.sleep(1L);
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (this.state == STATE.IDLE) {
                try {
                    TimeUnit.MILLISECONDS.sleep(300L);
                }
                catch (Throwable throwable) {}
                continue;
            }
            if (this.state != STATE.PREPARE) continue;
            RecordLog.debug("TimeUtil switches to RUNNING", new Object[0]);
            this.currentTimeMillis = System.currentTimeMillis();
            this.state = STATE.RUNNING;
        }
    }

    public STATE getState() {
        return this.state;
    }

    public Tuple2<Long, Long> currentQps(long now) {
        List<WindowWrap<Statistic>> list = this.statistics.listAll();
        long reads = 0L;
        long writes = 0L;
        int cnt = 0;
        for (WindowWrap<Statistic> windowWrap : list) {
            if (windowWrap.isTimeInWindow(now)) continue;
            ++cnt;
            reads += windowWrap.value().getReads().longValue();
            writes += windowWrap.value().getWrites().longValue();
        }
        if (cnt < 1) {
            return new Tuple2<Long, Long>(0L, 0L);
        }
        return new Tuple2<Long, Long>(reads / (long)cnt, writes / (long)cnt);
    }

    private void check() {
        long now = this.currentTime(true);
        if (now - this.lastCheck < 3000L) {
            return;
        }
        this.lastCheck = now;
        Tuple2<Long, Long> qps = this.currentQps(now);
        if (this.state == STATE.IDLE && (Long)qps.r1 > 1200L) {
            RecordLog.info("TimeUtil switches to PREPARE for better performance, reads={}/s, writes={}/s", qps.r1, qps.r2);
            this.state = STATE.PREPARE;
        } else if (this.state == STATE.RUNNING && (Long)qps.r1 < 800L) {
            RecordLog.info("TimeUtil switches to IDLE due to not enough load, reads={}/s, writes={}/s", qps.r1, qps.r2);
            this.state = STATE.IDLE;
        }
    }

    private long currentTime(boolean innerCall) {
        long now = this.currentTimeMillis;
        Statistic val = this.statistics.currentWindow(now).value();
        if (!innerCall) {
            val.getReads().increment();
        }
        if (this.state == STATE.IDLE || this.state == STATE.PREPARE) {
            this.currentTimeMillis = now = System.currentTimeMillis();
            if (!innerCall) {
                val.getWrites().increment();
            }
        }
        return now;
    }

    public long getTime() {
        return this.currentTime(false);
    }

    public static TimeUtil instance() {
        return INSTANCE;
    }

    public static long currentTimeMillis() {
        return INSTANCE.getTime();
    }

    private static class Statistic {
        private final LongAdder writes = new LongAdder();
        private final LongAdder reads = new LongAdder();

        private Statistic() {
        }

        public LongAdder getWrites() {
            return this.writes;
        }

        public LongAdder getReads() {
            return this.reads;
        }
    }

    public static enum STATE {
        IDLE,
        PREPARE,
        RUNNING;

    }
}

