/*
 * Decompiled with CFR 0.152.
 */
package com.qq.tars.client.rpc;

import com.qq.tars.protocol.util.TarsHelper;
import com.qq.tars.rpc.common.InvokeContext;
import com.qq.tars.rpc.common.Invoker;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class ServantInvokeContext
implements InvokeContext,
Serializable {
    private Invoker<?> invoker;
    private String methodName;
    private Object[] arguments;
    private Class<?>[] parameterTypes;
    private final boolean isAsync;
    private final boolean isPromiseFuture;
    private final boolean isNormal;
    private Map<String, String> attachments;

    public ServantInvokeContext(Method method, Object[] arguments, Map<String, String> attachments) {
        this(method, arguments, attachments, null);
    }

    public ServantInvokeContext(Method method, Object[] arguments, Map<String, String> attachments, Invoker<?> invoker) {
        this.setInvoker(invoker);
        this.setMethodName(method.getName());
        this.setParameterTypes(method.getParameterTypes());
        this.setArguments(arguments);
        this.setAttachments(attachments);
        if (invoker != null) {
            this.addAttachmentsIfAbsent(invoker.getUrl().getParameters());
        }
        this.isAsync = TarsHelper.isAsync(this.methodName);
        this.isPromiseFuture = TarsHelper.isPromiseFuture(this.methodName);
        this.isNormal = !this.isAsync && !this.isPromiseFuture ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean isAsync() {
        return this.isAsync;
    }

    public boolean isPromiseFuture() {
        return this.isPromiseFuture;
    }

    @Override
    public Invoker<?> getInvoker() {
        return this.invoker;
    }

    @Override
    public void setInvoker(Invoker<?> invoker) {
        this.invoker = invoker;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    @Override
    public Object[] getArguments() {
        return this.arguments;
    }

    @Override
    public Map<String, String> getAttachments() {
        return this.attachments;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setParameterTypes(Class<?>[] parameterTypes) {
        this.parameterTypes = parameterTypes == null ? new Class[]{} : parameterTypes;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments == null ? new Object[]{} : arguments;
    }

    public void setAttachments(Map<String, String> attachments) {
        this.attachments = attachments == null ? new HashMap() : attachments;
    }

    public void setAttachment(String key, String value) {
        this.attachments.put(key, value);
    }

    public void setAttachmentIfAbsent(String key, String value) {
        if (!this.attachments.containsKey(key)) {
            this.attachments.put(key, value);
        }
    }

    public void addAttachments(Map<String, String> attachments) {
        this.attachments.putAll(attachments);
    }

    public void addAttachmentsIfAbsent(Map<String, String> attachments) {
        if (attachments == null) {
            return;
        }
        for (Map.Entry<String, String> entry : attachments.entrySet()) {
            this.setAttachmentIfAbsent(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public String getAttachment(String key) {
        return this.attachments.get(key);
    }

    @Override
    public String getAttachment(String key, String defaultValue) {
        String value = this.attachments.get(key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public String toString() {
        return "ServantInvokeContext{methodName='" + this.methodName + '\'' + ", isAsync=" + this.isAsync + ", isPromiseFuture=" + this.isPromiseFuture + '}';
    }

    public boolean isNormal() {
        return this.isNormal;
    }
}

